/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.apache.lucene.index.CompoundFileReader;
import org.apache.lucene.index.CompoundFileWriter;
import org.apache.lucene.index.DualCompoundFileWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;

public abstract class LuceneUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Directory src, boolean srcIsCompound, Directory dest, boolean destIsCompound, byte[] buffer) throws IOException {
        if (!IndexReader.indexExists((Directory)src)) {
            return;
        }
        if (srcIsCompound && destIsCompound || !srcIsCompound && !destIsCompound) {
            String[] names = src.list();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                LuceneUtils.copy(src, dest, name, buffer);
            }
            return;
        }
        SegmentInfos segmentInfos = new SegmentInfos();
        segmentInfos.read(src);
        LuceneUtils.copy(src, dest, "segments", buffer);
        if (segmentInfos.isEmpty()) {
            return;
        }
        ArrayList<String> nonCompoundRelated = new ArrayList<String>();
        nonCompoundRelated.addAll(Arrays.asList(IndexFileNames.INDEX_EXTENSIONS));
        nonCompoundRelated.removeAll(Arrays.asList(IndexFileNames.INDEX_EXTENSIONS_IN_COMPOUND_FILE));
        nonCompoundRelated.remove("cfs");
        for (int segmentIndex = 0; segmentIndex < segmentInfos.size(); ++segmentIndex) {
            int i;
            SegmentInfo segmentInfo = segmentInfos.info(segmentIndex);
            String segment = segmentInfo.name;
            Iterator it = nonCompoundRelated.iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                LuceneUtils.copy(src, dest, segment + "." + name, buffer);
            }
            String cfsName = segment + "." + "cfs";
            if (srcIsCompound && !destIsCompound) {
                segmentInfo.setUseCompoundFile(false);
                CompoundFileReader cfsReader = new CompoundFileReader(src, cfsName);
                try {
                    String[] cfsEntriesNames = cfsReader.list();
                    for (int i2 = 0; i2 < cfsEntriesNames.length; ++i2) {
                        String entryName = cfsEntriesNames[i2];
                        LuceneUtils.copy((Directory)cfsReader, dest, entryName, buffer);
                    }
                    continue;
                }
                finally {
                    cfsReader.close();
                }
            }
            segmentInfo.setUseCompoundFile(true);
            DualCompoundFileWriter cfsWriter = new DualCompoundFileWriter(src, dest, cfsName, buffer);
            FieldInfos fieldInfos = new FieldInfos(src, segment + ".fnm");
            Vector<String> files = new Vector<String>(IndexFileNames.COMPOUND_EXTENSIONS.length + 1);
            for (i = 0; i < IndexFileNames.COMPOUND_EXTENSIONS.length; ++i) {
                files.add(segment + "." + IndexFileNames.COMPOUND_EXTENSIONS[i]);
            }
            for (i = 0; i < fieldInfos.size(); ++i) {
                FieldInfo fi = fieldInfos.fieldInfo(i);
                if (!fi.isIndexed || fi.omitNorms) continue;
                files.add(segment + "." + "nrm");
                break;
            }
            if (fieldInfos.hasVectors()) {
                for (i = 0; i < IndexFileNames.VECTOR_EXTENSIONS.length; ++i) {
                    files.add(segment + "." + IndexFileNames.VECTOR_EXTENSIONS[i]);
                }
            }
            Iterator it2 = files.iterator();
            while (it2.hasNext()) {
                cfsWriter.addFile((String)it2.next());
            }
            cfsWriter.close();
        }
        segmentInfos.write(dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Directory src, Directory dest, String name, byte[] buffer) throws IOException {
        if (!src.fileExists(name)) {
            return;
        }
        IndexInput indexInput = null;
        IndexOutput indexOutput = null;
        try {
            indexInput = src.openInput(name);
            indexOutput = dest.createOutput(name);
            LuceneUtils.copy(indexInput, indexOutput, name, buffer);
        }
        finally {
            if (indexInput != null) {
                indexInput.close();
            }
            if (indexOutput != null) {
                indexOutput.close();
            }
        }
    }

    public static void copy(IndexInput indexInput, IndexOutput indexOutput, String name, byte[] buffer) throws IOException {
        long length;
        long remainder;
        int len;
        int chunk = buffer.length;
        for (remainder = length = indexInput.length(); remainder > 0L; remainder -= (long)len) {
            len = (int)Math.min((long)chunk, remainder);
            indexInput.readBytes(buffer, 0, len);
            indexOutput.writeBytes(buffer, len);
        }
        if (remainder != 0L) {
            throw new IOException("Non-zero remainder length after copying [" + remainder + "] (id [" + name + "] length [" + length + "] buffer size [" + chunk + "])");
        }
    }

    public static boolean isCompound(Directory directory) throws IOException {
        if (!IndexReader.indexExists((Directory)directory)) {
            return true;
        }
        SegmentInfos segmentInfos = new SegmentInfos();
        segmentInfos.read(directory);
        if (segmentInfos.isEmpty()) {
            return true;
        }
        for (int i = 0; i < segmentInfos.size(); ++i) {
            SegmentInfo segmentInfo = segmentInfos.info(i);
            if (segmentInfo.getUseCompoundFile()) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnCompound(Directory directory) throws IOException {
        if (!IndexReader.indexExists((Directory)directory)) {
            return true;
        }
        SegmentInfos segmentInfos = new SegmentInfos();
        segmentInfos.read(directory);
        if (segmentInfos.isEmpty()) {
            return true;
        }
        for (int i = 0; i < segmentInfos.size(); ++i) {
            SegmentInfo segmentInfo = segmentInfos.info(i);
            if (!segmentInfo.getUseCompoundFile()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compoundDirectory(Directory directory, long writeLockTimeout) throws IOException {
        Lock writeLock = directory.makeLock("write.lock");
        if (!writeLock.obtain(writeLockTimeout)) {
            throw new IOException("Index locked for write: " + writeLock);
        }
        try {
            SegmentInfos segmentInfos = new SegmentInfos();
            segmentInfos.read(directory);
            IndexFileDeleter deleter = new IndexFileDeleter(directory, (IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy(), segmentInfos, null);
            for (int infoIndex = 0; infoIndex < segmentInfos.size(); ++infoIndex) {
                int i;
                SegmentInfo segmentInfo = segmentInfos.info(infoIndex);
                segmentInfo.setUseCompoundFile(true);
                String fileName = segmentInfo.name + ".cfs";
                String segment = segmentInfo.name;
                if (directory.fileExists(fileName)) continue;
                CompoundFileWriter cfsWriter = new CompoundFileWriter(directory, fileName);
                FieldInfos fieldInfos = new FieldInfos(directory, segment + ".fnm");
                Vector<String> files = new Vector<String>(IndexFileNames.COMPOUND_EXTENSIONS.length + 1);
                for (i = 0; i < IndexFileNames.COMPOUND_EXTENSIONS.length; ++i) {
                    files.add(segment + "." + IndexFileNames.COMPOUND_EXTENSIONS[i]);
                }
                for (i = 0; i < fieldInfos.size(); ++i) {
                    FieldInfo fi = fieldInfos.fieldInfo(i);
                    if (!fi.isIndexed || fi.omitNorms) continue;
                    files.add(segment + "." + "nrm");
                    break;
                }
                if (fieldInfos.hasVectors()) {
                    for (i = 0; i < IndexFileNames.VECTOR_EXTENSIONS.length; ++i) {
                        files.add(segment + "." + IndexFileNames.VECTOR_EXTENSIONS[i]);
                    }
                }
                Iterator it = files.iterator();
                while (it.hasNext()) {
                    cfsWriter.addFile((String)it.next());
                }
                cfsWriter.close();
            }
            segmentInfos.write(directory);
            deleter.checkpoint(segmentInfos, true);
        }
        finally {
            writeLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unCompoundDirectory(Directory directory, long writeLockTimeout) throws IOException {
        Lock writeLock = directory.makeLock("write.lock");
        if (!writeLock.obtain(writeLockTimeout)) {
            throw new IOException("Index locked for write: " + writeLock);
        }
        try {
            SegmentInfos segmentInfos = new SegmentInfos();
            segmentInfos.read(directory);
            IndexFileDeleter deleter = new IndexFileDeleter(directory, (IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy(), segmentInfos, null);
            for (int infoIndex = 0; infoIndex < segmentInfos.size(); ++infoIndex) {
                SegmentInfo segmentInfo = segmentInfos.info(infoIndex);
                segmentInfo.setUseCompoundFile(false);
                String fileName = segmentInfo.name + ".cfs";
                if (!directory.fileExists(fileName)) continue;
                CompoundFileReader cfsReader = new CompoundFileReader(directory, fileName);
                String[] cfsEntriesNames = cfsReader.list();
                for (int i = 0; i < cfsEntriesNames.length; ++i) {
                    String entryName = cfsEntriesNames[i];
                    IndexOutput indexOutput = directory.createOutput(entryName);
                    IndexInput indexInput = cfsReader.openInput(entryName);
                    try {
                        long length;
                        long remainder;
                        int len;
                        byte[] buffer = new byte[1024];
                        int chunk = buffer.length;
                        for (remainder = length = indexInput.length(); remainder > 0L; remainder -= (long)len) {
                            len = (int)Math.min((long)chunk, remainder);
                            indexInput.readBytes(buffer, 0, len);
                            indexOutput.writeBytes(buffer, len);
                        }
                        if (remainder == 0L) continue;
                        throw new IOException("Non-zero remainder length after copying: " + remainder + " (id: " + entryName + ", length: " + length + ", buffer size: " + chunk + ")");
                    }
                    finally {
                        indexInput.close();
                        indexOutput.close();
                    }
                }
            }
            segmentInfos.write(directory);
            deleter.checkpoint(segmentInfos, true);
        }
        finally {
            writeLock.release();
        }
    }
}

