/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.CompassMultiReader;
import org.apache.lucene.index.CompassSegmentReader;
import org.apache.lucene.index.DocumentWriter;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.TransLog;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSettings;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;

public class TransIndex {
    private Directory directory;
    private Similarity similarity = Similarity.getDefault();
    private SegmentInfos segmentInfos = new SegmentInfos();
    private Lock writeLock;
    private boolean closeDir;
    private PrintStream infoStream = null;
    private static final int MERGE_READ_BUFFER_SIZE = 4096;
    private IndexFileDeleter deleter;
    private SegmentInfos rollbackSegmentInfos;
    private static final Log log = LogFactory.getLog((Class)TransIndex.class);
    private IndexReader indexReader;
    private IndexSearcher indexSearcher;
    private TransLog transLog;
    private Directory transDir;
    private SegmentInfos transSegmentInfos;
    private ArrayList transCreates;
    private ArrayList transReaders;
    private SegmentInfo newSegment;
    private LuceneSettings luceneSettings;

    public void setInfoStream(PrintStream infoStream) {
        this.infoStream = infoStream;
    }

    public PrintStream getInfoStream() {
        return this.infoStream;
    }

    public TransIndex(String subIndex, Directory dir, LuceneSearchEngine searchEngine) throws IOException {
        this(dir, false, false, searchEngine);
        this.transLog = this.luceneSettings.createTransLog(searchEngine.getSettings());
        this.transDir = this.transLog.getDirectory();
        this.transCreates = new ArrayList();
        this.transReaders = new ArrayList();
        this.transSegmentInfos = new SegmentInfos();
        this.transSegmentInfos.write(this.transDir);
        if (this.segmentInfos.size() == 1) {
            this.indexReader = SegmentReader.get((SegmentInfos)this.segmentInfos, (SegmentInfo)this.segmentInfos.info(0), (boolean)false);
            ((CompassSegmentReader)this.indexReader).setSubIndex(subIndex);
        } else {
            IndexReader[] readers = new IndexReader[this.segmentInfos.size()];
            for (int i = this.segmentInfos.size() - 1; i >= 0; --i) {
                try {
                    readers[i] = SegmentReader.get((SegmentInfo)this.segmentInfos.info(i));
                    continue;
                }
                catch (IOException e) {
                    ++i;
                    while (i < this.segmentInfos.size()) {
                        readers[i].close();
                        ++i;
                    }
                    throw e;
                }
            }
            this.indexReader = new CompassMultiReader(subIndex, this.directory, this.segmentInfos, false, readers);
        }
        this.indexSearcher = new IndexSearcher(this.indexReader);
    }

    private TransIndex(Directory d, boolean create, boolean closeDir, LuceneSearchEngine searchEngine) throws IOException {
        Lock writeLock;
        this.luceneSettings = searchEngine.getSearchEngineFactory().getLuceneSettings();
        this.closeDir = closeDir;
        this.directory = d;
        if (create) {
            this.directory.clearLock("write.lock");
        }
        if (!(writeLock = this.directory.makeLock("write.lock")).obtain(this.luceneSettings.getTransactionLockTimout())) {
            throw new IOException("Index locked for write: " + writeLock);
        }
        this.writeLock = writeLock;
        try {
            if (create) {
                try {
                    this.segmentInfos.read(this.directory);
                    this.segmentInfos.clear();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.segmentInfos.write(this.directory);
            } else {
                this.segmentInfos.read(this.directory);
            }
            this.rollbackSegmentInfos = (SegmentInfos)this.segmentInfos.clone();
            this.deleter = new IndexFileDeleter(this.directory, searchEngine.getSearchEngineFactory().getIndexDeletionPolicyManager().createIndexDeletionPolicy(this.directory), this.segmentInfos, this.infoStream);
        }
        catch (IOException e) {
            this.writeLock.release();
            this.writeLock = null;
            throw e;
        }
    }

    public void addResource(InternalResource resource, Analyzer analyzer) throws IOException {
        DocumentWriter dw = new DocumentWriter(this.transDir, analyzer, this.similarity, this.luceneSettings.getMaxFieldLength());
        dw.setInfoStream(this.infoStream);
        String segmentName = this.newTransSegmentName();
        dw.addDocument(segmentName, ((LuceneResource)resource).getDocument());
        SegmentInfo segmentInfo = new SegmentInfo(segmentName, 1, this.transDir, false, false);
        this.transSegmentInfos.addElement((Object)segmentInfo);
        if (this.transLog.shouldUpdateTransSegments()) {
            this.transSegmentInfos.write(this.transDir);
        }
        this.transLog.onDocumentAdded();
        this.transReaders.add(SegmentReader.get((SegmentInfo)segmentInfo, (int)4096));
        this.transCreates.add(resource.resourceKey());
        ((LuceneResource)resource).setDocNum(this.indexReader.maxDoc() + this.transCreates.size() - 1);
    }

    private final String newTransSegmentName() {
        return "_" + Integer.toString(this.transSegmentInfos.counter++, 36);
    }

    private final String newSegmentName() {
        return "_" + Integer.toString(this.segmentInfos.counter++, 36);
    }

    public void deleteTransResource(ResourceKey resourceKey) throws IOException {
        int i = this.transCreates.indexOf(resourceKey);
        if (i != -1) {
            this.transSegmentInfos.removeElementAt(i);
            this.transCreates.remove(i);
            IndexReader indexReader = (IndexReader)this.transReaders.remove(i);
            try {
                indexReader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (this.transLog.shouldUpdateTransSegments()) {
                this.transSegmentInfos.write(this.transDir);
            }
        }
    }

    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    public Searcher getIndexSearcher() {
        return this.indexSearcher;
    }

    public IndexReader[] getFullIndexReaderAsArray() throws IOException {
        if (this.transSegmentInfos.size() == 0) {
            return new IndexReader[]{this.indexReader};
        }
        IndexReader[] readers = new IndexReader[1 + this.transReaders.size()];
        readers[0] = this.indexReader;
        for (int i = 1; i < readers.length; ++i) {
            readers[i] = (IndexReader)this.transReaders.get(i - 1);
        }
        return readers;
    }

    public IndexReader getFullIndexReader() throws IOException {
        if (this.transSegmentInfos.size() == 0) {
            return this.indexReader;
        }
        IndexReader[] readers = this.getFullIndexReaderAsArray();
        return new MultiReader(readers);
    }

    public Searcher getFullIndexSearcher() throws IOException {
        return new MultiSearcher((Searchable[])this.getFullIndexSearcherAsArray());
    }

    public Searcher[] getFullIndexSearcherAsArray() throws IOException {
        if (this.transSegmentInfos.size() == 0) {
            return new Searcher[]{this.indexSearcher};
        }
        IndexReader[] transReadersArr = this.transReaders.toArray(new IndexReader[this.transReaders.size()]);
        MultiReader transReader = new MultiReader(this.transDir, this.transSegmentInfos, false, transReadersArr);
        IndexSearcher transSearcher = new IndexSearcher((IndexReader)transReader);
        return new Searcher[]{this.indexSearcher, transSearcher};
    }

    public void firstPhase() throws IOException {
        String newSegmentName = this.newSegmentName();
        SegmentMerger merger = new SegmentMerger(this.directory, newSegmentName);
        for (int i = 0; i < this.transReaders.size(); ++i) {
            merger.add((IndexReader)this.transReaders.get(i));
        }
        int mergedDocCount = merger.merge();
        if (this.infoStream != null) {
            this.infoStream.println(" into " + newSegmentName + " (" + mergedDocCount + " docs)");
        }
        merger.closeReaders();
        this.newSegment = new SegmentInfo(newSegmentName, mergedDocCount, this.directory, false, true);
        this.segmentInfos.addElement((Object)this.newSegment);
        this.deleter.checkpoint(this.segmentInfos, false);
        if (this.luceneSettings.isUseCompoundFile()) {
            this.newSegment.setUseCompoundFile(true);
            merger.createCompoundFile(newSegmentName + "." + "cfs");
            this.deleter.checkpoint(this.segmentInfos, false);
        }
    }

    public void secondPhase() throws IOException {
        if (this.newSegment == null) {
            throw new IOException("Transaction not called first phase");
        }
        this.indexSearcher.close();
        this.indexSearcher = null;
        this.indexReader.doCommit();
        this.indexReader.doClose();
        this.indexReader = null;
        this.segmentInfos.write(this.directory);
        this.deleter.checkpoint(this.segmentInfos, true);
        this.rollbackSegmentInfos = null;
    }

    public void rollback() throws IOException {
        if (this.newSegment == null) {
            return;
        }
        this.segmentInfos.clear();
        this.segmentInfos.addAll((Collection)this.rollbackSegmentInfos);
        this.deleter.checkpoint(this.segmentInfos, false);
        this.deleter.refresh();
    }

    public void close() throws IOException {
        this.transCreates.clear();
        for (int i = 0; i < this.transReaders.size(); ++i) {
            try {
                ((IndexReader)this.transReaders.get(i)).close();
                continue;
            }
            catch (IOException ex) {
                log.warn((Object)"Failed to close transaction index readers, ignoring", (Throwable)ex);
            }
        }
        this.transReaders.clear();
        try {
            this.transLog.close();
            this.transDir = null;
        }
        catch (IOException ex) {
            log.warn((Object)"Failed to close transactional directory, ignoring", (Throwable)ex);
        }
        if (this.closeDir) {
            try {
                this.directory.close();
            }
            catch (IOException ex) {
                log.warn((Object)"Failed to close directory, ignoring", (Throwable)ex);
            }
            this.directory = null;
        }
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }
}

