/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.MultiDeleteDirectory;
import org.apache.lucene.store.jdbc.JdbcDirectorySettings;
import org.apache.lucene.store.jdbc.JdbcFileEntrySettings;
import org.apache.lucene.store.jdbc.JdbcStoreException;
import org.apache.lucene.store.jdbc.dialect.Dialect;
import org.apache.lucene.store.jdbc.dialect.DialectResolver;
import org.apache.lucene.store.jdbc.handler.FileEntryHandler;
import org.apache.lucene.store.jdbc.lock.JdbcLock;
import org.apache.lucene.store.jdbc.support.JdbcTable;
import org.apache.lucene.store.jdbc.support.JdbcTemplate;

public class JdbcDirectory
extends Directory
implements MultiDeleteDirectory {
    private Dialect dialect;
    private DataSource dataSource;
    private JdbcTable table;
    private JdbcDirectorySettings settings;
    private HashMap fileEntryHandlers = new HashMap();
    private JdbcTemplate jdbcTemplate;

    public JdbcDirectory(DataSource dataSource, String tableName) throws JdbcStoreException {
        Dialect dialect = new DialectResolver().getDialect(dataSource);
        this.initialize(dataSource, new JdbcTable(new JdbcDirectorySettings(), dialect, tableName));
    }

    public JdbcDirectory(DataSource dataSource, Dialect dialect, String tableName) {
        this.initialize(dataSource, new JdbcTable(new JdbcDirectorySettings(), dialect, tableName));
    }

    public JdbcDirectory(DataSource dataSource, JdbcDirectorySettings settings, String tableName) throws JdbcStoreException {
        Dialect dialect = new DialectResolver().getDialect(dataSource);
        this.initialize(dataSource, new JdbcTable(settings, dialect, tableName));
    }

    public JdbcDirectory(DataSource dataSource, Dialect dialect, JdbcDirectorySettings settings, String tableName) {
        this.initialize(dataSource, new JdbcTable(settings, dialect, tableName));
    }

    public JdbcDirectory(DataSource dataSource, JdbcTable table) {
        this.initialize(dataSource, table);
    }

    private void initialize(DataSource dataSource, JdbcTable table) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource, table.getSettings());
        this.dialect = table.getDialect();
        this.table = table;
        this.settings = table.getSettings();
        this.dialect.processSettings(this.settings);
        Map fileEntrySettings = this.settings.getFileEntrySettings();
        Iterator it = fileEntrySettings.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            JdbcFileEntrySettings feSettings = (JdbcFileEntrySettings)fileEntrySettings.get(name);
            try {
                Class fileEntryHandlerClass = feSettings.getSettingAsClass("type", null);
                FileEntryHandler fileEntryHandler = (FileEntryHandler)fileEntryHandlerClass.newInstance();
                fileEntryHandler.configure(this);
                this.fileEntryHandlers.put(name, fileEntryHandler);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to create FileEntryHandler  [" + feSettings.getSetting("type") + "]");
            }
        }
    }

    public boolean tableExists() throws IOException, UnsupportedOperationException {
        Boolean tableExists = (Boolean)this.jdbcTemplate.executeSelect(this.dialect.sqlTableExists(this.table.getCatalog(), this.table.getSchema()), new JdbcTemplate.ExecuteSelectCallback(){

            public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                ps.setFetchSize(1);
                ps.setString(1, JdbcDirectory.this.table.getName().toLowerCase());
            }

            public Object execute(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return tableExists;
    }

    public void delete() throws IOException {
        if (!this.dialect.supportsIfExistsAfterTableName() && !this.dialect.supportsIfExistsBeforeTableName() && this.dialect.supportsTableExists() && !this.tableExists()) {
            return;
        }
        this.jdbcTemplate.executeUpdate(this.table.sqlDrop());
    }

    public void create() throws IOException {
        try {
            this.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jdbcTemplate.executeUpdate(this.table.sqlCreate());
        ((JdbcLock)this.createLock()).initializeDatabase(this);
    }

    public void deleteContent() throws IOException {
        this.jdbcTemplate.executeUpdate(this.table.sqlDeletaAll());
    }

    public void deleteMarkDeleted() throws IOException {
        this.deleteMarkDeleted(this.settings.getDeleteMarkDeletedDelta());
    }

    public void deleteMarkDeleted(long delta) throws IOException {
        long currentTime = System.currentTimeMillis();
        if (this.dialect.supportsCurrentTimestampSelection()) {
            String timestampSelectString = this.dialect.getCurrentTimestampSelectString();
            currentTime = this.dialect.isCurrentTimestampSelectStringCallable() ? ((Long)this.jdbcTemplate.executeCallable(timestampSelectString, new JdbcTemplate.CallableStatementCallback(){

                public void fillCallableStatement(CallableStatement cs) throws Exception {
                    cs.registerOutParameter(1, 93);
                }

                public Object readCallableData(CallableStatement cs) throws Exception {
                    Timestamp timestamp = cs.getTimestamp(1);
                    return new Long(timestamp.getTime());
                }
            })).longValue() : ((Long)this.jdbcTemplate.executeSelect(timestampSelectString, new JdbcTemplate.ExecuteSelectCallback(){

                public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                }

                public Object execute(ResultSet rs) throws Exception {
                    rs.next();
                    Timestamp timestamp = rs.getTimestamp(1);
                    return new Long(timestamp.getTime());
                }
            })).longValue();
        }
        final long deleteBefore = currentTime - delta;
        this.jdbcTemplate.executeUpdate(this.table.sqlDeletaMarkDeleteByDelta(), new JdbcTemplate.PrepateStatementAwareCallback(){

            public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                ps.setBoolean(1, true);
                ps.setTimestamp(2, new Timestamp(deleteBefore));
            }
        });
    }

    public String[] list() throws IOException {
        return (String[])this.jdbcTemplate.executeSelect(this.table.sqlSelectNames(), new JdbcTemplate.ExecuteSelectCallback(){

            public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                ps.setBoolean(1, false);
            }

            public Object execute(ResultSet rs) throws Exception {
                ArrayList<String> names = new ArrayList<String>();
                while (rs.next()) {
                    names.add(rs.getString(1));
                }
                return names.toArray(new String[names.size()]);
            }
        });
    }

    public boolean fileExists(String name) throws IOException {
        return this.getFileEntryHandler(name).fileExists(name);
    }

    public long fileModified(String name) throws IOException {
        return this.getFileEntryHandler(name).fileModified(name);
    }

    public void touchFile(String name) throws IOException {
        this.getFileEntryHandler(name).touchFile(name);
    }

    public void deleteFile(String name) throws IOException {
        this.getFileEntryHandler(name).deleteFile(name);
    }

    public List deleteFiles(List names) throws IOException {
        List tempNames;
        FileEntryHandler fileEntryHandler;
        HashMap<FileEntryHandler, ArrayList> tempMap = new HashMap<FileEntryHandler, ArrayList>();
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            fileEntryHandler = this.getFileEntryHandler(name);
            tempNames = (ArrayList)tempMap.get(fileEntryHandler);
            if (tempNames == null) {
                tempNames = new ArrayList(names.size());
                tempMap.put(fileEntryHandler, (ArrayList)tempNames);
            }
            tempNames.add(name);
        }
        ArrayList notDeleted = new ArrayList(names.size() / 2);
        Iterator it2 = tempMap.keySet().iterator();
        while (it2.hasNext()) {
            fileEntryHandler = (FileEntryHandler)it2.next();
            tempNames = (ArrayList)tempMap.get(fileEntryHandler);
            if ((tempNames = fileEntryHandler.deleteFiles(tempNames)) == null) continue;
            notDeleted.addAll(tempNames);
        }
        return notDeleted;
    }

    public void renameFile(String from, String to) throws IOException {
        this.getFileEntryHandler(from).renameFile(from, to);
    }

    public long fileLength(String name) throws IOException {
        return this.getFileEntryHandler(name).fileLength(name);
    }

    public IndexInput openInput(String name) throws IOException {
        return this.getFileEntryHandler(name).openInput(name);
    }

    public IndexOutput createOutput(String name) throws IOException {
        return this.getFileEntryHandler(name).createOutput(name);
    }

    public Lock makeLock(String name) {
        try {
            Lock lock = this.createLock();
            ((JdbcLock)lock).configure(this, name);
            return lock;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void close() throws IOException {
        IOException last = null;
        Iterator it = this.fileEntryHandlers.values().iterator();
        while (it.hasNext()) {
            FileEntryHandler fileEntryHandler = (FileEntryHandler)it.next();
            try {
                fileEntryHandler.close();
            }
            catch (IOException e) {
                last = e;
            }
        }
        if (last != null) {
            throw last;
        }
    }

    protected FileEntryHandler getFileEntryHandler(String name) {
        FileEntryHandler handler = (FileEntryHandler)this.fileEntryHandlers.get(name.substring(name.length() - 3));
        if (handler != null) {
            return handler;
        }
        handler = (FileEntryHandler)this.fileEntryHandlers.get(name);
        if (handler != null) {
            return handler;
        }
        return (FileEntryHandler)this.fileEntryHandlers.get(JdbcDirectorySettings.DEFAULT_FILE_ENTRY);
    }

    protected Lock createLock() throws IOException {
        try {
            return (Lock)this.settings.getLockClass().newInstance();
        }
        catch (Exception e) {
            throw new JdbcStoreException("Failed to create lock class [" + this.settings.getLockClass() + "]");
        }
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public JdbcTable getTable() {
        return this.table;
    }

    public JdbcDirectorySettings getSettings() {
        return this.settings;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

