/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.datasource;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.lucene.store.jdbc.datasource.ConnectionProxy;
import org.apache.lucene.store.jdbc.index.FetchPerTransactionJdbcIndexInput;

public class TransactionAwareDataSourceProxy
implements DataSource {
    private static ThreadLocal connectionHolders = new ThreadLocal();
    private DataSource dataSource;

    public TransactionAwareDataSourceProxy(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getTargetDataSource() {
        return this.dataSource;
    }

    public int getLoginTimeout() throws SQLException {
        return this.getTargetDataSource().getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.getTargetDataSource().setLoginTimeout(seconds);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.getTargetDataSource().getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getTargetDataSource().setLogWriter(out);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        Connection con;
        HashMap<DataSource, Connection> holders = (HashMap<DataSource, Connection>)connectionHolders.get();
        if (holders == null) {
            holders = new HashMap<DataSource, Connection>();
            connectionHolders.set(holders);
        }
        if ((con = (Connection)holders.get(this.getTargetDataSource())) == null) {
            con = this.getTargetDataSource().getConnection(username, password);
            holders.put(this.getTargetDataSource(), con);
            return this.getTransactionAwareConnectionProxy(con, this.getTargetDataSource(), true);
        }
        return this.getTransactionAwareConnectionProxy(con, this.getTargetDataSource(), false);
    }

    public Connection getConnection() throws SQLException {
        Connection con;
        HashMap<DataSource, Connection> holders = (HashMap<DataSource, Connection>)connectionHolders.get();
        if (holders == null) {
            holders = new HashMap<DataSource, Connection>();
            connectionHolders.set(holders);
        }
        if ((con = (Connection)holders.get(this.getTargetDataSource())) == null) {
            con = this.getTargetDataSource().getConnection();
            holders.put(this.getTargetDataSource(), con);
            return this.getTransactionAwareConnectionProxy(con, this.getTargetDataSource(), true);
        }
        return this.getTransactionAwareConnectionProxy(con, this.getTargetDataSource(), false);
    }

    protected Connection getTransactionAwareConnectionProxy(Connection target, DataSource dataSource, boolean controllsConnection) {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new TransactionAwareInvocationHandler(target, dataSource, controllsConnection));
    }

    private static class TransactionAwareInvocationHandler
    implements InvocationHandler {
        private final Connection target;
        private final DataSource dataSource;
        private final boolean controlConnection;

        public TransactionAwareInvocationHandler(Connection target, DataSource dataSource, boolean controlConnection) {
            this.target = target;
            this.dataSource = dataSource;
            this.controlConnection = controlConnection;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getTargetConnection")) {
                return this.target;
            }
            if (method.getName().equals("controlConnection")) {
                return this.controlConnection ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("close")) {
                if (this.controlConnection) {
                    Map holders = (Map)connectionHolders.get();
                    if (holders == null || !holders.containsKey(this.dataSource)) {
                        throw new IllegalStateException("No value for data source [" + this.dataSource + "] bound to thread [" + Thread.currentThread().getName() + "]");
                    }
                    Connection transConnection = (Connection)holders.remove(this.dataSource);
                    if (holders.isEmpty()) {
                        connectionHolders.set(null);
                    }
                    FetchPerTransactionJdbcIndexInput.releaseBlobs(transConnection);
                    transConnection.close();
                }
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

