/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.index.oracle;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import org.apache.lucene.store.jdbc.support.JdbcTable;
import org.compass.core.util.MethodInvoker;

public abstract class OracleIndexOutputHelper {
    public static String sqlInsert(JdbcTable table) {
        return "insert into " + table.getQualifiedName() + " (" + table.getNameColumn().getQuotedName() + ", " + table.getValueColumn().getQuotedName() + ", " + table.getSizeColumn().getQuotedName() + ", " + table.getLastModifiedColumn().getQuotedName() + ", " + table.getDeletedColumn().getQuotedName() + ") values ( ?, EMPTY_BLOB(), ?, " + table.getDialect().getCurrentTimestampFunction() + ", ?" + " )";
    }

    public static String sqlUpdate(JdbcTable table) {
        return "select " + table.getValueColumn().getQuotedName() + " as x from " + table.getQualifiedName() + " where " + table.getNameColumn().getQuotedName() + " = ? for update";
    }

    public static OutputStream getBlobOutputStream(ResultSet rs) throws IOException {
        Object BLOB;
        MethodInvoker getBlobMethod = new MethodInvoker();
        getBlobMethod.setTargetMethod("getBLOB");
        getBlobMethod.setTargetObject(rs);
        getBlobMethod.setArguments(new Object[]{"x"});
        try {
            BLOB = getBlobMethod.prepare().invoke();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to getBLOB on [" + rs + "]", e);
        }
        MethodInvoker getBinaryOutputStreamMethod = new MethodInvoker();
        getBinaryOutputStreamMethod.setTargetMethod("getBinaryOutputStream");
        getBinaryOutputStreamMethod.setTargetObject(BLOB);
        try {
            return (OutputStream)getBinaryOutputStreamMethod.prepare().invoke();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to getBinaryOutputStream on [" + BLOB + "]", e);
        }
    }
}

