/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core;

import java.io.Reader;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.CompassCallback;
import org.compass.core.CompassCallbackWithoutResult;
import org.compass.core.CompassDetachedHits;
import org.compass.core.CompassException;
import org.compass.core.CompassHits;
import org.compass.core.CompassHitsOperations;
import org.compass.core.CompassOperations;
import org.compass.core.CompassQuery;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.config.CompassSettings;

public class CompassTemplate
implements CompassOperations {
    private static Log log = LogFactory.getLog((Class)CompassTemplate.class);
    private Compass compass;
    private CompassSettings globalSessionSettings = new CompassSettings();

    public CompassTemplate() {
    }

    public CompassTemplate(Compass compass) {
        this.compass = compass;
    }

    public void setCompass(Compass compass) {
        this.compass = compass;
    }

    public Compass getCompass() {
        return this.compass;
    }

    public Object execute(CompassCallback action) throws CompassException {
        return this.execute(null, action);
    }

    public Object execute(CompassTransaction.TransactionIsolation transactionIsolation, CompassCallback action) throws CompassException {
        CompassSession session = this.compass.openSession();
        session.getSettings().addSettings(this.globalSessionSettings);
        CompassTransaction tx = null;
        try {
            tx = session.beginTransaction(transactionIsolation);
            Object result = action.doInCompass(session);
            tx.commit();
            Object object = result;
            return object;
        }
        catch (RuntimeException e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    log.error((Object)"Failed to rollback transaction, ignoring", (Throwable)e1);
                }
            }
            throw e;
        }
        catch (Error err) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    log.error((Object)"Failed to rollback transaction, ignoring", (Throwable)e1);
                }
            }
            throw err;
        }
        finally {
            session.close();
        }
    }

    public CompassHitsOperations executeFind(CompassCallback action) throws CompassException {
        return (CompassHitsOperations)this.execute(action);
    }

    public CompassSettings getSettings() {
        throw new CompassException("getSettings should not be used with CompassTemplate. Either use getGlobalSettings or execute");
    }

    public void create(final Object obj) throws CompassException {
        this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                session.create(obj);
                return null;
            }
        });
    }

    public void create(final String alias, final Object obj) throws CompassException {
        this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                session.create(alias, obj);
                return null;
            }
        });
    }

    public Property createProperty(final String name, final Reader value) throws CompassException {
        return (Property)this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return session.createProperty(name, value);
            }
        });
    }

    public Property createProperty(final String name, final byte[] value, final Property.Store store) throws CompassException {
        return (Property)this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return session.createProperty(name, value, store);
            }
        });
    }

    public Property createProperty(final String name, final Reader value, final Property.TermVector termVector) throws CompassException {
        return (Property)this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return session.createProperty(name, value, termVector);
            }
        });
    }

    public Property createProperty(final String name, final String value, final Property.Store store, final Property.Index index) throws CompassException {
        return (Property)this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return session.createProperty(name, value, store, index);
            }
        });
    }

    public Property createProperty(final String name, final String value, final Property.Store store, final Property.Index index, final Property.TermVector termVector) throws CompassException {
        return (Property)this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return session.createProperty(name, value, store, index, termVector);
            }
        });
    }

    public Resource createResource(final String alias) throws CompassException {
        return (Resource)this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return session.createResource(alias);
            }
        });
    }

    public void delete(final Object obj) throws CompassException {
        this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                session.delete(obj);
                return null;
            }
        });
    }

    public void delete(final Resource resource) throws CompassException {
        this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                session.delete(resource);
                return null;
            }
        });
    }

    public void delete(final Class clazz, final Object obj) throws CompassException {
        this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                session.delete(clazz, obj);
                return null;
            }
        });
    }

    public void delete(final String alias, final Object obj) throws CompassException {
        this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                session.delete(alias, obj);
                return null;
            }
        });
    }

    public void delete(final CompassQuery query) throws CompassException {
        this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                session.delete(query);
                return null;
            }
        });
    }

    public CompassHits find(final String query) throws CompassException {
        return (CompassHits)this.executeFind(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return session.find(query);
            }
        });
    }

    public CompassDetachedHits findWithDetach(final String query) throws CompassException {
        return (CompassDetachedHits)this.executeFind(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return session.find(query).detach();
            }
        });
    }

    public CompassDetachedHits findWithDetach(final String query, final int from, final int size) throws CompassException {
        return (CompassDetachedHits)this.executeFind(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return session.find(query).detach(from, size);
            }
        });
    }

    public Object get(final Class clazz, final Serializable id) throws CompassException {
        return this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return session.get(clazz, id);
            }
        });
    }

    public Object get(final String alias, final Serializable id) throws CompassException {
        return this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return session.get(alias, id);
            }
        });
    }

    public Resource getResource(final Class clazz, final Serializable id) throws CompassException {
        return (Resource)this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return session.getResource(clazz, id);
            }
        });
    }

    public Resource getResource(final String alias, final Serializable id) throws CompassException {
        return (Resource)this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return session.getResource(alias, id);
            }
        });
    }

    public Object load(final Class clazz, final Serializable id) throws CompassException {
        return this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return session.load(clazz, id);
            }
        });
    }

    public Object load(final String alias, final Serializable id) throws CompassException {
        return this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return session.load(alias, id);
            }
        });
    }

    public Resource loadResource(final Class clazz, final Serializable id) throws CompassException {
        return (Resource)this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return session.loadResource(clazz, id);
            }
        });
    }

    public Resource loadResource(final String alias, final Serializable id) throws CompassException {
        return (Resource)this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return session.loadResource(alias, id);
            }
        });
    }

    public void save(final Object obj) throws CompassException {
        this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                session.save(obj);
                return null;
            }
        });
    }

    public void save(final String alias, final Object obj) throws CompassException {
        this.execute(new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                session.save(alias, obj);
                return null;
            }
        });
    }

    public void evict(final Object obj) {
        this.execute(new CompassCallbackWithoutResult(){

            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                session.evict(obj);
            }
        });
    }

    public void evict(final String alias, final Object id) {
        this.execute(new CompassCallbackWithoutResult(){

            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                session.evict(alias, id);
            }
        });
    }

    public void evict(final Resource resource) {
        this.execute(new CompassCallbackWithoutResult(){

            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                session.evict(resource);
            }
        });
    }

    public void evictAll() {
        this.execute(new CompassCallbackWithoutResult(){

            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                session.evictAll();
            }
        });
    }
}

