/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.compass.core.config.ConfigurationException;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.backport.java.util.concurrent.ConcurrentHashMap;

public class CompassSettings {
    private Properties settings;
    private final Map groups = new ConcurrentHashMap();
    private Map registry = new ConcurrentHashMap();

    public CompassSettings() {
        this(new Properties());
    }

    public CompassSettings(Properties settings) {
        this.settings = settings;
    }

    public void addSettings(Properties settings) {
        this.settings.putAll((Map<?, ?>)settings);
    }

    public void addSettings(CompassSettings settings) {
        this.settings.putAll((Map<?, ?>)settings.getProperties());
    }

    public CompassSettings copy() {
        CompassSettings copySettings = new CompassSettings((Properties)this.settings.clone());
        copySettings.registry = new ConcurrentHashMap(this.registry);
        return copySettings;
    }

    public Properties getProperties() {
        return this.settings;
    }

    public Collection keySet() {
        return this.settings.keySet();
    }

    public String getSetting(String setting) {
        return this.settings.getProperty(setting);
    }

    public String getSetting(String setting, String defaultValue) {
        return this.settings.getProperty(setting, defaultValue);
    }

    public Map getSettingGroups(String settingPrefix) {
        Map group;
        if (settingPrefix.charAt(settingPrefix.length() - 1) != '.') {
            settingPrefix = settingPrefix + ".";
        }
        if ((group = (Map)this.groups.get(settingPrefix)) != null) {
            return group;
        }
        HashMap<String, CompassSettings> map = new HashMap<String, CompassSettings>();
        Iterator<Object> it = this.settings.keySet().iterator();
        while (it.hasNext()) {
            String setting = (String)it.next();
            if (!setting.startsWith(settingPrefix)) continue;
            String nameValue = setting.substring(settingPrefix.length());
            int dotIndex = nameValue.indexOf(46);
            if (dotIndex == -1) {
                throw new ConfigurationException("Failed to get setting group for [" + settingPrefix + "] setting prefix and setting [" + setting + "] because of a missing '.'");
            }
            String name = nameValue.substring(0, dotIndex);
            String value = nameValue.substring(dotIndex + 1);
            CompassSettings groupSettings = (CompassSettings)map.get(name);
            if (groupSettings == null) {
                groupSettings = new CompassSettings();
                map.put(name, groupSettings);
            }
            groupSettings.setSetting(value, this.getSetting(setting));
        }
        this.groups.put(settingPrefix, map);
        return map;
    }

    public float getSettingAsFloat(String setting, float defaultValue) {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        return Float.parseFloat(sValue);
    }

    public double getSettingAsDouble(String setting, double defaultValue) {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        return Double.parseDouble(sValue);
    }

    public int getSettingAsInt(String setting, int defaultValue) {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        return Integer.parseInt(sValue);
    }

    public long getSettingAsLong(String setting, long defaultValue) {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        return Long.parseLong(sValue);
    }

    public boolean getSettingAsBoolean(String setting, boolean defaultValue) {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        return Boolean.valueOf(sValue);
    }

    public Class getSettingAsClass(String setting, Class clazz) throws ClassNotFoundException {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return clazz;
        }
        return ClassUtils.forName(sValue);
    }

    public Class getSettingAsClass(String setting, Class clazz, ClassLoader classLoader) throws ClassNotFoundException {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return clazz;
        }
        return ClassUtils.forName(sValue, classLoader);
    }

    public CompassSettings setSetting(String setting, String value) {
        if (value == null) {
            return this;
        }
        this.settings.setProperty(setting, value);
        return this;
    }

    public CompassSettings setBooleanSetting(String setting, boolean value) {
        this.setSetting(setting, String.valueOf(value));
        return this;
    }

    public CompassSettings setFloatSetting(String setting, float value) {
        this.setSetting(setting, String.valueOf(value));
        return this;
    }

    public CompassSettings setDoubleSetting(String setting, double value) {
        this.setSetting(setting, String.valueOf(value));
        return this;
    }

    public CompassSettings setIntSetting(String setting, int value) {
        this.setSetting(setting, String.valueOf(value));
        return this;
    }

    public CompassSettings setLongSetting(String setting, long value) {
        this.setSetting(setting, String.valueOf(value));
        return this;
    }

    public CompassSettings setClassSetting(String setting, Class clazz) {
        this.setSetting(setting, clazz.getName());
        return this;
    }

    public CompassSettings setGroupSettings(String settingPrefix, String groupName, String[] settings, String[] values) {
        if (settings.length != values.length) {
            throw new IllegalArgumentException("The settings length must match the value length");
        }
        for (int i = 0; i < settings.length; ++i) {
            if (values[i] == null) continue;
            this.setSetting(settingPrefix + "." + groupName + "." + settings[i], values[i]);
        }
        return this;
    }

    public Object getRegistry(Object key) {
        return this.registry.get(key);
    }

    public void setRegistry(Object key, Object value) {
        this.registry.put(key, value);
    }

    public Object removeRegistry(Object key) {
        return this.registry.remove(key);
    }

    public String toString() {
        return this.settings.toString();
    }
}

