/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.binding;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.InputStreamMappingResolver;
import org.compass.core.config.binding.MappingBinding;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.metadata.CompassMetaData;

public abstract class AbstractInputStreamMappingBinding
implements MappingBinding {
    protected CompassMapping mapping;
    protected CompassMetaData metaData;
    protected CompassSettings settings;

    public void setUpBinding(CompassMapping mapping, CompassMetaData metaData, CompassSettings settings) {
        this.mapping = mapping;
        this.metaData = metaData;
        this.settings = settings;
    }

    public boolean addResoruceMapping(ResourceMapping resourceMapping) throws ConfigurationException, MappingException {
        this.mapping.addMapping(resourceMapping);
        return true;
    }

    public boolean addResource(String path) throws ConfigurationException, MappingException {
        return this.addResource(path, Thread.currentThread().getContextClassLoader());
    }

    public boolean addResource(String path, ClassLoader classLoader) throws ConfigurationException, MappingException {
        InputStream rsrc = classLoader.getResourceAsStream(path);
        if (rsrc == null) {
            return false;
        }
        return this.addInputStream(rsrc, path);
    }

    public boolean addURL(URL url) throws ConfigurationException, MappingException {
        try {
            return this.addInputStream(url.openStream(), url.toExternalForm());
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to open url [" + url.toExternalForm() + "]");
        }
    }

    public boolean addDirectory(File dir) throws ConfigurationException, MappingException {
        boolean addedAtLeastOne = false;
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            boolean retVal;
            if (files[i].isDirectory()) {
                retVal = this.addDirectory(files[i]);
                if (!retVal) continue;
                addedAtLeastOne = true;
                continue;
            }
            if (!files[i].getName().endsWith(this.getSuffix()) || !(retVal = this.addFile(files[i]))) continue;
            addedAtLeastOne = true;
        }
        return addedAtLeastOne;
    }

    public boolean addJar(File jar) throws ConfigurationException, MappingException {
        JarFile jarFile;
        try {
            jarFile = new JarFile(jar);
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Could not configure datastore from jar [" + jar.getName() + "]", ioe);
        }
        boolean addedAtLeastOne = false;
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            ZipEntry ze = jarEntries.nextElement();
            if (!ze.getName().endsWith(this.getSuffix())) continue;
            try {
                boolean retVal = this.addInputStream(jarFile.getInputStream(ze), ze.getName());
                if (!retVal) continue;
                addedAtLeastOne = true;
            }
            catch (ConfigurationException me) {
                throw me;
            }
            catch (Exception e) {
                throw new ConfigurationException("Could not configure datastore from jar [" + jar.getAbsolutePath() + "]", e);
            }
        }
        return addedAtLeastOne;
    }

    public boolean addFile(String filePath) throws ConfigurationException, MappingException {
        return this.addFile(new File(filePath));
    }

    public boolean addFile(File file) throws ConfigurationException, MappingException {
        try {
            return this.addInputStream(new FileInputStream(file), file.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Could not configure mapping from file, file not found [" + file.getAbsolutePath() + "]", e);
        }
    }

    public boolean addPackage(String packageName) throws ConfigurationException, MappingException {
        return false;
    }

    public boolean addClass(Class clazz) throws ConfigurationException, MappingException {
        String fileName = clazz.getName().replace('.', '/') + this.getSuffix();
        InputStream rsrc = clazz.getClassLoader().getResourceAsStream(fileName);
        if (rsrc == null) {
            return false;
        }
        try {
            return this.addInputStream(rsrc, fileName);
        }
        catch (ConfigurationException me) {
            throw new ConfigurationException("Error reading resource [" + fileName + "]", me);
        }
    }

    public boolean addMappingResolver(InputStreamMappingResolver mappingResolver) throws ConfigurationException, MappingException {
        return this.addInputStream(mappingResolver.getMappingAsInputStream(), mappingResolver.getName());
    }

    public boolean addInputStream(InputStream is, String resourceName) throws ConfigurationException, MappingException {
        if (resourceName.indexOf(this.getSuffix()) == -1) {
            return false;
        }
        try {
            boolean bl = this.doAddInputStream(is, resourceName);
            return bl;
        }
        catch (ConfigurationException e) {
            throw e;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {}
        }
    }

    protected abstract boolean doAddInputStream(InputStream var1, String var2) throws ConfigurationException, MappingException;

    protected abstract String getSuffix();
}

