/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.compass.core.Property;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.config.process.MappingProcessorUtils;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.osem.ClassIdPropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.mapping.osem.OsemMappingIterator;

public class InternalIdsMappingProcessor
implements MappingProcessor {
    private CompassSettings settings;
    private ConverterLookup converterLookup;

    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        this.settings = settings;
        this.converterLookup = converterLookup;
        Iterator it = compassMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping m = (Mapping)it.next();
            if (!(m instanceof ClassMapping)) continue;
            ClassMapping classMapping = (ClassMapping)m;
            if (classMapping.isSupportUnmarshall()) {
                this.buildClassMetaDataIds(classMapping);
                continue;
            }
            this.buildInternalIdForIdProperties(classMapping);
        }
        return compassMapping;
    }

    private void buildInternalIdForIdProperties(ClassMapping classMapping) {
        List idMappings = classMapping.findClassPropertyIdMappings();
        Iterator it = idMappings.iterator();
        while (it.hasNext()) {
            MappingProcessorUtils.addInternalId(this.settings, this.converterLookup, (ClassPropertyMapping)it.next());
        }
    }

    private void buildClassMetaDataIds(ClassMapping classMapping) {
        OsemMappingIterator.ClassPropertyAndResourcePropertyGatherer callback = new OsemMappingIterator.ClassPropertyAndResourcePropertyGatherer();
        OsemMappingIterator.iterateMappings(callback, classMapping);
        HashMap<String, Integer> propertyMappingsMap = new HashMap<String, Integer>();
        ArrayList pMappings = callback.getResourcePropertyMappings();
        Iterator it = pMappings.iterator();
        while (it.hasNext()) {
            ResourcePropertyMapping pMapping = (ResourcePropertyMapping)it.next();
            if (pMapping.getStore() == Property.Store.NO) continue;
            Integer count = (Integer)propertyMappingsMap.get(pMapping.getName());
            count = count == null ? new Integer(1) : new Integer(count + 1);
            propertyMappingsMap.put(pMapping.getName(), count);
        }
        ArrayList classPropertyMappings = callback.getClassPropertyMappings();
        Iterator it2 = classPropertyMappings.iterator();
        while (it2.hasNext()) {
            ClassPropertyMapping classPropertyMapping = (ClassPropertyMapping)it2.next();
            if (classPropertyMapping.getManagedId() == null) {
                if (classMapping.getManagedId() == null) {
                    String globalManagedId = this.settings.getSetting("compass.osem.managedId", "auto");
                    classPropertyMapping.setManagedId(ClassPropertyMapping.ManagedId.fromString(globalManagedId));
                } else {
                    classPropertyMapping.setManagedId(classMapping.getManagedId());
                }
            }
            boolean mustBeUnTokenized = false;
            if (classPropertyMapping instanceof ClassIdPropertyMapping) {
                mustBeUnTokenized = true;
            }
            if (classPropertyMapping.isIdPropertySet()) continue;
            if (classPropertyMapping.getManagedId() == ClassPropertyMapping.ManagedId.TRUE || classPropertyMapping.mappingsSize() == 0) {
                MappingProcessorUtils.addInternalId(this.settings, this.converterLookup, classPropertyMapping);
                continue;
            }
            if (classPropertyMapping.getManagedId() == ClassPropertyMapping.ManagedId.AUTO) {
                this.autoAddIfRequiredInternalId(propertyMappingsMap, classPropertyMapping, mustBeUnTokenized);
                continue;
            }
            if (classPropertyMapping.getManagedId() == ClassPropertyMapping.ManagedId.NO_STORE) {
                boolean allMetaDataHasStoreNo = true;
                for (int i = 0; i < classPropertyMapping.mappingsSize(); ++i) {
                    ClassPropertyMetaDataMapping pMapping = (ClassPropertyMetaDataMapping)classPropertyMapping.getMapping(i);
                    if (!pMapping.canActAsPropertyId() || pMapping.getStore() == Property.Store.NO) continue;
                    allMetaDataHasStoreNo = false;
                }
                if (allMetaDataHasStoreNo) continue;
                this.autoAddIfRequiredInternalId(propertyMappingsMap, classPropertyMapping, mustBeUnTokenized);
                continue;
            }
            if (classPropertyMapping.getManagedId() == ClassPropertyMapping.ManagedId.NO) continue;
            classPropertyMapping.setIdPropertyIndex(0);
        }
    }

    private void autoAddIfRequiredInternalId(HashMap propertyMappingsMap, ClassPropertyMapping classPropertyMapping, boolean mustBeUnTokenized) {
        boolean foundPropertyId = false;
        for (int i = 0; i < classPropertyMapping.mappingsSize(); ++i) {
            ClassPropertyMetaDataMapping pMapping = (ClassPropertyMetaDataMapping)classPropertyMapping.getMapping(i);
            if (!pMapping.canActAsPropertyId() || !propertyMappingsMap.containsKey(pMapping.getName()) || (Integer)propertyMappingsMap.get(pMapping.getName()) != 1 || pMapping.getStore() != Property.Store.YES && pMapping.getStore() != Property.Store.COMPRESS || mustBeUnTokenized && pMapping.getIndex() != Property.Index.UN_TOKENIZED) continue;
            classPropertyMapping.setIdPropertyIndex(i);
            foundPropertyId = true;
            break;
        }
        if (!foundPropertyId) {
            MappingProcessorUtils.addInternalId(this.settings, this.converterLookup, classPropertyMapping);
        }
    }
}

