/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter;

import [Ljava.lang.Byte;;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.converter.Converter;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.converter.basic.BigDecimalConverter;
import org.compass.core.converter.basic.BigIntegerConverter;
import org.compass.core.converter.basic.BooleanConverter;
import org.compass.core.converter.basic.ByteConverter;
import org.compass.core.converter.basic.CalendarConverter;
import org.compass.core.converter.basic.CharConverter;
import org.compass.core.converter.basic.DateConverter;
import org.compass.core.converter.basic.DoubleConverter;
import org.compass.core.converter.basic.FloatConverter;
import org.compass.core.converter.basic.IntConverter;
import org.compass.core.converter.basic.LongConverter;
import org.compass.core.converter.basic.ShortConverter;
import org.compass.core.converter.basic.StringBufferConverter;
import org.compass.core.converter.basic.StringConverter;
import org.compass.core.converter.basic.URIConverter;
import org.compass.core.converter.basic.URLConverter;
import org.compass.core.converter.dynamic.GroovyDynamicConverter;
import org.compass.core.converter.dynamic.JakartaElDynamicConverter;
import org.compass.core.converter.dynamic.JexlDynamicConverter;
import org.compass.core.converter.dynamic.OgnlDynamicConverter;
import org.compass.core.converter.dynamic.VelocityDynamicConverter;
import org.compass.core.converter.extended.FileConverter;
import org.compass.core.converter.extended.InputStreamConverter;
import org.compass.core.converter.extended.LocaleConverter;
import org.compass.core.converter.extended.ObjectByteArrayConverter;
import org.compass.core.converter.extended.PrimitiveByteArrayConverter;
import org.compass.core.converter.extended.ReaderConverter;
import org.compass.core.converter.extended.SqlDateConverter;
import org.compass.core.converter.extended.SqlTimeConverter;
import org.compass.core.converter.extended.SqlTimestampConverter;
import org.compass.core.converter.mapping.osem.ArrayMappingConverter;
import org.compass.core.converter.mapping.osem.ClassMappingConverter;
import org.compass.core.converter.mapping.osem.ClassPropertyMappingConverter;
import org.compass.core.converter.mapping.osem.CollectionMappingConverter;
import org.compass.core.converter.mapping.osem.ComponentMappingConverter;
import org.compass.core.converter.mapping.osem.ConstantMappingConverter;
import org.compass.core.converter.mapping.osem.ParentMappingConverter;
import org.compass.core.converter.mapping.osem.ReferenceMappingConverter;
import org.compass.core.converter.mapping.rsem.RawResourceMappingConverter;
import org.compass.core.converter.mapping.xsem.XmlContentMappingConverter;
import org.compass.core.converter.mapping.xsem.XmlIdMappingConverter;
import org.compass.core.converter.mapping.xsem.XmlObjectMappingConverter;
import org.compass.core.converter.mapping.xsem.XmlPropertyMappingConverter;
import org.compass.core.mapping.osem.ArrayMapping;
import org.compass.core.mapping.osem.ClassIdPropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.CollectionMapping;
import org.compass.core.mapping.osem.ComponentMapping;
import org.compass.core.mapping.osem.ConstantMetaDataMapping;
import org.compass.core.mapping.osem.DynamicMetaDataMapping;
import org.compass.core.mapping.osem.ParentMapping;
import org.compass.core.mapping.osem.ReferenceMapping;
import org.compass.core.mapping.rsem.RawResourceMapping;
import org.compass.core.mapping.xsem.XmlContentMapping;
import org.compass.core.mapping.xsem.XmlIdMapping;
import org.compass.core.mapping.xsem.XmlObjectMapping;
import org.compass.core.mapping.xsem.XmlPropertyMapping;
import org.compass.core.util.ClassUtils;

public class DefaultConverterLookup
implements ConverterLookup {
    private static final Log log = LogFactory.getLog((Class)DefaultConverterLookup.class);
    private final HashMap convertersByClass = new HashMap();
    private final HashMap cachedConvertersByClassType = new HashMap();
    private final HashMap convertersByName = new HashMap();
    private final HashMap defaultConveterTypes = new HashMap();

    public DefaultConverterLookup() {
        this.defaultConveterTypes.put("bigdecimal", BigDecimalConverter.class);
        this.defaultConveterTypes.put("biginteger", BigIntegerConverter.class);
        this.defaultConveterTypes.put("boolean", BooleanConverter.class);
        this.defaultConveterTypes.put("byte", ByteConverter.class);
        this.defaultConveterTypes.put("calendar", CalendarConverter.class);
        this.defaultConveterTypes.put("char", CharConverter.class);
        this.defaultConveterTypes.put("date", DateConverter.class);
        this.defaultConveterTypes.put("double", DoubleConverter.class);
        this.defaultConveterTypes.put("float", FloatConverter.class);
        this.defaultConveterTypes.put("int", IntConverter.class);
        this.defaultConveterTypes.put("long", LongConverter.class);
        this.defaultConveterTypes.put("short", ShortConverter.class);
        this.defaultConveterTypes.put("string", StringConverter.class);
        this.defaultConveterTypes.put("stringbuffer", StringBufferConverter.class);
        this.defaultConveterTypes.put("url", URLConverter.class);
        this.defaultConveterTypes.put("file", FileConverter.class);
        this.defaultConveterTypes.put("binary", InputStreamConverter.class);
        this.defaultConveterTypes.put("locale", LocaleConverter.class);
        this.defaultConveterTypes.put("primitivebytearray", PrimitiveByteArrayConverter.class);
        this.defaultConveterTypes.put("objectbytearray", ObjectByteArrayConverter.class);
        this.defaultConveterTypes.put("reader", ReaderConverter.class);
        this.defaultConveterTypes.put("sqldate", SqlDateConverter.class);
        this.defaultConveterTypes.put("sqltime", SqlTimeConverter.class);
        this.defaultConveterTypes.put("sqltimestamp", SqlTimestampConverter.class);
    }

    public void configure(CompassSettings settings) throws CompassException {
        Map converterGroups = settings.getSettingGroups("compass.converter");
        this.addDefaultConverter(converterGroups, "bigdecimal", BigDecimal.class, (Converter)new BigDecimalConverter());
        this.addDefaultConverter(converterGroups, "biginteger", BigInteger.class, (Converter)new BigIntegerConverter());
        this.addDefaultConverter(converterGroups, "boolean", new Class[]{Boolean.class, Boolean.TYPE}, (Converter)new BooleanConverter());
        this.addDefaultConverter(converterGroups, "byte", new Class[]{Byte.class, Byte.TYPE}, (Converter)new ByteConverter());
        this.addDefaultConverter(converterGroups, "char", new Class[]{Character.class, Character.TYPE}, (Converter)new CharConverter());
        this.addDefaultConverter(converterGroups, "date", Date.class, (Converter)new DateConverter());
        this.addDefaultConverter(converterGroups, "calendar", Calendar.class, (Converter)new CalendarConverter());
        this.addDefaultConverter(converterGroups, "double", new Class[]{Double.class, Double.TYPE}, (Converter)new DoubleConverter());
        this.addDefaultConverter(converterGroups, "float", new Class[]{Float.class, Float.TYPE}, (Converter)new FloatConverter());
        this.addDefaultConverter(converterGroups, "int", new Class[]{Integer.class, Integer.TYPE}, (Converter)new IntConverter());
        this.addDefaultConverter(converterGroups, "long", new Class[]{Long.class, Long.TYPE}, (Converter)new LongConverter());
        this.addDefaultConverter(converterGroups, "short", new Class[]{Short.class, Short.TYPE}, (Converter)new ShortConverter());
        this.addDefaultConverter(converterGroups, "string", String.class, (Converter)new StringConverter());
        this.addDefaultConverter(converterGroups, "stringbuffer", StringBuffer.class, (Converter)new StringBufferConverter());
        this.addDefaultConverter(converterGroups, "url", URL.class, (Converter)new URLConverter());
        this.addDefaultConverter(converterGroups, "uri", URI.class, (Converter)new URIConverter());
        this.addDefaultConverter(converterGroups, "file", File.class, (Converter)new FileConverter());
        this.addDefaultConverter(converterGroups, "binary", InputStream.class, (Converter)new InputStreamConverter());
        this.addDefaultConverter(converterGroups, "locale", Locale.class, (Converter)new LocaleConverter());
        this.addDefaultConverter(converterGroups, "primitivebytearray", [B.class, (Converter)new PrimitiveByteArrayConverter());
        this.addDefaultConverter(converterGroups, "objectbytearray", Byte;.class, (Converter)new ObjectByteArrayConverter());
        this.addDefaultConverter(converterGroups, "reader", Reader.class, (Converter)new ReaderConverter());
        this.addDefaultConverter(converterGroups, "sqldate", java.sql.Date.class, (Converter)new SqlDateConverter());
        this.addDefaultConverter(converterGroups, "sqltime", Time.class, (Converter)new SqlTimeConverter());
        this.addDefaultConverter(converterGroups, "sqltimestamp", Timestamp.class, (Converter)new SqlTimestampConverter());
        try {
            this.addDefaultConverter(converterGroups, "jexl", DynamicMetaDataMapping.class, (Converter)new JexlDynamicConverter());
            log.debug((Object)"Dynamic converter - JEXL found in the class path, registering it");
        }
        catch (Error e) {
            // empty catch block
        }
        try {
            this.addDefaultConverter(converterGroups, "velocity", DynamicMetaDataMapping.class, (Converter)new VelocityDynamicConverter());
            log.debug((Object)"Dynamic converter - Velocity found in the class path, registering it");
        }
        catch (Error e) {
            // empty catch block
        }
        try {
            this.addDefaultConverter(converterGroups, "el", DynamicMetaDataMapping.class, (Converter)new JakartaElDynamicConverter());
            log.debug((Object)"Dynamic converter - Jakarta EL found in the class path, registering it");
        }
        catch (Error e) {
            // empty catch block
        }
        try {
            this.addDefaultConverter(converterGroups, "ognl", DynamicMetaDataMapping.class, (Converter)new OgnlDynamicConverter());
            log.debug((Object)"Dynamic converter - OGNL found in the class path, registering it");
        }
        catch (Error e) {
            // empty catch block
        }
        try {
            this.addDefaultConverter(converterGroups, "groovy", DynamicMetaDataMapping.class, (Converter)new GroovyDynamicConverter());
            log.debug((Object)"Dynamic converter - GROOVY found in the class path, registering it");
        }
        catch (Error e) {
            // empty catch block
        }
        this.addDefaultConverter(converterGroups, "rawResourceMapping", RawResourceMapping.class, (Converter)new RawResourceMappingConverter());
        this.addDefaultConverter(converterGroups, "classMapping", ClassMapping.class, (Converter)new ClassMappingConverter());
        this.addDefaultConverter(converterGroups, "classPropertyMapping", ClassPropertyMapping.class, (Converter)new ClassPropertyMappingConverter());
        this.addDefaultConverter(converterGroups, "classIdPropertyMapping", ClassIdPropertyMapping.class, (Converter)new ClassPropertyMappingConverter());
        this.addDefaultConverter(converterGroups, "component", ComponentMapping.class, (Converter)new ComponentMappingConverter());
        this.addDefaultConverter(converterGroups, "collectionMapping", CollectionMapping.class, (Converter)new CollectionMappingConverter());
        this.addDefaultConverter(converterGroups, "arrayMapping", ArrayMapping.class, (Converter)new ArrayMappingConverter());
        this.addDefaultConverter(converterGroups, "referenceMapping", ReferenceMapping.class, (Converter)new ReferenceMappingConverter());
        this.addDefaultConverter(converterGroups, "constantMapping", ConstantMetaDataMapping.class, (Converter)new ConstantMappingConverter());
        this.addDefaultConverter(converterGroups, "parentMapping", ParentMapping.class, (Converter)new ParentMappingConverter());
        this.addDefaultConverter(converterGroups, "xmlObjectMapping", XmlObjectMapping.class, (Converter)new XmlObjectMappingConverter());
        this.addDefaultConverter(converterGroups, "xmlPropertyMapping", XmlPropertyMapping.class, (Converter)new XmlPropertyMappingConverter());
        this.addDefaultConverter(converterGroups, "xmlIdMapping", XmlIdMapping.class, (Converter)new XmlIdMappingConverter());
        this.addDefaultConverter(converterGroups, "xmlContentMapping", XmlContentMapping.class, (Converter)new XmlContentMappingConverter());
        Iterator it = converterGroups.keySet().iterator();
        while (it.hasNext()) {
            Converter converter;
            String converterClassType;
            String converterName = (String)it.next();
            CompassSettings converterSettings = (CompassSettings)converterGroups.get(converterName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Conveter [" + converterName + "] building..."));
            }
            if ((converterClassType = converterSettings.getSetting("type")) == null) {
                throw new ConfigurationException("Must define a class type for converter [" + converterName + "]");
            }
            try {
                Class converterClass = (Class)this.defaultConveterTypes.get(converterClassType);
                if (converterClass == null) {
                    converterClass = ClassUtils.forName(converterClassType);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Converter [" + converterName + "] is of type [" + converterClass.getName() + "]"));
                }
                converter = (Converter)converterClass.newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to create converter type [" + converterClassType + " for converter [" + converterName + "]", e);
            }
            if (converter instanceof CompassConfigurable) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Conveter [" + converterName + "] implements CompassConfigurable, configuring..."));
                }
                ((CompassConfigurable)((Object)converter)).configure(converterSettings);
            }
            this.convertersByName.put(converterName, converter);
            String registerClass = converterSettings.getSetting("registerClass");
            if (registerClass == null) continue;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Converter [" + converterName + "] registered under register type [" + registerClass + "]"));
                }
                this.cachedConvertersByClassType.put(ClassUtils.forName(registerClass), converter);
                this.convertersByClass.put(registerClass, converter);
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to create register class [" + registerClass + "] " + " for converter [" + converterName + "]", e);
            }
        }
    }

    private void addDefaultConverter(Map converterGroups, String name, Class type, Converter converter) {
        this.addDefaultConverter(converterGroups, name, new Class[]{type}, converter);
    }

    private void addDefaultConverter(Map converterGroups, String name, Class[] types, Converter converter) {
        String converterType;
        CompassSettings converterSettings = (CompassSettings)converterGroups.remove(name);
        if (converterSettings == null) {
            converterSettings = new CompassSettings();
        }
        if ((converterType = converterSettings.getSetting("type")) != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Converter [" + name + "] (default) configured with a non default type [" + converterType + "]"));
                }
                converter = (Converter)ClassUtils.forName(converterType).newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to create converter type [" + converterType + "] for " + "converter name [" + name + "]");
            }
        }
        if (converter instanceof CompassConfigurable) {
            ((CompassConfigurable)((Object)converter)).configure(converterSettings);
        }
        this.convertersByName.put(name, converter);
        for (int i = 0; i < types.length; ++i) {
            Class type = types[i];
            this.convertersByClass.put(type.getName(), converter);
            this.cachedConvertersByClassType.put(type, converter);
        }
    }

    public void registerConverter(String converterName, Converter converter) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Converter [" + converterName + "] registered"));
        }
        this.convertersByName.put(converterName, converter);
    }

    public void registerConverter(String converterName, Converter converter, Class registerType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Converter [" + converterName + "] registered with type [" + registerType + "]"));
        }
        this.convertersByName.put(converterName, converter);
        this.convertersByClass.put(registerType.getName(), converter);
        this.cachedConvertersByClassType.put(registerType, converter);
    }

    public Converter lookupConverter(String name) {
        Converter converter = (Converter)this.convertersByName.get(name);
        if (converter == null) {
            throw new IllegalArgumentException("Failed to find converter by name [" + name + "]");
        }
        return converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Converter lookupConverter(Class type) {
        Converter c = (Converter)this.cachedConvertersByClassType.get(type);
        if (c != null) {
            return c;
        }
        HashMap hashMap = this.cachedConvertersByClassType;
        synchronized (hashMap) {
            c = this.actualConverterLookup(type);
            this.cachedConvertersByClassType.put(type, c);
            return c;
        }
    }

    private Converter actualConverterLookup(Class type) {
        Converter c = (Converter)this.convertersByClass.get(type.getName());
        if (c != null) {
            return c;
        }
        Class<?>[] interfaces = type.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            c = (Converter)this.convertersByClass.get(interfaces[i].getName());
            if (c == null) continue;
            return c;
        }
        Class superClass = type.getSuperclass();
        if (superClass == null) {
            return null;
        }
        c = this.lookupConverter(superClass);
        if (c != null) {
            return c;
        }
        return null;
    }
}

