/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.basic.AbstractFormatConverter;
import org.compass.core.converter.basic.ThreadSafeFormat;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.marshall.MarshallingContext;

public abstract class AbstractNumberConverter
extends AbstractFormatConverter
implements CompassConfigurable {
    protected ThreadSafeFormat.FormatterFactory doCreateFormatterFactory() {
        return new NumberFormatter();
    }

    protected abstract Object defaultFromString(String var1, ResourcePropertyMapping var2);

    protected abstract Object fromNumber(Number var1);

    protected Object doFromString(String str, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) throws ConversionException {
        if (this.hasFormatter) {
            for (int i = 0; i < this.formatters.length; ++i) {
                try {
                    return this.fromNumber((Number)this.formatters[i].parse(str));
                }
                catch (ParseException e) {
                    continue;
                }
            }
            throw new ConversionException("Failed to parse date [" + str + "]");
        }
        return this.defaultFromString(str, resourcePropertyMapping);
    }

    protected String doToString(Object o, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        if (this.hasFormatter) {
            return this.formatters[0].format(o);
        }
        return this.defaultToString(o, resourcePropertyMapping, context);
    }

    protected String defaultToString(Object o, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return super.doToString(o, resourcePropertyMapping, context);
    }

    private static class NumberFormatter
    implements ThreadSafeFormat.FormatterFactory {
        private String format;
        private Locale locale;

        private NumberFormatter() {
        }

        public void configure(String format, Locale locale) {
            this.format = format;
            this.locale = locale;
        }

        public Format create() {
            NumberFormat numberFormat = this.locale != null ? NumberFormat.getInstance(this.locale) : NumberFormat.getInstance();
            ((DecimalFormat)numberFormat).applyPattern(this.format);
            return numberFormat;
        }
    }
}

