/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.osem;

import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.accessor.Getter;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.Converter;
import org.compass.core.converter.mapping.CollectionResourceWrapper;
import org.compass.core.engine.SearchEngine;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.osem.AbstractCollectionMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.marshall.MarshallingContext;

public abstract class AbstractCollectionMappingConverter
implements Converter {
    public static final String COLLECTION_RESOURCE_WRAPPER_KEY = "$crwk";

    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        SearchEngine searchEngine = context.getSearchEngine();
        AbstractCollectionMapping colMapping = (AbstractCollectionMapping)mapping;
        ClassMapping rootClassMapping = (ClassMapping)context.getAttribute("$rcmk");
        if (root == null) {
            if (context.handleNulls() && rootClassMapping.isSupportUnmarshall()) {
                Property p = searchEngine.createProperty(colMapping.getColSizePath().getPath(), searchEngine.getNullValue(), Property.Store.YES, Property.Index.UN_TOKENIZED);
                p.setOmitNorms(true);
                resource.addProperty(p);
                return true;
            }
            return false;
        }
        if (rootClassMapping.isSupportUnmarshall()) {
            if (colMapping.getCollectionType() == AbstractCollectionMapping.CollectionType.UNKNOWN) {
                Property p = searchEngine.createProperty(colMapping.getCollectionTypePath().getPath(), AbstractCollectionMapping.CollectionType.toString(this.getRuntimeCollectionType(root)), Property.Store.YES, Property.Index.UN_TOKENIZED);
                p.setOmitNorms(true);
                resource.addProperty(p);
            }
            context.setHandleNulls(colMapping.getPath());
        }
        int size = this.marshallIterateData(root, colMapping, resource, context);
        if (rootClassMapping.isSupportUnmarshall()) {
            context.removeHandleNulls(colMapping.getPath());
            Property p = searchEngine.createProperty(colMapping.getColSizePath().getPath(), Integer.toString(size), Property.Store.YES, Property.Index.UN_TOKENIZED);
            p.setOmitNorms(true);
            resource.addProperty(p);
        }
        return true;
    }

    protected abstract AbstractCollectionMapping.CollectionType getRuntimeCollectionType(Object var1);

    protected abstract int marshallIterateData(Object var1, AbstractCollectionMapping var2, Resource var3, MarshallingContext var4);

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        AbstractCollectionMapping colMapping = (AbstractCollectionMapping)mapping;
        SearchEngine searchEngine = context.getSearchEngine();
        Property pColSize = resource.getProperty(colMapping.getColSizePath().getPath());
        if (pColSize == null) {
            return null;
        }
        String sColSize = pColSize.getStringValue();
        if (searchEngine.isNullValue(sColSize)) {
            return null;
        }
        AbstractCollectionMapping.CollectionType collectionType = colMapping.getCollectionType();
        if (colMapping.getCollectionType() == AbstractCollectionMapping.CollectionType.UNKNOWN) {
            Property pColllectionType = resource.getProperty(colMapping.getCollectionTypePath().getPath());
            if (pColllectionType == null) {
                throw new ConversionException("Expected to find the collection/arraytype stored in the resource");
            }
            collectionType = AbstractCollectionMapping.CollectionType.fromString(pColllectionType.getStringValue());
        }
        int size = Integer.parseInt(sColSize);
        Object col = this.createColObject(colMapping.getGetter(), collectionType, size);
        context.setHandleNulls(colMapping.getPath());
        boolean createdCollectionResourceWrapper = false;
        CollectionResourceWrapper crw = (CollectionResourceWrapper)context.getAttribute(COLLECTION_RESOURCE_WRAPPER_KEY);
        if (crw == null) {
            createdCollectionResourceWrapper = true;
            crw = new CollectionResourceWrapper(resource);
            context.setAttribute(COLLECTION_RESOURCE_WRAPPER_KEY, crw);
        }
        Object current = context.getAttribute("current");
        Mapping elementMapping = colMapping.getElementMapping();
        for (int i = 0; i < size; ++i) {
            context.setAttribute("current", current);
            Object value = elementMapping.getConverter().unmarshall(crw, elementMapping, context);
            if (value == null) continue;
            this.addValue(col, i, value);
        }
        if (createdCollectionResourceWrapper) {
            context.removeAttribute(COLLECTION_RESOURCE_WRAPPER_KEY);
        }
        context.removeHandleNulls(colMapping.getPath());
        return col;
    }

    protected abstract Object createColObject(Getter var1, AbstractCollectionMapping.CollectionType var2, int var3);

    protected abstract void addValue(Object var1, int var2, Object var3);
}

