/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.osem;

import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.Converter;
import org.compass.core.converter.mapping.CollectionResourceWrapper;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.HasRefAliasMapping;
import org.compass.core.marshall.MarshallingContext;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.StringUtils;

public abstract class AbstractRefAliasMappingConverter
implements Converter {
    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        HasRefAliasMapping hasRefAliasMapping = (HasRefAliasMapping)mapping;
        ClassMapping[] classMappings = hasRefAliasMapping.getRefClassMappings();
        ClassMapping classMapping = root == null || classMappings.length == 1 ? classMappings[0] : this.extractClassMapping(context, root.getClass(), resource, hasRefAliasMapping);
        Object current = context.getAttribute("current");
        context.setAttribute("parent", current);
        return this.doMarshall(resource, root, hasRefAliasMapping, classMapping, context);
    }

    protected abstract boolean doMarshall(Resource var1, Object var2, HasRefAliasMapping var3, ClassMapping var4, MarshallingContext var5) throws ConversionException;

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        HasRefAliasMapping hasRefAliasMapping = (HasRefAliasMapping)mapping;
        ClassMapping[] classMappings = hasRefAliasMapping.getRefClassMappings();
        ClassMapping classMapping = null;
        if (classMappings.length == 1) {
            classMapping = classMappings[0];
        } else {
            int i;
            for (i = 0; i < classMappings.length; ++i) {
                Class clazz;
                if (!classMappings[i].isPoly()) continue;
                String classPath = classMappings[i].getClassPath().getPath();
                Property pClassName = resource.getProperty(classPath);
                if (resource instanceof CollectionResourceWrapper && this.rollbackClassNameOnPoly()) {
                    ((CollectionResourceWrapper)resource).rollbackGetProperty(classPath);
                }
                if (pClassName == null || pClassName.getStringValue() == null) continue;
                try {
                    clazz = ClassUtils.forName(pClassName.getStringValue());
                }
                catch (ClassNotFoundException e) {
                    throw new ConversionException("Failed to create class [" + pClassName.getStringValue() + "]", e);
                }
                classMapping = this.extractClassMapping(context, clazz, resource, hasRefAliasMapping);
                break;
            }
            if (classMapping == null) {
                for (i = 0; i < classMappings.length; ++i) {
                    if (classMappings[i].getPolyClass() == null) continue;
                    classMapping = classMappings[i];
                    break;
                }
            }
            if (classMapping == null) {
                classMapping = classMappings[0];
            }
        }
        Object current = context.getAttribute("current");
        context.setAttribute("parent", current);
        return this.doUnmarshall(resource, hasRefAliasMapping, classMapping, context);
    }

    private ClassMapping extractClassMapping(MarshallingContext context, Class clazz, Resource resource, HasRefAliasMapping hasRefAliasMapping) throws ConversionException {
        ClassMapping origClassMapping = (ClassMapping)context.getCompassMapping().getMappingByClass(clazz);
        if (origClassMapping == null) {
            throw new ConversionException("No class mapping found when marshalling root alias [" + resource.getAlias() + "] and class [" + clazz + "]");
        }
        ClassMapping classMapping = hasRefAliasMapping.getRefClassMapping(origClassMapping.getAlias());
        if (classMapping == null) {
            throw new ConversionException("Mapping for root alias [" + resource.getAlias() + "] with one of its mappings with multiple ref-alias [" + StringUtils.arrayToCommaDelimitedString(hasRefAliasMapping.getRefAliases()) + "] did not match [" + origClassMapping.getAlias() + "]");
        }
        return classMapping;
    }

    protected abstract Object doUnmarshall(Resource var1, HasRefAliasMapping var2, ClassMapping var3, MarshallingContext var4) throws ConversionException;

    protected boolean rollbackClassNameOnPoly() {
        return true;
    }
}

