/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.osem;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.accessor.Getter;
import org.compass.core.accessor.Setter;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.mapping.CollectionResourceWrapper;
import org.compass.core.converter.mapping.ResourceMappingConverter;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.utils.ResourceHelper;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.mapping.osem.ObjectMapping;
import org.compass.core.mapping.osem.OsemMapping;
import org.compass.core.marshall.MarshallingContext;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;
import org.compass.core.util.ClassUtils;

public class ClassMappingConverter
implements ResourceMappingConverter {
    public static final String ROOT_CLASS_MAPPING_KEY = "$rcmk";
    public static final String DISABLE_INTERNAL_MAPPINGS = "$dim";
    private static final Object DISABLE_INTERNAL_MAPPINGS_MARK = new Object();

    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        Object disableInternalMappings = context.getAttribute(DISABLE_INTERNAL_MAPPINGS);
        boolean store = this.doMarshall(resource, root, mapping, context);
        context.setAttribute(DISABLE_INTERNAL_MAPPINGS, disableInternalMappings);
        return store;
    }

    protected boolean doMarshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        IdsAliasesObjectKey idObjKey;
        SearchEngine searchEngine = context.getSearchEngine();
        ClassMapping classMapping = (ClassMapping)mapping;
        if (classMapping.isRoot()) {
            this.doSetBoost(resource, root, classMapping, context);
            context.setAttribute(ROOT_CLASS_MAPPING_KEY, classMapping);
            context.setAttribute(DISABLE_INTERNAL_MAPPINGS, null);
        } else if (!classMapping.isSupportUnmarshall()) {
            context.setAttribute(DISABLE_INTERNAL_MAPPINGS, DISABLE_INTERNAL_MAPPINGS_MARK);
        }
        if (root == null) {
            if (!classMapping.isSupportUnmarshall()) {
                return false;
            }
            if (!context.handleNulls()) {
                return false;
            }
            if (classMapping.getIdMappings().length == 0) {
                throw new ConversionException("Component mapping [" + classMapping.getAlias() + "] used within a collection/array and has null value, in such cases please define at least one id mapping on it");
            }
            ResourcePropertyMapping[] ids = classMapping.getIdMappings();
            boolean store = false;
            for (int i = 0; i < ids.length; ++i) {
                store |= ids[i].getConverter().marshall(resource, context.getSearchEngine().getNullValue(), ids[i], context);
            }
            return store;
        }
        if (classMapping.isPoly() && classMapping.getPolyClass() == null && (classMapping.isSupportUnmarshall() || classMapping.isRoot())) {
            this.storePolyClass(resource, root, searchEngine, classMapping);
        }
        if (classMapping.getIdMappings().length > 0 && !(idObjKey = new IdsAliasesObjectKey(classMapping, root)).hasNullId) {
            Object marshalled = context.getMarshalled(idObjKey);
            if (marshalled != null) {
                if (!classMapping.isSupportUnmarshall()) {
                    return true;
                }
                ResourcePropertyMapping[] ids = classMapping.getIdMappings();
                boolean store = false;
                for (int i = 0; i < ids.length; ++i) {
                    store |= ids[i].getConverter().marshall(resource, idObjKey.idsValues[i], ids[i], context);
                }
                return store;
            }
            context.setMarshalled(idObjKey, root);
        }
        boolean store = false;
        Iterator mappingsIt = classMapping.mappingsIt();
        while (mappingsIt.hasNext()) {
            Object value;
            context.setAttribute("current", root);
            OsemMapping m = (OsemMapping)mappingsIt.next();
            if (m.hasAccessors()) {
                Getter getter = ((ObjectMapping)m).getGetter();
                value = getter.get(root);
            } else {
                value = root;
            }
            store |= m.getConverter().marshall(resource, value, m, context);
        }
        return store;
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        Property[] propIds;
        ClassMapping classMapping = (ClassMapping)mapping;
        ResourceKey resourceKey = null;
        if (classMapping.isRoot()) {
            if (!classMapping.isSupportUnmarshall()) {
                Object obj = this.constructObjectForUnmarshalling(classMapping, resource);
                ResourcePropertyMapping[] ids = classMapping.getIdMappings();
                for (int i = 0; i < ids.length; ++i) {
                    Object idValue = ids[i].getConverter().unmarshall(resource, ids[i], context);
                    if (idValue == null) {
                        return null;
                    }
                    ((ClassPropertyMetaDataMapping)ids[i]).getSetter().set(obj, idValue);
                }
                return obj;
            }
            resourceKey = ((InternalResource)resource).resourceKey();
            Object cached = context.getUnmarshalled(resourceKey);
            if (cached != null) {
                return cached;
            }
        } else if (classMapping.getIdMappings().length > 0 && (propIds = ResourceHelper.toIds(resource, classMapping, false)) != null) {
            resourceKey = new ResourceKey((ResourceMapping)classMapping, propIds);
            Object cached = context.getUnmarshalled(resourceKey);
            if (cached != null) {
                return cached;
            }
            boolean nullClass = true;
            for (int i = 0; i < propIds.length; ++i) {
                if (context.getSearchEngine().isNullValue(propIds[i].getStringValue())) continue;
                nullClass = false;
            }
            if (nullClass) {
                return null;
            }
            if (resource instanceof CollectionResourceWrapper) {
                CollectionResourceWrapper colWrapper = (CollectionResourceWrapper)resource;
                ResourcePropertyMapping[] ids = classMapping.getIdMappings();
                for (int i = 0; i < ids.length; ++i) {
                    colWrapper.rollbackGetProperty(ids[i].getPath().getPath());
                }
            }
        }
        Object obj = this.constructObjectForUnmarshalling(classMapping, resource);
        context.setAttribute("current", obj);
        if (resourceKey != null) {
            context.setUnmarshalled(resourceKey, obj);
            if (classMapping.isRoot()) {
                context.getSession().getFirstLevelCache().set(resourceKey, obj);
            }
        }
        boolean isNullClass = true;
        Iterator mappingsIt = classMapping.mappingsIt();
        while (mappingsIt.hasNext()) {
            context.setAttribute("current", obj);
            OsemMapping m = (OsemMapping)mappingsIt.next();
            if (m.hasAccessors()) {
                Object value;
                Setter setter = ((ObjectMapping)m).getSetter();
                if (setter == null || (value = m.getConverter().unmarshall(resource, m, context)) == null) continue;
                setter.set(obj, value);
                if (!m.controlsObjectNullability()) continue;
                isNullClass = false;
                continue;
            }
            m.getConverter().unmarshall(resource, m, context);
        }
        if (isNullClass) {
            return null;
        }
        return obj;
    }

    protected Object constructObjectForUnmarshalling(ClassMapping classMapping, Resource resource) throws ConversionException {
        Object obj;
        Class clazz = classMapping.getClazz();
        Constructor constructor = classMapping.getConstructor();
        if (classMapping.isPoly()) {
            if (classMapping.getPolyClass() != null) {
                clazz = classMapping.getPolyClass();
                constructor = classMapping.getPolyConstructor();
            } else {
                Property pClassName = resource.getProperty(classMapping.getClassPath().getPath());
                if (pClassName == null) {
                    return null;
                }
                String className = pClassName.getStringValue();
                if (className == null) {
                    return null;
                }
                try {
                    clazz = ClassUtils.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new ConversionException("Failed to create class [" + className + "] for unmarshalling", e);
                }
                constructor = ClassUtils.getDefaultConstructor(clazz);
            }
        }
        try {
            obj = constructor.newInstance(null);
        }
        catch (Exception e) {
            throw new ConversionException("Failed to create class [" + clazz.getName() + "] for unmarshalling", e);
        }
        return obj;
    }

    public boolean marshallIds(Resource idResource, Object id, ResourceMapping resourceMapping, MarshallingContext context) throws ConversionException {
        ClassMapping classMapping = (ClassMapping)resourceMapping;
        boolean stored = false;
        ResourcePropertyMapping[] ids = classMapping.getIdMappings();
        if (classMapping.getClazz().isAssignableFrom(id.getClass())) {
            for (int i = 0; i < ids.length; ++i) {
                ClassPropertyMetaDataMapping classPropertyMetaDataMapping = (ClassPropertyMetaDataMapping)ids[i];
                stored |= this.convertId(idResource, classPropertyMetaDataMapping.getGetter().get(id), classPropertyMetaDataMapping, context);
            }
        } else if (id.getClass().isArray()) {
            if (Array.getLength(id) != ids.length) {
                throw new ConversionException("Trying to load class with [" + Array.getLength(id) + "] while has ids mappings of [" + ids.length + "]");
            }
            for (int i = 0; i < ids.length; ++i) {
                stored |= this.convertId(idResource, Array.get(id, i), (ClassPropertyMetaDataMapping)ids[i], context);
            }
        } else if (ids.length == 1) {
            stored = this.convertId(idResource, id, (ClassPropertyMetaDataMapping)ids[0], context);
        } else {
            String type = id.getClass().getName();
            throw new ConversionException("Cannot marshall ids, not supported id object type [" + type + "] and value [" + id + "], or you have not defined ids in the mapping files");
        }
        return stored;
    }

    private boolean convertId(Resource resource, Object root, ClassPropertyMetaDataMapping mdMapping, MarshallingContext context) {
        if (root == null) {
            throw new ConversionException("Trying to marshall a null id [" + mdMapping.getName() + "]");
        }
        return mdMapping.getConverter().marshall(resource, root, mdMapping, context);
    }

    public Object[] unmarshallIds(Object id, ResourceMapping resourceMapping, MarshallingContext context) throws ConversionException {
        ClassMapping classMapping = (ClassMapping)resourceMapping;
        ResourcePropertyMapping[] ids = classMapping.getIdMappings();
        Object[] idsValues = new Object[ids.length];
        if (id instanceof Resource) {
            Resource resource = (Resource)id;
            for (int i = 0; i < ids.length; ++i) {
                idsValues[i] = ids[i].getConverter().unmarshall(resource, ids[i], context);
                if (idsValues[i] != null) continue;
                return null;
            }
        } else if (classMapping.getClazz().isAssignableFrom(id.getClass())) {
            for (int i = 0; i < ids.length; ++i) {
                ClassPropertyMetaDataMapping classPropertyMetaDataMapping = (ClassPropertyMetaDataMapping)ids[i];
                idsValues[i] = classPropertyMetaDataMapping.getGetter().get(id);
            }
        } else if (id.getClass().isArray()) {
            if (Array.getLength(id) != ids.length) {
                throw new ConversionException("Trying to load class with [" + Array.getLength(id) + "] while has ids mappings of [" + ids.length + "]");
            }
            for (int i = 0; i < ids.length; ++i) {
                idsValues[i] = Array.get(id, i);
            }
        } else if (ids.length == 1) {
            idsValues[0] = id;
        } else {
            String type = id.getClass().getName();
            throw new ConversionException("Cannot marshall ids, not supported id object type [" + type + "] and value [" + id + "], or you have not defined ids in the mapping files");
        }
        return idsValues;
    }

    protected void doSetBoost(Resource resource, Object root, ClassMapping classMapping, MarshallingContext context) throws ConversionException {
        resource.setBoost(classMapping.getBoost());
    }

    protected void storePolyClass(Resource resource, Object root, SearchEngine searchEngine, ClassMapping classMapping) {
        String className = this.getPolyClassName(root);
        Property p = searchEngine.createProperty(classMapping.getClassPath().getPath(), className, Property.Store.YES, Property.Index.UN_TOKENIZED);
        p.setOmitNorms(true);
        resource.addProperty(p);
    }

    protected String getPolyClassName(Object root) {
        return root.getClass().getName();
    }

    protected static final class IdsAliasesObjectKey {
        private String alias;
        private Object[] idsValues;
        private boolean hasNullId;
        private int hashCode = Integer.MIN_VALUE;

        public IdsAliasesObjectKey(ClassMapping classMapping, Object value) {
            this.alias = classMapping.getAlias();
            ResourcePropertyMapping[] ids = classMapping.getIdMappings();
            this.idsValues = new Object[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                OsemMapping m = (OsemMapping)((Object)ids[i]);
                this.idsValues[i] = m.hasAccessors() ? ((ObjectMapping)m).getGetter().get(value) : value;
                if (this.idsValues[i] != null) continue;
                this.hasNullId = true;
            }
        }

        public Object[] getIdsValues() {
            return this.idsValues;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            IdsAliasesObjectKey key = (IdsAliasesObjectKey)other;
            if (!key.alias.equals(this.alias)) {
                return false;
            }
            for (int i = 0; i < this.idsValues.length; ++i) {
                if (key.idsValues[i].equals(this.idsValues[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.hashCode == Integer.MIN_VALUE) {
                this.hashCode = this.getHashCode();
            }
            return this.hashCode;
        }

        private int getHashCode() {
            int result = this.alias.hashCode();
            for (int i = 0; i < this.idsValues.length; ++i) {
                result = 29 * result + this.idsValues[i].hashCode();
            }
            return result;
        }

        public boolean isHasNullId() {
            return this.hasNullId;
        }
    }

    protected static final class IdentityAliasedObjectKey {
        private String alias;
        private Integer objHashCode;
        private int hashCode = Integer.MIN_VALUE;

        public IdentityAliasedObjectKey(String alias, Object value) {
            this.alias = alias;
            this.objHashCode = new Integer(System.identityHashCode(value));
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            IdentityAliasedObjectKey idObjKey = (IdentityAliasedObjectKey)other;
            return idObjKey.objHashCode.equals(this.objHashCode) && idObjKey.alias.equals(this.alias);
        }

        public int hashCode() {
            if (this.hashCode == Integer.MIN_VALUE) {
                this.hashCode = 13 * this.objHashCode.hashCode() + this.alias.hashCode();
            }
            return this.hashCode;
        }
    }
}

