/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.osem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.compass.core.Resource;
import org.compass.core.accessor.Getter;
import org.compass.core.converter.mapping.osem.AbstractCollectionMappingConverter;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.osem.AbstractCollectionMapping;
import org.compass.core.marshall.MarshallingContext;

public class CollectionMappingConverter
extends AbstractCollectionMappingConverter {
    protected int marshallIterateData(Object root, AbstractCollectionMapping colMapping, Resource resource, MarshallingContext context) {
        Object current = context.getAttribute("current");
        int count = 0;
        Mapping elementMapping = colMapping.getElementMapping();
        Collection col = (Collection)root;
        Iterator it = col.iterator();
        while (it.hasNext()) {
            Object value = it.next();
            if (value == null) continue;
            context.setAttribute("current", current);
            boolean stored = elementMapping.getConverter().marshall(resource, value, elementMapping, context);
            if (!stored) continue;
            ++count;
        }
        return count;
    }

    protected AbstractCollectionMapping.CollectionType getRuntimeCollectionType(Object root) {
        if (root instanceof List) {
            return AbstractCollectionMapping.CollectionType.LIST;
        }
        if (root instanceof SortedSet) {
            return AbstractCollectionMapping.CollectionType.SORTED_SET;
        }
        if (root instanceof Set) {
            return AbstractCollectionMapping.CollectionType.SET;
        }
        throw new IllegalStateException("Compass does not support collection class [" + root.getClass().getName() + "], please consider using either List or Set implementations");
    }

    protected Object createColObject(Getter getter, AbstractCollectionMapping.CollectionType collectionType, int size) {
        if (collectionType == AbstractCollectionMapping.CollectionType.LIST) {
            return new ArrayList(size);
        }
        if (collectionType == AbstractCollectionMapping.CollectionType.SET) {
            return new HashSet(size);
        }
        if (collectionType == AbstractCollectionMapping.CollectionType.SORTED_SET) {
            return new TreeSet();
        }
        throw new IllegalStateException("Should not happen, internal compass error");
    }

    protected void addValue(Object col, int index, Object value) {
        ((Collection)col).add(value);
    }
}

