/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.engine.naming;

import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.naming.DefaultPropertyNamingStrategy;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.engine.naming.PropertyNamingStrategyFactory;
import org.compass.core.util.ClassUtils;

public class DefaultPropertyNamingStrategyFactory
implements PropertyNamingStrategyFactory {
    public PropertyNamingStrategy createNamingStrategy(CompassSettings settings) {
        PropertyNamingStrategy namingStrategy;
        String namingStrategySetting = settings.getSetting("compass.property.naming", DefaultPropertyNamingStrategy.class.getName());
        try {
            namingStrategy = (PropertyNamingStrategy)ClassUtils.forName(namingStrategySetting).newInstance();
        }
        catch (Exception e) {
            throw new SearchEngineException("Cannot create naming Strategy [" + namingStrategySetting + "]. Please verify the naming setting at [" + "compass.property.naming" + "]", e);
        }
        if (namingStrategy instanceof CompassConfigurable) {
            ((CompassConfigurable)((Object)namingStrategy)).configure(settings);
        }
        return namingStrategy;
    }
}

