/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.compass.core.CompassException;
import org.compass.core.mapping.CascadeMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.spi.AliasedObject;
import org.compass.core.spi.InternalCompassSession;

public class CascadingManager {
    private InternalCompassSession session;
    private CompassMapping mapping;

    public CascadingManager(InternalCompassSession session) {
        this.session = session;
        this.mapping = session.getMapping();
    }

    public boolean cascade(Object root, CascadeMapping.Cascade cascade) throws CompassException {
        if (this.cascadingDisabled()) {
            return false;
        }
        if (root instanceof AliasedObject) {
            return this.cascade(((AliasedObject)root).getAlias(), root, cascade);
        }
        return this.cascade(root.getClass(), root, cascade);
    }

    public boolean cascade(String alias, Object root, CascadeMapping.Cascade cascade) throws CompassException {
        if (this.cascadingDisabled()) {
            return false;
        }
        ResourceMapping resourceMapping = this.mapping.getMappingByAlias(alias);
        if (resourceMapping == null) {
            return false;
        }
        return this.cascade(resourceMapping, root, cascade);
    }

    public boolean cascade(Class clazz, Object root, CascadeMapping.Cascade cascade) throws CompassException {
        if (this.cascadingDisabled()) {
            return false;
        }
        ResourceMapping resourceMapping = this.mapping.getMappingByClass(clazz);
        if (resourceMapping == null) {
            return false;
        }
        return this.cascade(resourceMapping, root, cascade);
    }

    private boolean cascade(ResourceMapping resourceMapping, Object root, CascadeMapping.Cascade cascade) throws CompassException {
        if (this.cascadingDisabled()) {
            return false;
        }
        CascadeMapping[] cascadeMappings = resourceMapping.getCascadeMappings();
        if (cascadeMappings == null) {
            return false;
        }
        boolean retVal = false;
        for (int i = 0; i < cascadeMappings.length; ++i) {
            CascadeMapping cascadeMapping = cascadeMappings[i];
            if (!cascadeMapping.shouldCascade(cascade)) continue;
            retVal = true;
            Object value = cascadeMapping.getCascadeValue(root);
            if (value == null) continue;
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                for (int j = 0; j < length; ++j) {
                    this.cascadeOperation(cascade, Array.get(value, j));
                }
                continue;
            }
            if (value instanceof Collection) {
                Iterator it = ((Collection)value).iterator();
                while (it.hasNext()) {
                    this.cascadeOperation(cascade, it.next());
                }
                continue;
            }
            this.cascadeOperation(cascade, value);
        }
        return retVal;
    }

    private void cascadeOperation(CascadeMapping.Cascade cascade, Object value) {
        if (value == null) {
            return;
        }
        if (cascade == CascadeMapping.Cascade.DELETE) {
            this.session.delete(value);
        } else if (cascade == CascadeMapping.Cascade.CREATE) {
            this.session.create(value);
        } else if (cascade == CascadeMapping.Cascade.SAVE) {
            this.session.save(value);
        } else {
            throw new IllegalArgumentException("Failed to perform cascading unknown type [" + cascade + "]");
        }
    }

    private boolean cascadingDisabled() {
        return this.session.getSettings().getSettingAsBoolean("compass.cascade.disable", false);
    }
}

