/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import org.compass.core.CompassException;
import org.compass.core.CompassHighlighter;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineHighlighter;
import org.compass.core.mapping.ResourcePropertyLookup;
import org.compass.core.spi.InternalCompassHits;
import org.compass.core.spi.InternalCompassSession;

public class DefaultCompassHighlighter
implements CompassHighlighter {
    private Resource resource;
    private SearchEngineHighlighter highlighter;
    private InternalCompassSession session;
    private InternalCompassHits hits;
    private int hitNumber;

    public DefaultCompassHighlighter(InternalCompassSession session, InternalCompassHits hits, int n) {
        this.session = session;
        this.hits = hits;
        this.hitNumber = n;
        this.highlighter = hits.getSearchEngineHits().getHighlighter();
        this.resource = hits.resource(n);
    }

    public CompassHighlighter setAnalyzer(String analyzerName) throws CompassException {
        this.highlighter.setAnalyzer(analyzerName);
        return this;
    }

    public CompassHighlighter setAnalyzer(Resource resource) throws CompassException {
        this.highlighter.setAnalyzer(resource);
        return this;
    }

    public CompassHighlighter setHighlighter(String highlighterName) throws CompassException {
        this.highlighter.setHighlighter(highlighterName);
        return this;
    }

    public CompassHighlighter setSeparator(String separator) throws CompassException {
        this.highlighter.setSeparator(separator);
        return this;
    }

    public CompassHighlighter setMaxNumFragments(int maxNumFragments) throws CompassException {
        this.highlighter.setMaxNumFragments(maxNumFragments);
        return this;
    }

    public CompassHighlighter setMaxBytesToAnalyze(int maxBytesToAnalyze) throws CompassException {
        this.highlighter.setMaxBytesToAnalyze(maxBytesToAnalyze);
        return this;
    }

    public CompassHighlighter setTextTokenizer(CompassHighlighter.TextTokenizer textTokenizer) throws CompassException {
        this.highlighter.setTextTokenizer(textTokenizer);
        return this;
    }

    public String fragment(String propertyName) throws CompassException {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(propertyName);
        String fragment = this.highlighter.fragment(this.resource, lookup.getPath());
        this.hits.setHighlightedText(this.hitNumber, propertyName, fragment);
        return fragment;
    }

    public String fragment(String propertyName, String text) throws CompassException {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(propertyName);
        String fragment = this.highlighter.fragment(this.resource, lookup.getPath(), text);
        this.hits.setHighlightedText(this.hitNumber, propertyName, fragment);
        return fragment;
    }

    public String[] fragments(String propertyName) throws CompassException {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(propertyName);
        return this.highlighter.fragments(this.resource, lookup.getPath());
    }

    public String[] fragments(String propertyName, String text) throws CompassException {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(propertyName);
        return this.highlighter.fragments(this.resource, lookup.getPath(), text);
    }

    public String fragmentsWithSeparator(String propertyName) throws CompassException {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(propertyName);
        String fragment = this.highlighter.fragmentsWithSeparator(this.resource, lookup.getPath());
        this.hits.setHighlightedText(this.hitNumber, propertyName, fragment);
        return fragment;
    }

    public String fragmentsWithSeparator(String propertyName, String text) throws CompassException {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(propertyName);
        String fragment = this.highlighter.fragmentsWithSeparator(this.resource, lookup.getPath(), text);
        this.hits.setHighlightedText(this.hitNumber, propertyName, fragment);
        return fragment;
    }

    public String[] multiResourceFragment(String propertyName) throws CompassException {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(propertyName);
        String[] fragments = this.highlighter.multiResourceFragment(this.resource, lookup.getPath());
        return fragments;
    }

    public String[] multiResourceFragment(String propertyName, String[] texts) throws CompassException {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(propertyName);
        String[] fragments = this.highlighter.multiResourceFragment(this.resource, lookup.getPath(), texts);
        return fragments;
    }

    public String multiResourceFragmentWithSeparator(String propertyName) throws CompassException {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(propertyName);
        String fragment = this.highlighter.multiResourceFragmentWithSeparator(this.resource, lookup.getPath());
        this.hits.setHighlightedText(this.hitNumber, propertyName, fragment);
        return fragment;
    }

    public String multiResourceFragmentWithSeparator(String propertyName, String[] texts) throws CompassException {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(propertyName);
        String fragment = this.highlighter.multiResourceFragmentWithSeparator(this.resource, lookup.getPath(), texts);
        this.hits.setHighlightedText(this.hitNumber, propertyName, fragment);
        return fragment;
    }
}

