/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import java.io.Reader;
import java.io.Serializable;
import org.compass.core.CompassException;
import org.compass.core.CompassQuery;
import org.compass.core.CompassQueryBuilder;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.impl.DefaultCompassQuery;
import org.compass.core.mapping.ResourcePropertyLookup;
import org.compass.core.spi.InternalCompassSession;

public class DefaultCompassQueryBuilder
implements CompassQueryBuilder {
    private SearchEngineQueryBuilder queryBuilder;
    private InternalCompassSession session;

    public DefaultCompassQueryBuilder(SearchEngineQueryBuilder queryBuilder, InternalCompassSession session) {
        this.queryBuilder = queryBuilder;
        this.session = session;
    }

    public CompassQueryBuilder.CompassBooleanQueryBuilder bool() {
        return new DefaultCompassBooleanQueryBuilder(this.queryBuilder.bool(), this.session);
    }

    public CompassQueryBuilder.CompassBooleanQueryBuilder bool(boolean disableCoord) {
        return new DefaultCompassBooleanQueryBuilder(this.queryBuilder.bool(disableCoord), this.session);
    }

    public CompassQueryBuilder.CompassMultiPhraseQueryBuilder multiPhrase(String name) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        return new DefaultCompassMultiPhraseQueryBuilder(this.queryBuilder.multiPhrase(lookup.getPath()), this.session, lookup);
    }

    public CompassQueryBuilder.CompassQueryStringBuilder queryString(String queryString) {
        return new DefaultCompassQueryStringBuilder(this.queryBuilder.queryString(queryString), this.session);
    }

    public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder multiPropertyQueryString(String queryString) {
        return new DefaultCompassMultiPropertyQueryStringBuilder(this.queryBuilder.multiPropertyQueryString(queryString), this.session);
    }

    public CompassQuery alias(String aliasValue) {
        if (!this.session.getCompass().getMapping().hasRootMappingByAlias(aliasValue)) {
            throw new CompassException("Alias [" + aliasValue + "] not found in Compass mappings definitions");
        }
        String aliasProperty = this.session.getCompass().getSearchEngineFactory().getAliasProperty();
        SearchEngineQuery query = this.queryBuilder.term(aliasProperty, aliasValue);
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery polyAlias(String aliasValue) {
        return this.bool().addShould(this.term(this.session.getCompass().getSearchEngineFactory().getAliasProperty(), aliasValue)).addShould(this.term(this.session.getCompass().getSearchEngineFactory().getExtendedAliasProperty(), aliasValue)).toQuery();
    }

    public CompassQuery term(String name, Object value) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.term(lookup.getPath(), lookup.getValue(value));
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery matchAll() {
        SearchEngineQuery query = this.queryBuilder.matchAll();
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery between(String name, Object low, Object high, boolean inclusive, boolean constantScore) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.between(lookup.getPath(), lookup.getValue(low), lookup.getValue(high), inclusive, constantScore);
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery between(String name, Object low, Object high, boolean inclusive) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.between(lookup.getPath(), lookup.getValue(low), lookup.getValue(high), inclusive);
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery lt(String name, Object value) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.lt(lookup.getPath(), lookup.getValue(value));
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery le(String name, Object value) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.le(lookup.getPath(), lookup.getValue(value));
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery gt(String name, Object value) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.gt(lookup.getPath(), lookup.getValue(value));
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery ge(String name, Object value) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.ge(lookup.getPath(), lookup.getValue(value));
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery prefix(String name, String prefix) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.prefix(lookup.getPath(), prefix);
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery wildcard(String name, String wildcard) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.wildcard(lookup.getPath(), wildcard);
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery fuzzy(String name, String value, float minimumSimilarity) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.fuzzy(lookup.getPath(), value, minimumSimilarity);
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery fuzzy(String name, String value, float minimumSimilarity, int prefixLength) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.fuzzy(lookup.getPath(), value, minimumSimilarity, prefixLength);
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery fuzzy(String name, String value) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery query = this.queryBuilder.fuzzy(lookup.getPath(), value);
        return new DefaultCompassQuery(query, this.session);
    }

    public CompassQuery.CompassSpanQuery spanEq(String name, Object value) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery.SearchEngineSpanQuery query = this.queryBuilder.spanEq(lookup.getPath(), lookup.getValue(value));
        return new DefaultCompassQuery.DefaultCompassSpanQuey(query, this.session);
    }

    public CompassQuery.CompassSpanQuery spanFirst(String name, Object value, int end) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        SearchEngineQuery.SearchEngineSpanQuery query = this.queryBuilder.spanFirst(lookup.getPath(), lookup.getValue(value), end);
        return new DefaultCompassQuery.DefaultCompassSpanQuey(query, this.session);
    }

    public CompassQuery.CompassSpanQuery spanFirst(CompassQuery.CompassSpanQuery spanQuery, int end) {
        SearchEngineQuery.SearchEngineSpanQuery query = this.queryBuilder.spanFirst(((DefaultCompassQuery.DefaultCompassSpanQuey)spanQuery).getSearchEngineSpanQuery(), end);
        return new DefaultCompassQuery.DefaultCompassSpanQuey(query, this.session);
    }

    public CompassQueryBuilder.CompassQuerySpanNearBuilder spanNear(String name) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        return new DefaultCompassQuerySpanNearBuilder(this.queryBuilder.spanNear(lookup.getPath()), this.session, lookup);
    }

    public CompassQuery.CompassSpanQuery spanNot(CompassQuery.CompassSpanQuery include, CompassQuery.CompassSpanQuery exclude) {
        SearchEngineQuery.SearchEngineSpanQuery query = this.queryBuilder.spanNot(((DefaultCompassQuery.DefaultCompassSpanQuey)include).getSearchEngineSpanQuery(), ((DefaultCompassQuery.DefaultCompassSpanQuey)exclude).getSearchEngineSpanQuery());
        return new DefaultCompassQuery.DefaultCompassSpanQuey(query, this.session);
    }

    public CompassQueryBuilder.CompassQuerySpanOrBuilder spanOr() {
        return new DefaultCompassQuerySpanOrBuilder(this.queryBuilder.spanOr(), this.session);
    }

    public CompassQueryBuilder.CompassMoreLikeThisQuery moreLikeThis(String alias, Serializable id) {
        Resource idResource = this.session.getMarshallingStrategy().marshallIds(alias, (Object)id);
        SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder mltQueryBuilder = this.queryBuilder.moreLikeThis(idResource);
        return new DefaultCompassMoreLikeThisQuery(mltQueryBuilder, this.session);
    }

    public CompassQueryBuilder.CompassMoreLikeThisQuery moreLikeThis(Reader reader) {
        SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder mltQueryBuilder = this.queryBuilder.moreLikeThis(reader);
        return new DefaultCompassMoreLikeThisQuery(mltQueryBuilder, this.session);
    }

    public static class DefaultCompassMoreLikeThisQuery
    implements CompassQueryBuilder.CompassMoreLikeThisQuery {
        private SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder queryBuilder;
        private InternalCompassSession session;

        public DefaultCompassMoreLikeThisQuery(SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder queryBuilder, InternalCompassSession session) {
            this.queryBuilder = queryBuilder;
            this.session = session;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setSubIndexes(String[] subIndexes) {
            this.queryBuilder.setSubIndexes(subIndexes);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setAliases(String[] aliases) {
            this.queryBuilder.setAliases(aliases);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setProperties(String[] properties) {
            if (properties == null) {
                this.queryBuilder.setProperties(properties);
            } else {
                String[] updatedProperties = new String[properties.length];
                for (int i = 0; i < properties.length; ++i) {
                    ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(properties[i]);
                    updatedProperties[i] = lookup.getPath();
                }
                this.queryBuilder.setProperties(updatedProperties);
            }
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery addProperty(String property) {
            ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(property);
            this.queryBuilder.addProperty(lookup.getPath());
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setAnalyzer(String analyzer) {
            this.queryBuilder.setAnalyzer(analyzer);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setBoost(boolean boost) {
            this.queryBuilder.setBoost(boost);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setMaxNumTokensParsed(int maxNumTokensParsed) {
            this.queryBuilder.setMaxNumTokensParsed(maxNumTokensParsed);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setMaxQueryTerms(int maxQueryTerms) {
            this.queryBuilder.setMaxQueryTerms(maxQueryTerms);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setMaxWordLen(int maxWordLen) {
            this.queryBuilder.setMaxWordLen(maxWordLen);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setMinWordLen(int minWordLen) {
            this.queryBuilder.setMinWordLen(minWordLen);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setMinResourceFreq(int minDocFreq) {
            this.queryBuilder.setMinResourceFreq(minDocFreq);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setMinTermFreq(int minTermFreq) {
            this.queryBuilder.setMinTermFreq(minTermFreq);
            return this;
        }

        public CompassQueryBuilder.CompassMoreLikeThisQuery setStopWords(String[] stopWords) {
            this.queryBuilder.setStopWords(stopWords);
            return this;
        }

        public CompassQuery toQuery() {
            SearchEngineQuery query = this.queryBuilder.toQuery();
            return new DefaultCompassQuery(query, this.session);
        }
    }

    public static class DefaultCompassQuerySpanOrBuilder
    implements CompassQueryBuilder.CompassQuerySpanOrBuilder {
        private SearchEngineQueryBuilder.SearchEngineQuerySpanOrBuilder queryBuilder;
        private InternalCompassSession session;

        public DefaultCompassQuerySpanOrBuilder(SearchEngineQueryBuilder.SearchEngineQuerySpanOrBuilder queryBuilder, InternalCompassSession session) {
            this.queryBuilder = queryBuilder;
            this.session = session;
        }

        public CompassQueryBuilder.CompassQuerySpanOrBuilder add(CompassQuery.CompassSpanQuery query) {
            this.queryBuilder.add(((DefaultCompassQuery.DefaultCompassSpanQuey)query).getSearchEngineSpanQuery());
            return this;
        }

        public CompassQuery.CompassSpanQuery toQuery() {
            SearchEngineQuery.SearchEngineSpanQuery query = this.queryBuilder.toQuery();
            return new DefaultCompassQuery.DefaultCompassSpanQuey(query, this.session);
        }
    }

    public static class DefaultCompassQuerySpanNearBuilder
    implements CompassQueryBuilder.CompassQuerySpanNearBuilder {
        private SearchEngineQueryBuilder.SearchEngineQuerySpanNearBuilder queryBuilder;
        private InternalCompassSession session;
        private ResourcePropertyLookup lookup;

        public DefaultCompassQuerySpanNearBuilder(SearchEngineQueryBuilder.SearchEngineQuerySpanNearBuilder queryBuilder, InternalCompassSession session, ResourcePropertyLookup lookup) {
            this.queryBuilder = queryBuilder;
            this.session = session;
            this.lookup = lookup;
        }

        public CompassQueryBuilder.CompassQuerySpanNearBuilder setSlop(int slop) {
            this.queryBuilder.setSlop(slop);
            return this;
        }

        public CompassQueryBuilder.CompassQuerySpanNearBuilder setInOrder(boolean inOrder) {
            this.queryBuilder.setInOrder(inOrder);
            return this;
        }

        public CompassQueryBuilder.CompassQuerySpanNearBuilder add(Object value) {
            this.queryBuilder.add(this.lookup.getValue(value));
            return this;
        }

        public CompassQueryBuilder.CompassQuerySpanNearBuilder add(CompassQuery.CompassSpanQuery query) {
            this.queryBuilder.add(((DefaultCompassQuery.DefaultCompassSpanQuey)query).getSearchEngineSpanQuery());
            return this;
        }

        public CompassQuery.CompassSpanQuery toQuery() {
            SearchEngineQuery.SearchEngineSpanQuery query = this.queryBuilder.toQuery();
            return new DefaultCompassQuery.DefaultCompassSpanQuey(query, this.session);
        }
    }

    public static class DefaultCompassMultiPropertyQueryStringBuilder
    implements CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder {
        private SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder queryBuilder;
        private InternalCompassSession session;

        public DefaultCompassMultiPropertyQueryStringBuilder(SearchEngineQueryBuilder.SearchEngineMultiPropertyQueryStringBuilder queryBuilder, InternalCompassSession session) {
            this.queryBuilder = queryBuilder;
            this.session = session;
        }

        public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder setAnalyzer(String analyzer) throws CompassException {
            this.queryBuilder.setAnalyzer(analyzer);
            return this;
        }

        public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder setAnalyzerByAlias(String alias) throws CompassException {
            this.queryBuilder.setAnalyzerByAlias(alias);
            return this;
        }

        public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder setQueryParser(String queryParser) throws CompassException {
            this.queryBuilder.setQueryParser(queryParser);
            return this;
        }

        public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder add(String name) {
            this.queryBuilder.add(this.session.getMapping().getResourcePropertyLookup(name).getPath());
            return this;
        }

        public CompassQueryBuilder.CompassMultiPropertyQueryStringBuilder useAndDefaultOperator() {
            this.queryBuilder.useAndDefaultOperator();
            return this;
        }

        public CompassQuery toQuery() {
            SearchEngineQuery query = this.queryBuilder.toQuery();
            return new DefaultCompassQuery(query, this.session);
        }
    }

    public static class DefaultCompassQueryStringBuilder
    implements CompassQueryBuilder.CompassQueryStringBuilder {
        private SearchEngineQueryBuilder.SearchEngineQueryStringBuilder queryBuilder;
        private InternalCompassSession session;

        public DefaultCompassQueryStringBuilder(SearchEngineQueryBuilder.SearchEngineQueryStringBuilder queryBuilder, InternalCompassSession session) {
            this.queryBuilder = queryBuilder;
            this.session = session;
        }

        public CompassQueryBuilder.CompassQueryStringBuilder setAnalyzer(String analyzer) throws CompassException {
            this.queryBuilder.setAnalyzer(analyzer);
            return this;
        }

        public CompassQueryBuilder.CompassQueryStringBuilder setAnalyzerByAlias(String alias) throws CompassException {
            this.queryBuilder.setAnalyzerByAlias(alias);
            return this;
        }

        public CompassQueryBuilder.CompassQueryStringBuilder setQueryParser(String queryParser) throws CompassException {
            this.queryBuilder.setQueryParser(queryParser);
            return this;
        }

        public CompassQueryBuilder.CompassQueryStringBuilder setDefaultSearchProperty(String defaultSearchProperty) {
            this.queryBuilder.setDefaultSearchProperty(defaultSearchProperty);
            return this;
        }

        public CompassQueryBuilder.CompassQueryStringBuilder useAndDefaultOperator() {
            this.queryBuilder.useAndDefaultOperator();
            return this;
        }

        public CompassQuery toQuery() {
            SearchEngineQuery query = this.queryBuilder.toQuery();
            return new DefaultCompassQuery(query, this.session);
        }
    }

    public static class DefaultCompassMultiPhraseQueryBuilder
    implements CompassQueryBuilder.CompassMultiPhraseQueryBuilder {
        private SearchEngineQueryBuilder.SearchEngineMultiPhraseQueryBuilder queryBuilder;
        private InternalCompassSession session;
        private ResourcePropertyLookup lookup;

        public DefaultCompassMultiPhraseQueryBuilder(SearchEngineQueryBuilder.SearchEngineMultiPhraseQueryBuilder queryBuilder, InternalCompassSession session, ResourcePropertyLookup lookup) {
            this.queryBuilder = queryBuilder;
            this.session = session;
            this.lookup = lookup;
        }

        public CompassQueryBuilder.CompassMultiPhraseQueryBuilder setSlop(int slop) {
            this.queryBuilder.setSlop(slop);
            return this;
        }

        public CompassQueryBuilder.CompassMultiPhraseQueryBuilder add(Object value) {
            this.queryBuilder.add(this.lookup.getValue(value));
            return this;
        }

        public CompassQueryBuilder.CompassMultiPhraseQueryBuilder add(Object value, int position) {
            this.queryBuilder.add(this.lookup.getValue(value), position);
            return this;
        }

        public CompassQueryBuilder.CompassMultiPhraseQueryBuilder add(Object[] values) {
            String[] strValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                strValues[i] = this.lookup.getValue(values[i]);
            }
            this.queryBuilder.add(strValues);
            return this;
        }

        public CompassQueryBuilder.CompassMultiPhraseQueryBuilder add(Object[] values, int position) {
            String[] strValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                strValues[i] = this.lookup.getValue(values[i]);
            }
            this.queryBuilder.add(strValues, position);
            return this;
        }

        public CompassQuery toQuery() {
            SearchEngineQuery query = this.queryBuilder.toQuery();
            return new DefaultCompassQuery(query, this.session);
        }
    }

    public static class DefaultCompassBooleanQueryBuilder
    implements CompassQueryBuilder.CompassBooleanQueryBuilder {
        private SearchEngineQueryBuilder.SearchEngineBooleanQueryBuilder queryBuilder;
        private InternalCompassSession session;

        public DefaultCompassBooleanQueryBuilder(SearchEngineQueryBuilder.SearchEngineBooleanQueryBuilder queryBuilder, InternalCompassSession session) {
            this.queryBuilder = queryBuilder;
            this.session = session;
        }

        public CompassQueryBuilder.CompassBooleanQueryBuilder addMust(CompassQuery query) {
            this.queryBuilder.addMust(((DefaultCompassQuery)query).getSearchEngineQuery());
            return this;
        }

        public CompassQueryBuilder.CompassBooleanQueryBuilder addMustNot(CompassQuery query) {
            this.queryBuilder.addMustNot(((DefaultCompassQuery)query).getSearchEngineQuery());
            return this;
        }

        public CompassQueryBuilder.CompassBooleanQueryBuilder addShould(CompassQuery query) {
            this.queryBuilder.addShould(((DefaultCompassQuery)query).getSearchEngineQuery());
            return this;
        }

        public CompassQuery toQuery() {
            SearchEngineQuery query = this.queryBuilder.toQuery();
            return new DefaultCompassQuery(query, this.session);
        }
    }
}

