/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.jndi;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.config.CompassSettings;
import org.compass.core.jndi.NamingHelper;
import org.compass.core.util.backport.java.util.concurrent.ConcurrentHashMap;

public class CompassObjectFactory
implements ObjectFactory {
    private static final CompassObjectFactory INSTANCE;
    private static final Log log;
    private static final Map INSTANCES;
    private static final Map NAMED_INSTANCES;
    private static final NamingListener LISTENER;

    public Object getObjectInstance(Object reference, Name name, Context ctx, Hashtable env) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("JNDI lookup for [" + name + "]"));
        }
        String uid = (String)((Reference)reference).get(0).getContent();
        return CompassObjectFactory.getInstance(uid);
    }

    public static void addInstance(String uid, String name, Compass instance, CompassSettings settings) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering compass [" + uid + "] with [" + (name == null ? "unnamed" : name) + ']'));
        }
        INSTANCES.put(uid, instance);
        if (name != null) {
            NAMED_INSTANCES.put(name, instance);
        }
        if (name == null) {
            log.info((Object)"Not binding compass to JNDI, no JNDI name configured");
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Binding compass to JNDI under [" + name + "]"));
            }
            try {
                InitialContext ctx = NamingHelper.getInitialContext(settings);
                NamingHelper.bind(ctx, name, instance);
                ((EventContext)((Object)ctx)).addNamingListener(name, 0, LISTENER);
            }
            catch (InvalidNameException ine) {
                log.error((Object)("Invalid JNDI name [" + name + "]"), (Throwable)ine);
            }
            catch (NamingException ne) {
                log.warn((Object)"Could not bind compass to JNDI", (Throwable)ne);
            }
            catch (ClassCastException cce) {
                log.warn((Object)"InitialContext did not implement EventContext");
            }
        }
    }

    public static void removeInstance(String uid, String name, CompassSettings settings) {
        if (name != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Unbinding compass from JNDI name [" + name + "]"));
            }
            try {
                InitialContext ctx = NamingHelper.getInitialContext(settings);
                ctx.unbind(name);
            }
            catch (InvalidNameException ine) {
                log.error((Object)("Invalid JNDI name [" + name + "]"), (Throwable)ine);
            }
            catch (NamingException ne) {
                log.warn((Object)"Could not unbind compass from JNDI", (Throwable)ne);
            }
            NAMED_INSTANCES.remove(name);
        }
        INSTANCES.remove(uid);
    }

    public static Object getNamedInstance(String name) {
        Object result;
        if (log.isDebugEnabled()) {
            log.debug((Object)("lookup with name [" + name + "]"));
        }
        if ((result = NAMED_INSTANCES.get(name)) == null) {
            log.warn((Object)("Not found [" + name + "]"));
            log.debug((Object)NAMED_INSTANCES);
        }
        return result;
    }

    public static Object getInstance(String uid) {
        Object result;
        if (log.isDebugEnabled()) {
            log.debug((Object)("JNDI lookup for uid [" + uid + "]"));
        }
        if ((result = INSTANCES.get(uid)) == null) {
            log.warn((Object)("Not found [" + uid + "]"));
            log.debug((Object)INSTANCES);
        }
        return result;
    }

    static {
        log = LogFactory.getLog((Class)CompassObjectFactory.class);
        INSTANCE = new CompassObjectFactory();
        log.debug((Object)("Initializing class CompassObjectFactory. Using static instance [" + INSTANCE + "]"));
        INSTANCES = new ConcurrentHashMap();
        NAMED_INSTANCES = new ConcurrentHashMap();
        LISTENER = new NamespaceChangeListener(){

            public void objectAdded(NamingEvent evt) {
                log.debug((Object)("Compass was successfully bound to name [" + evt.getNewBinding().getName() + "]"));
            }

            public void objectRemoved(NamingEvent evt) {
                String name = evt.getOldBinding().getName();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Compass was unbound from name [" + name + "]"));
                }
                Object instance = NAMED_INSTANCES.remove(name);
                Iterator iter = INSTANCES.values().iterator();
                while (iter.hasNext()) {
                    if (iter.next() != instance) continue;
                    iter.remove();
                }
            }

            public void objectRenamed(NamingEvent evt) {
                String name = evt.getOldBinding().getName();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Compass was renamed from name [" + name + "]"));
                }
                NAMED_INSTANCES.put(evt.getNewBinding().getName(), NAMED_INSTANCES.remove(name));
            }

            public void namingExceptionThrown(NamingExceptionEvent evt) {
                log.warn((Object)("Naming exception occurred accessing compass: " + evt.getException()));
            }
        };
    }
}

