/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.ResourcePropertyConverter;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.LuceneProperty;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.util.LuceneUtils;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.spi.AliasedObject;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;
import org.compass.core.util.StringUtils;

public class LuceneResource
implements AliasedObject,
InternalResource,
Map {
    private static final long serialVersionUID = 3904681565727306034L;
    private Document document;
    private ArrayList properties = new ArrayList();
    private String aliasProperty;
    private int docNum;
    private transient LuceneSearchEngine searchEngine;
    private transient ResourceMapping resourceMapping;
    private transient ResourceKey resourceKey;

    public LuceneResource(String alias, LuceneSearchEngine searchEngine) {
        this(alias, new Document(), -1, searchEngine);
    }

    public LuceneResource(Document document, int docNum, LuceneSearchEngine searchEngine) {
        this(null, document, docNum, searchEngine);
    }

    public LuceneResource(String alias, Document document, int docNum, LuceneSearchEngine searchEngine) {
        this.document = document;
        this.searchEngine = searchEngine;
        this.aliasProperty = searchEngine.getSearchEngineFactory().getAliasProperty();
        this.docNum = docNum;
        if (alias != null) {
            this.removeProperties(this.aliasProperty);
            Field aliasField = new Field(this.aliasProperty, alias, Field.Store.YES, Field.Index.UN_TOKENIZED);
            aliasField.setOmitNorms(true);
            document.add((Fieldable)aliasField);
        }
        this.verifyResourceMapping();
        List fields = document.getFields();
        Iterator fieldsIt = fields.iterator();
        while (fieldsIt.hasNext()) {
            Field field = (Field)fieldsIt.next();
            LuceneProperty lProperty = new LuceneProperty(field);
            lProperty.setPropertyMapping(this.resourceMapping.getResourcePropertyMapping(field.name()));
            this.properties.add(lProperty);
        }
    }

    public void copy(Resource resource) {
        LuceneResource luceneResource = (LuceneResource)resource;
        this.document = luceneResource.document;
        this.docNum = luceneResource.docNum;
        this.properties = luceneResource.properties;
        this.aliasProperty = luceneResource.aliasProperty;
        this.searchEngine = luceneResource.searchEngine;
        this.resourceMapping = luceneResource.resourceMapping;
    }

    public Document getDocument() {
        return this.document;
    }

    public ResourceKey resourceKey() {
        if (this.resourceKey == null) {
            this.resourceKey = new ResourceKey(this.resourceMapping, this);
        }
        return this.resourceKey;
    }

    public String get(String name) {
        return this.document.get(name);
    }

    public Object getObject(String name) {
        Property prop = this.getProperty(name);
        if (prop == null) {
            return null;
        }
        return prop.getObjectValue();
    }

    public String[] getValues(String name) {
        return this.document.getValues(name);
    }

    public String getAlias() {
        return this.get(this.aliasProperty);
    }

    public String getId() {
        String[] ids = this.getIds();
        return ids[0];
    }

    public String[] getIds() {
        Property[] idProperties = this.getIdProperties();
        String[] ids = new String[idProperties.length];
        for (int i = 0; i < idProperties.length; ++i) {
            if (idProperties[i] == null) continue;
            ids[i] = idProperties[i].getStringValue();
        }
        return ids;
    }

    public Property getIdProperty() {
        Property[] idProperties = this.getIdProperties();
        return idProperties[0];
    }

    public Property[] getIdProperties() {
        ResourcePropertyMapping[] resourcePropertyMappings = this.resourceMapping.getIdMappings();
        Property[] idProperties = new Property[resourcePropertyMappings.length];
        for (int i = 0; i < resourcePropertyMappings.length; ++i) {
            idProperties[i] = this.getProperty(resourcePropertyMappings[i].getPath().getPath());
        }
        return idProperties;
    }

    public Resource addProperty(String name, Object value) throws SearchEngineException {
        String alias = this.getAlias();
        ResourcePropertyMapping propertyMapping = this.resourceMapping.getResourcePropertyMapping(name);
        if (propertyMapping == null) {
            throw new SearchEngineException("No resource property mapping is defined for alias [" + alias + "] and resource property [" + name + "]");
        }
        ResourcePropertyConverter converter = (ResourcePropertyConverter)propertyMapping.getConverter();
        if (converter == null) {
            converter = (ResourcePropertyConverter)this.searchEngine.getSearchEngineFactory().getMapping().getConverterLookup().lookupConverter(value.getClass());
        }
        String strValue = converter.toString(value, propertyMapping);
        Property property = this.searchEngine.createProperty(strValue, propertyMapping);
        property.setBoost(propertyMapping.getBoost());
        return this.addProperty(property);
    }

    public Resource addProperty(String name, Reader value) throws SearchEngineException {
        String alias = this.getAlias();
        ResourcePropertyMapping propertyMapping = this.resourceMapping.getResourcePropertyMapping(name);
        if (propertyMapping == null) {
            throw new SearchEngineException("No resource property mapping is defined for alias [" + alias + "] and resource property [" + name + "]");
        }
        Field.TermVector fieldTermVector = LuceneUtils.getFieldTermVector(propertyMapping.getTermVector());
        Field field = new Field(name, value, fieldTermVector);
        LuceneProperty property = new LuceneProperty(field);
        property.setBoost(propertyMapping.getBoost());
        property.setPropertyMapping(propertyMapping);
        return this.addProperty(property);
    }

    public Resource addProperty(Property property) {
        LuceneProperty lProperty = (LuceneProperty)property;
        lProperty.setPropertyMapping(this.resourceMapping.getResourcePropertyMapping(property.getName()));
        this.properties.add(property);
        this.document.add((Fieldable)lProperty.getField());
        return this;
    }

    public Resource removeProperty(String name) {
        this.document.removeField(name);
        Iterator it = this.properties.iterator();
        while (it.hasNext()) {
            Property property = (Property)it.next();
            if (!property.getName().equals(name)) continue;
            it.remove();
            return this;
        }
        return this;
    }

    public Resource removeProperties(String name) {
        this.document.removeFields(name);
        Iterator it = this.properties.iterator();
        while (it.hasNext()) {
            Property property = (Property)it.next();
            if (!property.getName().equals(name)) continue;
            it.remove();
        }
        return this;
    }

    public Property getProperty(String name) {
        for (int i = 0; i < this.properties.size(); ++i) {
            Property property = (Property)this.properties.get(i);
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public Property[] getProperties(String name) {
        ArrayList<Property> result = new ArrayList<Property>();
        for (int i = 0; i < this.properties.size(); ++i) {
            Property property = (Property)this.properties.get(i);
            if (!property.getName().equals(name)) continue;
            result.add(property);
        }
        if (result.size() == 0) {
            return new Property[0];
        }
        return result.toArray(new Property[result.size()]);
    }

    public Property[] getProperties() {
        return this.properties.toArray(new LuceneProperty[this.properties.size()]);
    }

    public float getBoost() {
        return this.document.getBoost();
    }

    public Resource setBoost(float boost) {
        this.document.setBoost(boost);
        return this;
    }

    public void setDocNum(int docNum) {
        this.docNum = docNum;
    }

    public int getDocNum() {
        return this.docNum;
    }

    private void verifyResourceMapping() throws SearchEngineException {
        String alias = this.getAlias();
        if (this.resourceMapping == null) {
            if (alias == null) {
                throw new SearchEngineException("Can't add a resource property based on resource mapping without an alias associated with the resource first");
            }
            if (!this.searchEngine.getSearchEngineFactory().getMapping().hasRootMappingByAlias(alias)) {
                throw new SearchEngineException("No mapping is defined for alias [" + alias + "]");
            }
            this.resourceMapping = this.searchEngine.getSearchEngineFactory().getMapping().getRootMappingByAlias(alias);
        }
    }

    public String toString() {
        return "{" + this.getAlias() + "} " + StringUtils.arrayToCommaDelimitedString(this.getProperties());
    }

    public void clear() {
        throw new UnsupportedOperationException("Map operations are supported for read operations only");
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Map operations are supported for read operations only");
    }

    public void putAll(Map t) {
        Iterator it = t.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        this.removeProperties(key.toString());
        return null;
    }

    public Object put(Object key, Object value) {
        this.removeProperties(key.toString());
        if (value instanceof Property) {
            this.addProperty((Property)value);
        } else if (value instanceof Property[]) {
            Property[] valueProps = (Property[])value;
            for (int i = 0; i < valueProps.length; ++i) {
                this.addProperty(valueProps[i]);
            }
        }
        return null;
    }

    public Set entrySet() {
        Set keySey = this.keySet();
        Set<1> entrySet = Collections.unmodifiableSet(new HashSet());
        Iterator it = keySey.iterator();
        while (it.hasNext()) {
            final String name = it.next().toString();
            final Property[] props = this.getProperties(name);
            entrySet.add(new Map.Entry(){

                public Object getKey() {
                    return name;
                }

                public Object getValue() {
                    return props;
                }

                public Object setValue(Object value) {
                    LuceneResource.this.put(name, value);
                    return null;
                }
            });
        }
        return entrySet;
    }

    public Set keySet() {
        HashSet<String> keySet = new HashSet<String>();
        Iterator it = this.properties.iterator();
        while (it.hasNext()) {
            keySet.add(((Property)it.next()).getName());
        }
        return Collections.unmodifiableSet(keySet);
    }

    public boolean containsKey(Object key) {
        return this.getProperty(key.toString()) != null;
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Collection values() {
        Set keySey = this.keySet();
        List<Object> values = Collections.unmodifiableList(new ArrayList());
        Iterator it = keySey.iterator();
        while (it.hasNext()) {
            values.add(this.get(it.next()));
        }
        return values;
    }

    public Object get(Object key) {
        return this.getProperties(key.toString());
    }
}

