/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Field;
import org.compass.core.CompassTransaction;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.RuntimeCompassSettings;
import org.compass.core.engine.RepeatableReader;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineAnalyzerHelper;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineHits;
import org.compass.core.engine.SearchEngineInternalSearch;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.engine.SearchEngineQueryFilterBuilder;
import org.compass.core.engine.SearchEngineTermFrequencies;
import org.compass.core.engine.event.SearchEngineEventManager;
import org.compass.core.lucene.LuceneMultiResource;
import org.compass.core.lucene.LuceneProperty;
import org.compass.core.lucene.engine.LuceneSearchEngineAnalyzerHelper;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneSearchEngineTermFrequencies;
import org.compass.core.lucene.engine.query.LuceneSearchEngineQueryBuilder;
import org.compass.core.lucene.engine.query.LuceneSearchEngineQueryFilterBuilder;
import org.compass.core.lucene.engine.transaction.BatchInsertTransaction;
import org.compass.core.lucene.engine.transaction.LuceneSearchEngineTransaction;
import org.compass.core.lucene.engine.transaction.ReadCommittedTransaction;
import org.compass.core.lucene.engine.transaction.SerialableTransaction;
import org.compass.core.lucene.util.LuceneUtils;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.MultiResource;
import org.compass.core.spi.ResourceKey;
import org.compass.core.util.StringUtils;
import org.compass.core.util.reader.ReverseStringReader;

public class LuceneSearchEngine
implements SearchEngine {
    protected static final Log log = LogFactory.getLog((Class)LuceneSearchEngine.class);
    private static final int UNKNOWN = -1;
    private static final int STARTED = 0;
    private static final int COMMIT = 1;
    private static final int ROLLBACK = 2;
    private int transactionState;
    private LuceneSearchEngineTransaction transaction;
    private LuceneSearchEngineFactory searchEngineFactory;
    private SearchEngineEventManager eventManager = new SearchEngineEventManager();
    private boolean readOnly;
    private RuntimeCompassSettings runtimeSettings;

    public LuceneSearchEngine(RuntimeCompassSettings runtimeSettings, LuceneSearchEngineFactory searchEngineFactory) {
        this.runtimeSettings = runtimeSettings;
        this.readOnly = true;
        this.searchEngineFactory = searchEngineFactory;
        this.transactionState = -1;
        this.eventManager.registerLifecycleListener(searchEngineFactory.getEventManager());
        searchEngineFactory.getLuceneIndexManager().getStore().registerEventListeners(this, this.eventManager);
    }

    public String getNullValue() {
        return "";
    }

    public boolean isNullValue(String value) {
        return value == null || value.length() == 0;
    }

    public Resource createResource(String alias) throws SearchEngineException {
        return new LuceneMultiResource(alias, this);
    }

    public Property createProperty(String value, ResourcePropertyMapping mapping) throws SearchEngineException {
        return this.createProperty(mapping.getPath().getPath(), value, mapping);
    }

    public Property createProperty(String value, ResourcePropertyMapping mapping, Property.Store store, Property.Index index) throws SearchEngineException {
        return this.createProperty(mapping.getPath().getPath(), value, mapping, store, index);
    }

    public Property createProperty(String name, String value, ResourcePropertyMapping mapping) throws SearchEngineException {
        return this.createProperty(name, value, mapping, mapping.getStore(), mapping.getIndex());
    }

    public Property createProperty(String name, String value, ResourcePropertyMapping mapping, Property.Store store, Property.Index index) throws SearchEngineException {
        Property property;
        if (mapping.getReverse() == ResourcePropertyMapping.ReverseType.NO) {
            property = this.createProperty(name, value, store, index, mapping.getTermVector());
        } else if (mapping.getReverse() == ResourcePropertyMapping.ReverseType.READER) {
            property = this.createProperty(name, new ReverseStringReader(value), mapping.getTermVector());
        } else if (mapping.getReverse() == ResourcePropertyMapping.ReverseType.STRING) {
            property = this.createProperty(name, StringUtils.reverse(value), store, index, mapping.getTermVector());
        } else {
            throw new SearchEngineException("Unsupported Reverse type [" + mapping.getReverse() + "]");
        }
        property.setBoost(mapping.getBoost());
        property.setOmitNorms(mapping.isOmitNorms());
        ((LuceneProperty)property).setPropertyMapping(mapping);
        return property;
    }

    public Property createProperty(String name, String value, Property.Store store, Property.Index index) throws SearchEngineException {
        return this.createProperty(name, value, store, index, Property.TermVector.NO);
    }

    public Property createProperty(String name, String value, Property.Store store, Property.Index index, Property.TermVector termVector) throws SearchEngineException {
        Field.Store fieldStore = LuceneUtils.getFieldStore(store);
        Field.Index fieldIndex = LuceneUtils.getFieldIndex(index);
        Field.TermVector fieldTermVector = LuceneUtils.getFieldTermVector(termVector);
        Field field = new Field(name, value, fieldStore, fieldIndex, fieldTermVector);
        return new LuceneProperty(field);
    }

    public Property createProperty(String name, Reader value) {
        return this.createProperty(name, value, Property.TermVector.NO);
    }

    public Property createProperty(String name, byte[] value, Property.Store store) throws SearchEngineException {
        Field.Store fieldStore = LuceneUtils.getFieldStore(store);
        Field field = new Field(name, value, fieldStore);
        return new LuceneProperty(field);
    }

    public Property createProperty(String name, Reader value, Property.TermVector termVector) {
        Field.TermVector fieldTermVector = LuceneUtils.getFieldTermVector(termVector);
        Field field = new Field(name, value, fieldTermVector);
        if (value instanceof RepeatableReader) {
            return new LuceneProperty(field, (RepeatableReader)((Object)value));
        }
        return new LuceneProperty(field);
    }

    public SearchEngineQueryBuilder queryBuilder() throws SearchEngineException {
        return new LuceneSearchEngineQueryBuilder(this);
    }

    public SearchEngineQueryFilterBuilder queryFilterBuilder() throws SearchEngineException {
        return new LuceneSearchEngineQueryFilterBuilder();
    }

    public SearchEngineAnalyzerHelper analyzerHelper() {
        return new LuceneSearchEngineAnalyzerHelper(this);
    }

    public void begin() throws SearchEngineException {
        this.readOnly = true;
        if (this.transactionState == 0) {
            throw new SearchEngineException("Transaction already started, why start it again?");
        }
        Class transactionIsolationClass = this.searchEngineFactory.getLuceneSettings().getTransactionIsolationClass();
        if (transactionIsolationClass != null) {
            this.transactionState = -1;
            try {
                this.transaction = (LuceneSearchEngineTransaction)transactionIsolationClass.newInstance();
            }
            catch (Exception e) {
                throw new SearchEngineException("Failed to create an instance for transaction [" + transactionIsolationClass.getName() + "]", e);
            }
            this.transaction.configure(this);
            this.eventManager.beforeBeginTransaction();
            this.transaction.begin();
            this.eventManager.afterBeginTransaction();
            this.transactionState = 0;
            return;
        }
        CompassTransaction.TransactionIsolation transactionIsolation = this.searchEngineFactory.getLuceneSettings().getTransactionIsolation();
        this.begin(transactionIsolation);
    }

    public void begin(CompassTransaction.TransactionIsolation transactionIsolation) throws SearchEngineException {
        if (this.transactionState == 0) {
            throw new SearchEngineException("Transaction already started, why start it again?");
        }
        this.transactionState = -1;
        this.readOnly = true;
        if (transactionIsolation == null) {
            transactionIsolation = this.searchEngineFactory.getLuceneSettings().getTransactionIsolation();
        }
        if (transactionIsolation == CompassTransaction.TransactionIsolation.READ_COMMITTED) {
            this.transaction = new ReadCommittedTransaction();
        } else if (transactionIsolation == CompassTransaction.TransactionIsolation.READ_ONLY_READ_COMMITTED) {
            this.transaction = new ReadCommittedTransaction();
        } else if (transactionIsolation == CompassTransaction.TransactionIsolation.BATCH_INSERT) {
            this.transaction = new BatchInsertTransaction();
        } else if (transactionIsolation == CompassTransaction.TransactionIsolation.SERIALIZABLE) {
            this.transaction = new SerialableTransaction();
        }
        this.transaction.configure(this);
        this.eventManager.beforeBeginTransaction();
        this.transaction.begin();
        this.eventManager.afterBeginTransaction();
        this.transactionState = 0;
    }

    public void verifyWithinTransaction() throws SearchEngineException {
        if (this.transactionState != 0) {
            throw new SearchEngineException("Search engine transaction not successfully started or already committed/rolledback");
        }
    }

    public boolean isWithinTransaction() throws SearchEngineException {
        return this.transactionState == 0;
    }

    public void prepare() throws SearchEngineException {
        this.verifyWithinTransaction();
        if (this.transaction != null) {
            this.transaction.prepare();
        }
        this.eventManager.afterPrepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(boolean onePhase) throws SearchEngineException {
        this.verifyWithinTransaction();
        try {
            if (this.transaction != null) {
                this.transaction.commit(onePhase);
                this.eventManager.afterCommit(onePhase);
            }
        }
        finally {
            this.transaction = null;
            this.transactionState = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SearchEngineException {
        this.verifyWithinTransaction();
        try {
            if (this.transaction != null) {
                this.transaction.rollback();
                this.eventManager.afterRollback();
            }
        }
        finally {
            this.transaction = null;
            this.transactionState = 2;
        }
    }

    public void flush() throws SearchEngineException {
        this.verifyWithinTransaction();
        if (this.transaction != null) {
            this.transaction.flush();
        }
    }

    public boolean wasRolledBack() throws SearchEngineException {
        return this.transactionState == 2;
    }

    public boolean wasCommitted() throws SearchEngineException {
        return this.transactionState == 1;
    }

    public void close() throws SearchEngineException {
        this.eventManager.close();
        if (this.transactionState == 0) {
            log.warn((Object)"Transaction not committed/rolled backed, rolling back");
            try {
                this.rollback();
            }
            catch (Exception e) {
                log.warn((Object)"Failed to rollback transcation, ignoring", (Throwable)e);
            }
        }
        this.eventManager = null;
    }

    public void delete(Resource resource) throws SearchEngineException {
        this.verifyWithinTransaction();
        this.readOnly = false;
        if (resource instanceof MultiResource) {
            MultiResource multiResource = (MultiResource)resource;
            for (int i = 0; i < multiResource.size(); ++i) {
                this.delete(((InternalResource)multiResource.resource(i)).resourceKey());
            }
        } else {
            this.delete(((InternalResource)resource).resourceKey());
        }
    }

    private void delete(ResourceKey resourceKey) throws SearchEngineException {
        if (resourceKey.getIds().length == 0) {
            throw new SearchEngineException("Cannot delete a resource with no ids");
        }
        this.transaction.delete(resourceKey);
        if (log.isDebugEnabled()) {
            log.debug((Object)("RESOURCE DELETE {" + resourceKey.getAlias() + "} " + StringUtils.arrayToCommaDelimitedString(resourceKey.getIds())));
        }
    }

    public void create(Resource resource) throws SearchEngineException {
        this.verifyWithinTransaction();
        this.readOnly = false;
        String alias = resource.getAlias();
        ResourceMapping resourceMapping = this.searchEngineFactory.getMapping().getRootMappingByAlias(alias);
        if (resourceMapping == null) {
            throw new SearchEngineException("Failed to find mapping for alias [" + alias + "]");
        }
        if (resource instanceof MultiResource) {
            MultiResource multiResource = (MultiResource)resource;
            for (int i = 0; i < multiResource.size(); ++i) {
                Resource resource1 = multiResource.resource(i);
                LuceneUtils.addAllPropertyIfNeeded(resource1, resourceMapping, this);
                LuceneUtils.addExtendedProeprty(resource1, resourceMapping, this);
                this.transaction.create((InternalResource)resource1);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("RESOURCE CREATE " + resource1));
            }
        } else {
            LuceneUtils.addAllPropertyIfNeeded(resource, resourceMapping, this);
            LuceneUtils.addExtendedProeprty(resource, resourceMapping, this);
            this.transaction.create((InternalResource)resource);
            if (log.isDebugEnabled()) {
                log.debug((Object)("RESOURCE CREATE " + resource));
            }
        }
    }

    public void save(Resource resource) throws SearchEngineException {
        this.readOnly = true;
        this.delete(resource);
        this.create(resource);
    }

    public Resource get(Resource idResource) throws SearchEngineException {
        this.verifyWithinTransaction();
        ResourceKey resourceKey = ((InternalResource)idResource).resourceKey();
        if (resourceKey.getIds().length == 0) {
            throw new SearchEngineException("Cannot load a resource with no ids");
        }
        Resource[] result = this.transaction.find(resourceKey);
        if (result.length == 0) {
            return null;
        }
        if (result.length > 1) {
            log.warn((Object)("Found several matches in get/load operation for resource alias [" + resourceKey.getAlias() + "] and ids [" + StringUtils.arrayToCommaDelimitedString(resourceKey.getIds()) + "]"));
            return result[result.length - 1];
        }
        return result[0];
    }

    public Resource load(Resource idResource) throws SearchEngineException {
        String alias = idResource.getAlias();
        Resource resource = this.get(idResource);
        if (resource == null) {
            throw new SearchEngineException("Failed to find resource with alias [" + alias + "] and ids [" + StringUtils.arrayToCommaDelimitedString(idResource.getIds()) + "]");
        }
        return resource;
    }

    public SearchEngineHits find(SearchEngineQuery query) throws SearchEngineException {
        this.verifyWithinTransaction();
        SearchEngineHits hits = this.transaction.find(query);
        if (log.isDebugEnabled()) {
            log.debug((Object)("RESOURCE QUERY [" + query + "] HITS [" + hits.getLength() + "]"));
        }
        return hits;
    }

    public SearchEngineTermFrequencies termFreq(String[] propertyNames, int size, SearchEngineInternalSearch internalSearch) {
        return new LuceneSearchEngineTermFrequencies(propertyNames, size, (LuceneSearchEngineInternalSearch)internalSearch);
    }

    public SearchEngineInternalSearch internalSearch(String[] subIndexes, String[] aliases) throws SearchEngineException {
        this.verifyWithinTransaction();
        return this.transaction.internalSearch(subIndexes, aliases);
    }

    public LuceneSearchEngineFactory getSearchEngineFactory() {
        return this.searchEngineFactory;
    }

    public CompassSettings getSettings() {
        return this.runtimeSettings;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }
}

