/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.RuntimeCompassSettings;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineFactory;
import org.compass.core.engine.SearchEngineIndexManager;
import org.compass.core.engine.SearchEngineOptimizer;
import org.compass.core.engine.event.SearchEngineEventManager;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSettings;
import org.compass.core.lucene.engine.analyzer.LuceneAnalyzerManager;
import org.compass.core.lucene.engine.highlighter.LuceneHighlighterManager;
import org.compass.core.lucene.engine.indexdeletionpolicy.IndexDeletionPolicyFactory;
import org.compass.core.lucene.engine.manager.DefaultLuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.optimizer.AdaptiveOptimizer;
import org.compass.core.lucene.engine.optimizer.LuceneSearchEngineOptimizer;
import org.compass.core.lucene.engine.queryparser.LuceneQueryParserManager;
import org.compass.core.lucene.engine.store.LuceneSearchEngineStore;
import org.compass.core.lucene.engine.store.LuceneSearchEngineStoreFactory;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.util.ClassUtils;

public class LuceneSearchEngineFactory
implements SearchEngineFactory {
    private static final Log log;
    private CompassMapping mapping;
    private PropertyNamingStrategy propertyNamingStrategy;
    private LuceneSettings luceneSettings;
    private LuceneSearchEngineOptimizer searchEngineOptimizer;
    private LuceneSearchEngineIndexManager indexManager;
    private LuceneAnalyzerManager analyzerManager;
    private LuceneHighlighterManager highlighterManager;
    private LuceneQueryParserManager queryParserManager;
    private IndexDeletionPolicyFactory indexDeletionPolicyManager;
    private CompassSettings settings;
    private SearchEngineEventManager eventManager = new SearchEngineEventManager();

    public LuceneSearchEngineFactory(PropertyNamingStrategy propertyNamingStrategy, CompassSettings settings, CompassMapping mapping) {
        this.propertyNamingStrategy = propertyNamingStrategy;
        this.mapping = mapping;
        this.settings = settings;
        this.luceneSettings = new LuceneSettings();
        this.luceneSettings.configure(settings);
        this.configure(settings, mapping);
    }

    public void close() throws SearchEngineException {
        this.indexManager.close();
    }

    public SearchEngine openSearchEngine(RuntimeCompassSettings runtimeSettings) {
        return new LuceneSearchEngine(runtimeSettings, this);
    }

    private void configure(CompassSettings settings, CompassMapping mapping) {
        this.analyzerManager = new LuceneAnalyzerManager();
        this.analyzerManager.configure(settings, mapping, this.luceneSettings);
        this.indexDeletionPolicyManager = new IndexDeletionPolicyFactory();
        this.indexDeletionPolicyManager.configure(settings);
        this.queryParserManager = new LuceneQueryParserManager(this);
        this.queryParserManager.configure(settings);
        String subContext = settings.getSetting("compass.engine.connection.subContext", "index");
        LuceneSearchEngineStore searchEngineStore = LuceneSearchEngineStoreFactory.createStore(this.luceneSettings.getConnection(), subContext);
        searchEngineStore.configure(this, settings, mapping);
        this.indexManager = new DefaultLuceneSearchEngineIndexManager(this, searchEngineStore);
        try {
            ClassUtils.forName("org.apache.lucene.search.highlight.Highlighter");
            this.highlighterManager = new LuceneHighlighterManager();
            this.highlighterManager.configure(settings);
        }
        catch (ClassNotFoundException e1) {
            log.info((Object)"Not using highlighter - no highlighter jar included.");
        }
        String optimizerClassSetting = settings.getSetting("compass.engine.optimizer.type", AdaptiveOptimizer.class.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using optimizer [" + optimizerClassSetting + "]"));
        }
        try {
            Class optimizerClass = ClassUtils.forName(optimizerClassSetting);
            this.searchEngineOptimizer = (LuceneSearchEngineOptimizer)optimizerClass.newInstance();
            if (this.searchEngineOptimizer instanceof CompassConfigurable) {
                ((CompassConfigurable)((Object)this.searchEngineOptimizer)).configure(settings);
            }
        }
        catch (Exception e) {
            throw new SearchEngineException("Can't find optimizer class [" + optimizerClassSetting + "]", e);
        }
        this.searchEngineOptimizer.setSearchEngineFactory(this);
    }

    public String getAliasProperty() {
        return this.luceneSettings.getAliasProperty();
    }

    public String getExtendedAliasProperty() {
        return this.luceneSettings.getExtendedAliasProperty();
    }

    public String getAllProperty() {
        return this.luceneSettings.getAllProperty();
    }

    public CompassMapping getMapping() {
        return this.mapping;
    }

    public PropertyNamingStrategy getPropertyNamingStrategy() {
        return this.propertyNamingStrategy;
    }

    public SearchEngineOptimizer getOptimizer() {
        return this.searchEngineOptimizer;
    }

    public void setOptimizer(LuceneSearchEngineOptimizer searchEngineOptimizer) {
        this.searchEngineOptimizer = searchEngineOptimizer;
    }

    public SearchEngineIndexManager getIndexManager() {
        return this.indexManager;
    }

    public void setIndexManager(LuceneSearchEngineIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public LuceneSearchEngineIndexManager getLuceneIndexManager() {
        return this.indexManager;
    }

    public LuceneSettings getLuceneSettings() {
        return this.luceneSettings;
    }

    public CompassSettings getSettings() {
        return this.settings;
    }

    public LuceneAnalyzerManager getAnalyzerManager() {
        return this.analyzerManager;
    }

    public SearchEngineEventManager getEventManager() {
        return this.eventManager;
    }

    public LuceneHighlighterManager getHighlighterManager() throws SearchEngineException {
        if (this.highlighterManager == null) {
            throw new SearchEngineException("Trying to use highlighter, but no highlighter jar included");
        }
        return this.highlighterManager;
    }

    public LuceneQueryParserManager getQueryParserManager() {
        return this.queryParserManager;
    }

    public IndexDeletionPolicyFactory getIndexDeletionPolicyManager() {
        return this.indexDeletionPolicyManager;
    }

    static {
        System.setProperty("org.apache.lucene.SegmentReader.class", "org.apache.lucene.index.CompassSegmentReader");
        log = LogFactory.getLog((Class)LuceneSearchEngineFactory.class);
    }
}

