/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.analyzer;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.analyzer.AnalyzerBuilderDelegate;
import org.compass.core.lucene.engine.analyzer.DefaultLuceneAnalyzerFactory;

public class CoreAnalyzerBuilderDelegate
implements AnalyzerBuilderDelegate {
    public Analyzer buildAnalyzer(String analyzerName, CompassSettings settings, DefaultLuceneAnalyzerFactory analyzerFactory) throws SearchEngineException {
        String analyzerSetting = settings.getSetting("type", "standard");
        WhitespaceAnalyzer analyzer = null;
        if ("whitespace".equalsIgnoreCase(analyzerSetting)) {
            analyzer = new WhitespaceAnalyzer();
        } else if ("standard".equalsIgnoreCase(analyzerSetting)) {
            analyzer = new StandardAnalyzer(analyzerFactory.parseStopWords(analyzerName, settings, StandardAnalyzer.STOP_WORDS));
        } else if ("simple".equalsIgnoreCase(analyzerSetting)) {
            analyzer = new SimpleAnalyzer();
        } else if ("stop".equalsIgnoreCase(analyzerSetting)) {
            analyzer = new StopAnalyzer(analyzerFactory.parseStopWords(analyzerName, settings, StopAnalyzer.ENGLISH_STOP_WORDS));
        }
        return analyzer;
    }
}

