/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.analyzer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.compass.core.Resource;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.LuceneSettings;
import org.compass.core.lucene.engine.analyzer.DefaultLuceneAnalyzerFactory;
import org.compass.core.lucene.engine.analyzer.LuceneAnalyzerFactory;
import org.compass.core.lucene.engine.analyzer.LuceneAnalyzerFilterWrapper;
import org.compass.core.lucene.engine.analyzer.LuceneAnalyzerTokenFilterProvider;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourceAnalyzerController;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.StringUtils;

public class LuceneAnalyzerManager {
    private static final Log log = LogFactory.getLog((Class)LuceneAnalyzerManager.class);
    private HashMap analyzers = new HashMap();
    private Analyzer defaultAnalyzer;
    private Analyzer searchAnalyzer;
    private HashMap aliasAnalyzers = new HashMap();
    private HashMap analyzersFilters = new HashMap();
    private CompassMapping mapping;
    private LuceneSettings luceneSettings;
    static /* synthetic */ Class class$org$compass$core$lucene$engine$analyzer$synonym$SynonymAnalyzerTokenFilterProvider;

    public void configure(CompassSettings settings, CompassMapping mapping, LuceneSettings luceneSettings) throws SearchEngineException {
        this.checkNotUsingOldVersionsAnalyzerSettings(settings);
        this.mapping = mapping;
        this.luceneSettings = luceneSettings;
        this.buildAnalyzersFilters(settings);
        this.buildAnalyzers(settings, mapping);
    }

    private void buildAnalyzersFilters(CompassSettings settings) {
        Map analyzerFilterSettingGroups = settings.getSettingGroups("compass.engine.analyzerfilter");
        Iterator it = analyzerFilterSettingGroups.keySet().iterator();
        while (it.hasNext()) {
            CompassSettings analyzerFilterSettings;
            String analyzerFilterType;
            String analyzerFilterName = (String)it.next();
            if (log.isInfoEnabled()) {
                log.info((Object)("Building analyzer filter [" + analyzerFilterName + "]"));
            }
            if ((analyzerFilterType = (analyzerFilterSettings = (CompassSettings)analyzerFilterSettingGroups.get(analyzerFilterName)).getSetting("type")) == null) {
                throw new SearchEngineException("Failed to locate analyzer filter [" + analyzerFilterName + "] type, it must be set");
            }
            try {
                if (analyzerFilterType.equals("synonym")) {
                    analyzerFilterType = (class$org$compass$core$lucene$engine$analyzer$synonym$SynonymAnalyzerTokenFilterProvider == null ? LuceneAnalyzerManager.class$("org.compass.core.lucene.engine.analyzer.synonym.SynonymAnalyzerTokenFilterProvider") : class$org$compass$core$lucene$engine$analyzer$synonym$SynonymAnalyzerTokenFilterProvider).getName();
                }
                LuceneAnalyzerTokenFilterProvider provider = (LuceneAnalyzerTokenFilterProvider)ClassUtils.forName(analyzerFilterType).newInstance();
                provider.configure(analyzerFilterSettings);
                this.analyzersFilters.put(analyzerFilterName, provider);
            }
            catch (Exception e) {
                throw new SearchEngineException("Failed to create analyzer filter [" + analyzerFilterName + "]", e);
            }
        }
    }

    private void buildAnalyzers(CompassSettings settings, CompassMapping mapping) {
        Map analyzerSettingGroups = settings.getSettingGroups("compass.engine.analyzer");
        Iterator it = analyzerSettingGroups.keySet().iterator();
        while (it.hasNext()) {
            String analyzerName = (String)it.next();
            if (log.isInfoEnabled()) {
                log.info((Object)("Building analyzer [" + analyzerName + "]"));
            }
            Analyzer analyzer = this.buildAnalyzer(analyzerName, (CompassSettings)analyzerSettingGroups.get(analyzerName));
            this.analyzers.put(analyzerName, analyzer);
        }
        this.defaultAnalyzer = (Analyzer)this.analyzers.get("default");
        if (this.defaultAnalyzer == null) {
            this.defaultAnalyzer = this.buildAnalyzer("default", new CompassSettings());
            this.analyzers.put("default", this.defaultAnalyzer);
        }
        this.searchAnalyzer = (Analyzer)this.analyzers.get("search");
        if (this.searchAnalyzer == null) {
            this.searchAnalyzer = this.defaultAnalyzer;
        }
        this.buildAnalyzerPerAlias(mapping);
    }

    private void buildAnalyzerPerAlias(CompassMapping mapping) throws SearchEngineException {
        ResourceMapping[] resourceMappings = mapping.getRootMappings();
        for (int i = 0; i < resourceMappings.length; ++i) {
            ResourceMapping resourceMapping = resourceMappings[i];
            String alias = resourceMapping.getAlias();
            String resourceAnalyzerName = "default";
            if (resourceMapping.getAnalyzer() != null) {
                resourceAnalyzerName = resourceMapping.getAnalyzer();
            }
            Analyzer resourceAnalyzer = this.buildAnalyzerPerResourcePropertyIfNeeded(resourceMapping, resourceAnalyzerName);
            this.aliasAnalyzers.put(alias, resourceAnalyzer);
        }
    }

    public Analyzer getDefaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    public Analyzer getSearchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Analyzer getAnalyzer(String analyzerName) {
        return (Analyzer)this.analyzers.get(analyzerName);
    }

    public Analyzer getAnalyzerByAlias(String alias) {
        return (Analyzer)this.aliasAnalyzers.get(alias);
    }

    public Analyzer getAnalyzerByAliasMustExists(String alias) throws SearchEngineException {
        Analyzer analyzer = (Analyzer)this.aliasAnalyzers.get(alias);
        if (analyzer == null) {
            throw new SearchEngineException("No analyzer is defined for alias [" + alias + "]");
        }
        return analyzer;
    }

    public Analyzer getAnalyzerByResource(Resource resource) throws SearchEngineException {
        String alias = resource.getAlias();
        ResourceMapping resourceMapping = this.mapping.getRootMappingByAlias(alias);
        if (resourceMapping.getAnalyzerController() == null) {
            return (Analyzer)this.aliasAnalyzers.get(alias);
        }
        ResourceAnalyzerController analyzerController = resourceMapping.getAnalyzerController();
        String analyzerPropertyName = analyzerController.getAnalyzerResourcePropertyName();
        String analyzerName = resource.get(analyzerPropertyName);
        if (analyzerName == null) {
            analyzerName = analyzerController.getNullAnalyzer();
        }
        return this.buildAnalyzerPerResourcePropertyIfNeeded(resourceMapping, analyzerName);
    }

    public Analyzer getAnalyzerMustExist(String analyzerName) throws SearchEngineException {
        Analyzer analyzer = (Analyzer)this.analyzers.get(analyzerName);
        if (analyzer == null) {
            throw new SearchEngineException("No analyzer is defined for analyzer name [" + analyzerName + "]");
        }
        return analyzer;
    }

    private Analyzer buildAnalyzer(String analyzerName, CompassSettings settings) {
        LuceneAnalyzerFactory analyzerFactory;
        String analyzerFactorySetting = settings.getSetting("factory", DefaultLuceneAnalyzerFactory.class.getName());
        try {
            analyzerFactory = (LuceneAnalyzerFactory)ClassUtils.forName(analyzerFactorySetting).newInstance();
        }
        catch (Exception e) {
            throw new SearchEngineException("Cannot create Analyzer factory [" + analyzerFactorySetting + "]. Please verify the analyzer factory setting at [" + "factory" + "]", e);
        }
        Analyzer analyzer = analyzerFactory.createAnalyzer(analyzerName, settings);
        String filters = settings.getSetting("filters");
        if (filters != null) {
            StringTokenizer tokenizer = new StringTokenizer(filters, ",");
            ArrayList<LuceneAnalyzerTokenFilterProvider> filterProviders = new ArrayList<LuceneAnalyzerTokenFilterProvider>();
            while (tokenizer.hasMoreTokens()) {
                String filterProviderLookupName = tokenizer.nextToken();
                if (!StringUtils.hasText(filterProviderLookupName)) continue;
                LuceneAnalyzerTokenFilterProvider provider = (LuceneAnalyzerTokenFilterProvider)this.analyzersFilters.get(filterProviderLookupName);
                if (provider == null) {
                    throw new SearchEngineException("Failed to located filter provider [" + filterProviderLookupName + "] for analyzer [" + analyzerName + "]");
                }
                filterProviders.add(provider);
            }
            analyzer = new LuceneAnalyzerFilterWrapper(analyzer, filterProviders.toArray(new LuceneAnalyzerTokenFilterProvider[filterProviders.size()]));
        }
        return analyzer;
    }

    private Analyzer buildAnalyzerPerResourcePropertyIfNeeded(ResourceMapping resourceMapping, String resourceAnalyzerName) {
        Analyzer resourceAnalyzer = this.getAnalyzerMustExist(resourceAnalyzerName);
        if (resourceMapping.hasSpecificAnalyzerPerResourceProperty() || resourceMapping.getAllAnalyzer() != null && !resourceAnalyzerName.equals(resourceMapping.getAllAnalyzer())) {
            PerFieldAnalyzerWrapper perFieldAnalyzerWrapper = new PerFieldAnalyzerWrapper(resourceAnalyzer);
            ResourcePropertyMapping[] propertyMappings = resourceMapping.getResourcePropertyMappings();
            for (int j = 0; j < propertyMappings.length; ++j) {
                ResourcePropertyMapping propertyMapping = propertyMappings[j];
                if (propertyMapping.getAnalyzer() == null) continue;
                Analyzer propertyAnalyzer = this.getAnalyzer(propertyMapping.getAnalyzer());
                if (propertyAnalyzer == null) {
                    throw new SearchEngineException("Failed to find analyzer [" + propertyMapping.getAnalyzer() + "] for alias [" + resourceMapping.getAlias() + "] and property [" + propertyMapping.getName() + "]");
                }
                perFieldAnalyzerWrapper.addAnalyzer(propertyMapping.getPath().getPath(), propertyAnalyzer);
            }
            if (resourceMapping.isAllSupported()) {
                String allP = resourceMapping.getAllProperty();
                if (allP == null) {
                    allP = this.luceneSettings.getAllProperty();
                }
                Analyzer allAnalyzer = this.getAnalyzer(resourceMapping.getAllAnalyzer());
                perFieldAnalyzerWrapper.addAnalyzer(allP, allAnalyzer);
            }
            return perFieldAnalyzerWrapper;
        }
        return resourceAnalyzer;
    }

    private void checkNotUsingOldVersionsAnalyzerSettings(CompassSettings settings) throws SearchEngineException {
        if (settings.getSetting("compass.engine.analyzer.factory") != null) {
            throw new ConfigurationException("Old analyzer setting for analyzer factory, use [compass.engine.analyzer.default.*] instead");
        }
        if (settings.getSetting("compass.engine.analyzer") != null) {
            throw new ConfigurationException("Old analyzer setting for analyzer, use [compass.engine.analyzer.default.*] instead");
        }
        if (settings.getSetting("compass.engine.analyzer.stopwords") != null) {
            throw new ConfigurationException("Old analyzer setting for stopwords, use [compass.engine.analyzer.default.*] instead");
        }
    }
}

