/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.indexdeletionpolicy;

import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.store.Directory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.indexdeletionpolicy.DirectoryConfigurable;
import org.compass.core.lucene.engine.indexdeletionpolicy.ExpirationTimeDeletionPolicy;
import org.compass.core.lucene.engine.indexdeletionpolicy.KeepAllDeletionPolicy;
import org.compass.core.lucene.engine.indexdeletionpolicy.KeepLastNDeletionPolicy;
import org.compass.core.lucene.engine.indexdeletionpolicy.KeepNoneOnInitDeletionPolicy;
import org.compass.core.util.ClassUtils;

public class IndexDeletionPolicyFactory
implements CompassConfigurable {
    private CompassSettings settings;
    private String indexDeletionPolicyType;
    private IndexDeletionPolicy globalIndexDeletionPolicy;

    public void configure(CompassSettings settings) throws CompassException {
        this.settings = settings;
        this.indexDeletionPolicyType = settings.getSetting("compass.engine.store.indexDeletionPolicy.type", "keeplastcommit");
        if ("keeplastcommit".equalsIgnoreCase(this.indexDeletionPolicyType)) {
            this.globalIndexDeletionPolicy = new KeepOnlyLastCommitDeletionPolicy();
        } else if ("keeplastn".equalsIgnoreCase(this.indexDeletionPolicyType)) {
            this.globalIndexDeletionPolicy = new KeepLastNDeletionPolicy();
        } else if ("keepall".equalsIgnoreCase(this.indexDeletionPolicyType)) {
            this.globalIndexDeletionPolicy = new KeepAllDeletionPolicy();
        } else if ("keepnoneoninit".equalsIgnoreCase(this.indexDeletionPolicyType)) {
            this.globalIndexDeletionPolicy = new KeepNoneOnInitDeletionPolicy();
        }
        if (this.globalIndexDeletionPolicy != null && this.globalIndexDeletionPolicy instanceof CompassConfigurable) {
            ((CompassConfigurable)this.globalIndexDeletionPolicy).configure(settings);
        }
    }

    public IndexDeletionPolicy createIndexDeletionPolicy(Directory dir) throws SearchEngineException {
        if (this.globalIndexDeletionPolicy != null) {
            return this.globalIndexDeletionPolicy;
        }
        if ("expirationtime".equalsIgnoreCase(this.indexDeletionPolicyType)) {
            ExpirationTimeDeletionPolicy indexDeletionPolicy = new ExpirationTimeDeletionPolicy();
            indexDeletionPolicy.setDirectory(dir);
            indexDeletionPolicy.configure(this.settings);
            return indexDeletionPolicy;
        }
        try {
            IndexDeletionPolicy indexDeletionPolicy = (IndexDeletionPolicy)ClassUtils.forName(this.indexDeletionPolicyType).newInstance();
            if (indexDeletionPolicy instanceof DirectoryConfigurable) {
                ((DirectoryConfigurable)indexDeletionPolicy).setDirectory(dir);
            }
            if (indexDeletionPolicy instanceof CompassConfigurable) {
                ((CompassConfigurable)indexDeletionPolicy).configure(this.settings);
            }
            return indexDeletionPolicy;
        }
        catch (Exception e) {
            throw new SearchEngineException("Failed to create custom index deletion policy [" + this.indexDeletionPolicyType + "]", e);
        }
    }
}

