/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.indexdeletionpolicy;

import java.util.List;
import org.apache.lucene.index.IndexCommitPoint;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;

public class KeepLastNDeletionPolicy
implements IndexDeletionPolicy,
CompassConfigurable {
    private int numToKeep;

    public void configure(CompassSettings settings) throws CompassException {
        this.numToKeep = settings.getSettingAsInt("compass.engine.store.indexDeletionPolicy.numToKeep", 10);
    }

    public void onInit(List commits) {
        this.onCommit(commits);
    }

    public void onCommit(List commits) {
        int size = commits.size();
        for (int i = 0; i < size - this.numToKeep; ++i) {
            ((IndexCommitPoint)commits.get(i)).delete();
        }
    }
}

