/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.queryparser;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.Query;
import org.compass.core.lucene.search.ConstantScorePrefixQuery;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourcePropertyLookup;

public class CompassMultiFieldQueryParser
extends MultiFieldQueryParser {
    private CompassMapping mapping;

    public CompassMultiFieldQueryParser(String[] fields, Analyzer analyzer, CompassMapping mapping) {
        super(fields, analyzer);
        this.mapping = mapping;
    }

    protected Query getFieldQuery(String field, String queryText) throws ParseException {
        if (field == null) {
            return super.getFieldQuery(field, queryText);
        }
        ResourcePropertyLookup lookup = this.mapping.getResourcePropertyLookup(field);
        lookup.setConvertOnlyWithDotPath(false);
        if (lookup.hasSpecificConverter()) {
            queryText = lookup.normalizeString(queryText);
        }
        return super.getFieldQuery(field, queryText);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        if (this.getLowercaseExpandedTerms()) {
            part1 = part1.toLowerCase();
            part2 = part2.toLowerCase();
        }
        ResourcePropertyLookup lookup = this.mapping.getResourcePropertyLookup(field);
        lookup.setConvertOnlyWithDotPath(false);
        if (lookup.hasSpecificConverter()) {
            part1 = "*".equals(part1) ? null : lookup.normalizeString(part1);
            part2 = "*".equals(part2) ? null : lookup.normalizeString(part2);
        } else {
            if ("*".equals(part1)) {
                part1 = null;
            }
            if ("*".equals(part2)) {
                part2 = null;
            }
        }
        return new ConstantScoreRangeQuery(field, part1, part2, inclusive, inclusive);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (this.getLowercaseExpandedTerms()) {
            termStr = termStr.toLowerCase();
        }
        Term t = new Term(field, termStr);
        return new ConstantScorePrefixQuery(t);
    }
}

