/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.queryparser;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassMappingAware;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineQueryParseException;
import org.compass.core.lucene.engine.queryparser.CompassMultiFieldQueryParser;
import org.compass.core.lucene.engine.queryparser.CompassQueryParser;
import org.compass.core.lucene.engine.queryparser.LuceneQueryParser;
import org.compass.core.mapping.CompassMapping;

public class DefaultLuceneQueryParser
implements LuceneQueryParser,
CompassMappingAware,
CompassConfigurable {
    private CompassMapping mapping;
    private boolean allowLeadingWildcard;

    public void configure(CompassSettings settings) throws CompassException {
        this.allowLeadingWildcard = settings.getSettingAsBoolean("allowLeadingWildcard", false);
    }

    public void setCompassMapping(CompassMapping mapping) {
        this.mapping = mapping;
    }

    public Query parse(String property, QueryParser.Operator operator, Analyzer analyzer, String queryString) throws SearchEngineQueryParseException {
        CompassQueryParser queryParser = new CompassQueryParser(property, analyzer, this.mapping);
        queryParser.setDefaultOperator(operator);
        queryParser.setAllowLeadingWildcard(this.allowLeadingWildcard);
        try {
            return queryParser.parse(queryString);
        }
        catch (ParseException e) {
            throw new SearchEngineQueryParseException(queryString, e);
        }
    }

    public Query parse(String[] properties, QueryParser.Operator operator, Analyzer analyzer, String queryString) throws SearchEngineQueryParseException {
        CompassMultiFieldQueryParser queryParser = new CompassMultiFieldQueryParser(properties, analyzer, this.mapping);
        queryParser.setDefaultOperator(operator);
        queryParser.setAllowLeadingWildcard(this.allowLeadingWildcard);
        try {
            return queryParser.parse(queryString);
        }
        catch (ParseException e) {
            throw new SearchEngineQueryParseException(queryString, e);
        }
    }
}

