/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store.localcache;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.store.localcache.LocalDirectoryCache;
import org.compass.core.lucene.util.LuceneUtils;
import org.compass.core.util.backport.java.util.concurrent.Executors;
import org.compass.core.util.backport.java.util.concurrent.ScheduledExecutorService;

public class LocalDirectoryCacheManager
implements CompassConfigurable {
    private static final Log log = LogFactory.getLog((Class)LocalDirectoryCacheManager.class);
    private boolean disableLocalCache = false;
    private Map subIndexLocalCacheGroups;
    private LuceneSearchEngineFactory searchEngineFactory;
    private String subContext;
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);

    public LocalDirectoryCacheManager(LuceneSearchEngineFactory searchEngineFactory) {
        this.searchEngineFactory = searchEngineFactory;
    }

    public LuceneSearchEngineFactory getSearchEngineFactory() {
        return this.searchEngineFactory;
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public void close() {
        this.executorService.shutdown();
    }

    public void configure(CompassSettings settings) throws CompassException {
        this.subContext = settings.getSetting("compass.engine.connection.subContext", "index");
        this.disableLocalCache = settings.getSettingAsBoolean("compass.engine.disableLocalCache", false);
        this.subIndexLocalCacheGroups = settings.getSettingGroups("compass.engine.localCache");
        Iterator it = this.subIndexLocalCacheGroups.keySet().iterator();
        while (it.hasNext()) {
            String subIndexName = (String)it.next();
            CompassSettings subIndexSettings = (CompassSettings)this.subIndexLocalCacheGroups.get(subIndexName);
            String connection = subIndexSettings.getSetting("connection", "ram://");
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Local Cache for [" + subIndexName + "] configured with connection [" + connection + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directory createLocalCache(String subIndex, Directory dir) throws SearchEngineException {
        RAMDirectory localCacheDirectory;
        if (this.disableLocalCache) {
            return dir;
        }
        CompassSettings settings = (CompassSettings)this.subIndexLocalCacheGroups.get(subIndex);
        if (settings == null && (settings = (CompassSettings)this.subIndexLocalCacheGroups.get("__default__")) == null) {
            return dir;
        }
        String connection = settings.getSetting("connection", "ram://");
        if (connection.startsWith("ram://")) {
            localCacheDirectory = new RAMDirectory();
        } else {
            if (connection.startsWith("file://") || connection.startsWith("mmap://")) {
                String path = connection.substring("file://".length(), connection.length()) + "/" + this.subContext + "/" + subIndex;
                File filePath = new File(path);
                LuceneUtils.deleteDir(filePath);
                if (!filePath.exists()) {
                    LocalDirectoryCacheManager localDirectoryCacheManager = this;
                    synchronized (localDirectoryCacheManager) {
                        boolean created = filePath.mkdirs();
                        if (!created) {
                            throw new SearchEngineException("Failed to create directory for local cache with path [" + path + "]");
                        }
                    }
                }
                try {
                    localCacheDirectory = FSDirectory.getDirectory((String)path, (LockFactory)new SingleInstanceLockFactory());
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to create direcotry with path [" + path + "]", e);
                }
            }
            throw new SearchEngineException("Local cache does not supprt the following connection [" + connection + "]");
        }
        return new LocalDirectoryCache(subIndex, dir, (Directory)localCacheDirectory, this);
    }
}

