/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TransIndex;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.store.Directory;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineHits;
import org.compass.core.engine.SearchEngineInternalSearch;
import org.compass.core.engine.utils.ResourceHelper;
import org.compass.core.lucene.engine.DefaultLuceneSearchEngineHits;
import org.compass.core.lucene.engine.EmptyLuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.transaction.AbstractTransaction;
import org.compass.core.lucene.engine.transaction.BitSetByAliasFilter;
import org.compass.core.lucene.util.ChainedFilter;
import org.compass.core.lucene.util.LuceneUtils;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;
import org.compass.core.util.FieldInvoker;
import org.compass.core.util.StringUtils;

public class ReadCommittedTransaction
extends AbstractTransaction {
    private static final Log log = LogFactory.getLog((Class)ReadCommittedTransaction.class);
    private static FieldInvoker indexReaderDirectoryOwner;
    private static FieldInvoker indexReaderHasChanges;
    private BitSetByAliasFilter filter;
    protected TransIndexManager transIndexManager;

    protected void doBegin() throws SearchEngineException {
        this.transIndexManager = new TransIndexManager(this.searchEngine.getSearchEngineFactory());
        this.filter = new BitSetByAliasFilter();
    }

    protected void doPrepare() throws SearchEngineException {
        Iterator it = this.filter.subIndexDeletesIt();
        while (it.hasNext()) {
            String subIndex = (String)it.next();
            BitSetByAliasFilter.IntArray deletes = this.filter.getDeletesBySubIndex(subIndex);
            if (deletes == null) continue;
            try {
                IndexReader indexReader = this.transIndexManager.getTransIndexBySubIndex((String)subIndex).transIndex.getIndexReader();
                indexReaderDirectoryOwner.set(indexReader, Boolean.FALSE);
                for (int j = 0; j < deletes.length; ++j) {
                    indexReader.deleteDocument(deletes.array[j]);
                }
            }
            catch (Exception ex) {
                throw new SearchEngineException("Failed to persist deletes for sub-index [" + subIndex + "]");
            }
        }
        this.transIndexManager.firstPhase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommit(boolean onePhase) throws SearchEngineException {
        try {
            if (onePhase) {
                this.doPrepare();
            }
            this.transIndexManager.secondPhase();
            if (this.searchEngine.getSearchEngineFactory().getLuceneSettings().isClearCacheOnCommit()) {
                Iterator it = this.transIndexManager.transIndexMap.keySet().iterator();
                while (it.hasNext()) {
                    String subIndex = (String)it.next();
                    this.indexManager.clearCache(subIndex);
                }
            }
        }
        finally {
            this.transIndexManager.close();
            this.transIndexManager.clear();
            this.filter.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRollback() throws SearchEngineException {
        Iterator it = this.filter.subIndexDeletesIt();
        while (it.hasNext()) {
            String subIndex = (String)it.next();
            BitSetByAliasFilter.IntArray deletes = this.filter.getDeletesBySubIndex(subIndex);
            if (deletes == null) continue;
            try {
                IndexReader indexReader = this.transIndexManager.getTransIndexBySubIndex((String)subIndex).transIndex.getIndexReader();
                indexReaderHasChanges.set(indexReader, Boolean.FALSE);
            }
            catch (Exception ex) {
                log.warn((Object)"Failed to mark index reader with no changes, ignoring", (Throwable)ex);
            }
        }
        this.filter.clear();
        try {
            this.transIndexManager.rollback();
        }
        finally {
            this.transIndexManager.close();
            this.transIndexManager.clear();
        }
    }

    public void flush() throws SearchEngineException {
    }

    protected void doCreate(InternalResource resource) throws SearchEngineException {
        String subIndex = ResourceHelper.computeSubIndex(resource.resourceKey());
        TransIndexWrapper wrapper = this.transIndexManager.openTransIndexBySubIndex(subIndex);
        try {
            LuceneUtils.applyBoostIfNeeded(resource, this.searchEngine);
            Analyzer analyzer = this.analyzerManager.getAnalyzerByResource(resource);
            wrapper.transIndex.addResource(resource, analyzer);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to create resource for alias [" + resource.getAlias() + "] and resource " + resource, e);
        }
    }

    protected void doDelete(ResourceKey resourceKey) throws SearchEngineException {
        String subIndex = ResourceHelper.computeSubIndex(resourceKey);
        TransIndexWrapper wrapper = this.transIndexManager.openTransIndexBySubIndex(subIndex);
        this.markDelete(wrapper, subIndex, resourceKey, this.filter);
        try {
            wrapper.transIndex.deleteTransResource(resourceKey);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to delete alias [" + resourceKey.getAlias() + "] and ids [" + StringUtils.arrayToCommaDelimitedString(resourceKey.getIds()) + "]", e);
        }
    }

    public Resource[] find(ResourceKey resourceKey) throws SearchEngineException {
        LuceneSearchEngineIndexManager.LuceneIndexHolder indexHolder = null;
        try {
            Searcher indexSearcher;
            String subIndex = ResourceHelper.computeSubIndex(resourceKey);
            TransIndexWrapper wrapper = this.transIndexManager.getTransIndexBySubIndex(subIndex);
            if (wrapper == null) {
                indexHolder = this.indexManager.openIndexHolderBySubIndex(subIndex);
                indexSearcher = indexHolder.getIndexSearcher();
            } else {
                indexSearcher = wrapper.transIndex.getFullIndexSearcher();
            }
            BitSetByAliasFilter qFilter = null;
            if (this.filter.hasDeletes()) {
                qFilter = this.filter;
            }
            Hits hits = this.findByIds(indexSearcher, subIndex, resourceKey, qFilter);
            Resource[] resourceArray = LuceneUtils.hitsToResourceArray(hits, this.searchEngine);
            return resourceArray;
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to find for alias [" + resourceKey.getAlias() + "] and ids [" + StringUtils.arrayToCommaDelimitedString(resourceKey.getIds()) + "]", e);
        }
        finally {
            if (indexHolder != null) {
                indexHolder.release();
            }
        }
    }

    protected SearchEngineInternalSearch doInternalSearch(String[] subIndexes, String[] aliases) throws SearchEngineException {
        ArrayList<LuceneSearchEngineIndexManager.LuceneIndexHolder> indexHolders = new ArrayList<LuceneSearchEngineIndexManager.LuceneIndexHolder>();
        try {
            String[] calcSubIndexes = this.indexManager.getStore().calcSubIndexes(subIndexes, aliases);
            ArrayList<Object> searchers = new ArrayList<Object>();
            for (int i = 0; i < calcSubIndexes.length; ++i) {
                String subIndex = calcSubIndexes[i];
                TransIndexWrapper wrapper = this.transIndexManager.getTransIndexBySubIndex(subIndex);
                if (wrapper == null) {
                    LuceneSearchEngineIndexManager.LuceneIndexHolder indexHolder = this.indexManager.openIndexHolderBySubIndex(subIndex);
                    indexHolders.add(indexHolder);
                    if (indexHolder.getIndexReader().numDocs() <= 0) continue;
                    searchers.add(indexHolder.getIndexSearcher());
                    continue;
                }
                Searcher[] transSearchers = wrapper.transIndex.getFullIndexSearcherAsArray();
                for (int j = 0; j < transSearchers.length; ++j) {
                    searchers.add(transSearchers[j]);
                }
            }
            if (searchers.size() == 0) {
                return new LuceneSearchEngineInternalSearch(null, null);
            }
            MultiSearcher indexSeracher = new MultiSearcher((Searchable[])searchers.toArray(new Searcher[searchers.size()]));
            return new LuceneSearchEngineInternalSearch(indexSeracher, indexHolders);
        }
        catch (IOException e) {
            Iterator it = indexHolders.iterator();
            while (it.hasNext()) {
                LuceneSearchEngineIndexManager.LuceneIndexHolder indexHolder = (LuceneSearchEngineIndexManager.LuceneIndexHolder)it.next();
                indexHolder.release();
            }
            throw new SearchEngineException("Failed to open Lucene reader/searcher", e);
        }
    }

    protected SearchEngineHits doFind(LuceneSearchEngineQuery query) throws SearchEngineException {
        LuceneSearchEngineInternalSearch internalSearch = (LuceneSearchEngineInternalSearch)this.internalSearch(query.getSubIndexes(), query.getAliases());
        if (internalSearch.isEmpty()) {
            return new EmptyLuceneSearchEngineHits();
        }
        Filter qFilter = null;
        if (this.filter.hasDeletes()) {
            qFilter = query.getFilter() == null ? this.filter : new ChainedFilter(new Filter[]{this.filter, query.getFilter().getFilter()}, ChainedFilter.ChainedFilterType.AND);
        } else if (query.getFilter() != null) {
            qFilter = query.getFilter().getFilter();
        }
        Hits hits = this.findByQuery(internalSearch.getSearcher(), query, qFilter);
        return new DefaultLuceneSearchEngineHits(hits, this.searchEngine, query, internalSearch);
    }

    private Hits findByIds(Searcher indexSearcher, String subIndex, ResourceKey resourceKey, Filter filter) throws SearchEngineException {
        Object[] ids = resourceKey.getIds();
        Query query = LuceneUtils.buildResourceLoadQuery(this.searchEngine.getSearchEngineFactory(), subIndex, resourceKey);
        try {
            if (filter == null) {
                return indexSearcher.search(query);
            }
            return indexSearcher.search(query, filter);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to search for alias [" + resourceKey.getAlias() + "] and properties [" + StringUtils.arrayToCommaDelimitedString(ids) + "]", e);
        }
    }

    private Hits findByQuery(Searcher indexSearcher, LuceneSearchEngineQuery searchEngineQuery, Filter filter) throws SearchEngineException {
        Hits hits;
        Query query = searchEngineQuery.getQuery();
        Sort sort = searchEngineQuery.getSort();
        try {
            hits = filter == null ? indexSearcher.search(query, sort) : indexSearcher.search(query, filter, sort);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to search with query [" + query + "]", e);
        }
        return hits;
    }

    private void markDelete(TransIndexWrapper wrapper, String subIndex, ResourceKey resourceKey, BitSetByAliasFilter filter) throws SearchEngineException {
        block18: {
            Property[] ids = resourceKey.getIds();
            try {
                boolean moreThanOneAliasPerSubIndex;
                boolean bl = moreThanOneAliasPerSubIndex = this.indexManager.getStore().getNumberOfAliasesBySubIndex(subIndex) > 1;
                if (ids.length == 1 && !moreThanOneAliasPerSubIndex) {
                    Property id = ids[0];
                    Term t = new Term(id.getName(), id.getStringValue());
                    TermDocs termDocs = null;
                    try {
                        termDocs = wrapper.transIndex.getIndexReader().termDocs(t);
                        if (termDocs == null) break block18;
                        int maxDoc = wrapper.transIndex.getIndexReader().maxDoc();
                        try {
                            while (termDocs.next()) {
                                filter.markDeleteBySubIndex(subIndex, termDocs.doc(), maxDoc);
                            }
                            break block18;
                        }
                        catch (IOException e) {
                            throw new SearchEngineException("Failed to iterate data in order to delete", e);
                        }
                    }
                    catch (IOException e) {
                        throw new SearchEngineException("Failed to search for property [" + id + "]", e);
                    }
                    finally {
                        try {
                            if (termDocs != null) {
                                termDocs.close();
                            }
                        }
                        catch (IOException e) {}
                    }
                }
                Hits hits = this.findByIds(wrapper.transIndex.getIndexSearcher(), subIndex, resourceKey, null);
                if (hits.length() != 0) {
                    int maxDoc = wrapper.transIndex.getIndexSearcher().maxDoc();
                    for (int i = 0; i < hits.length(); ++i) {
                        int docNum = hits.id(i);
                        filter.markDeleteBySubIndex(subIndex, docNum, maxDoc);
                    }
                }
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to delete", e);
            }
        }
    }

    static {
        try {
            indexReaderDirectoryOwner = new FieldInvoker(IndexReader.class, "directoryOwner").prepare();
            indexReaderHasChanges = new FieldInvoker(IndexReader.class, "hasChanges").prepare();
        }
        catch (Exception e) {
            log.error((Object)"Failed to read index reader properties", (Throwable)e);
        }
    }

    public class TransIndexManager {
        private HashMap transIndexMap = new HashMap();
        private ArrayList transIndexList = new ArrayList();
        private LuceneSearchEngineIndexManager indexManager;

        public TransIndexManager(LuceneSearchEngineFactory searchEngineFactory) {
            this.indexManager = searchEngineFactory.getLuceneIndexManager();
        }

        public TransIndexWrapper getTransIndexBySubIndex(String subIndex) {
            return (TransIndexWrapper)this.transIndexMap.get(subIndex);
        }

        public TransIndexWrapper openTransIndexBySubIndex(String subIndex) throws SearchEngineException {
            TransIndexWrapper wrapper = (TransIndexWrapper)this.transIndexMap.get(subIndex);
            if (wrapper == null) {
                wrapper = new TransIndexWrapper();
                wrapper.subIndex = subIndex;
                try {
                    wrapper.dir = this.indexManager.getStore().getDirectoryBySubIndex(subIndex, false);
                    wrapper.transIndex = new TransIndex(subIndex, wrapper.dir, ReadCommittedTransaction.this.searchEngine);
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to open index for sub-index [" + subIndex + "]", e);
                }
                this.transIndexMap.put(subIndex, wrapper);
                this.transIndexList.add(wrapper);
            }
            return wrapper;
        }

        public void firstPhase() throws SearchEngineException {
            for (int i = 0; i < this.transIndexList.size(); ++i) {
                TransIndexWrapper wrapper = (TransIndexWrapper)this.transIndexList.get(i);
                try {
                    wrapper.transIndex.firstPhase();
                    continue;
                }
                catch (IOException ex) {
                    throw new SearchEngineException("Failed in first phase commit from sub-index [" + wrapper.subIndex + "]", ex);
                }
            }
        }

        public void secondPhase() throws SearchEngineException {
            for (int i = 0; i < this.transIndexList.size(); ++i) {
                TransIndexWrapper wrapper = (TransIndexWrapper)this.transIndexList.get(i);
                try {
                    wrapper.transIndex.secondPhase();
                    continue;
                }
                catch (IOException ex) {
                    throw new SearchEngineException("Failed in second phase commit from sub-index [" + wrapper.subIndex + "]", ex);
                }
            }
        }

        public void rollback() throws SearchEngineException {
            IOException e = null;
            Iterator it = this.transIndexList.iterator();
            while (it.hasNext()) {
                TransIndexWrapper wrapper = (TransIndexWrapper)it.next();
                try {
                    wrapper.transIndex.rollback();
                }
                catch (IOException ex) {
                    e = ex;
                }
            }
            if (e != null) {
                throw new SearchEngineException("Failed to rollback", e);
            }
        }

        public void close() throws SearchEngineException {
            Exception e = null;
            for (int i = 0; i < this.transIndexList.size(); ++i) {
                TransIndexWrapper wrapper = (TransIndexWrapper)this.transIndexList.get(i);
                try {
                    wrapper.transIndex.close();
                }
                catch (IOException ex) {
                    e = ex;
                }
                try {
                    this.indexManager.getStore().closeDirectory(wrapper.subIndex, wrapper.dir);
                    continue;
                }
                catch (Exception ex) {
                    e = ex;
                }
            }
            if (e != null) {
                if (e instanceof SearchEngineException) {
                    throw (SearchEngineException)e;
                }
                throw new SearchEngineException("Failed to close index writers", e);
            }
        }

        public void clear() {
            this.transIndexList.clear();
            this.transIndexMap.clear();
        }
    }

    public static class TransIndexWrapper {
        public String subIndex;
        public TransIndex transIndex;
        public Directory dir;
    }
}

