/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Lock;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.engine.RepeatableReader;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.engine.utils.ResourceHelper;
import org.compass.core.lucene.LuceneProperty;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSettings;
import org.compass.core.mapping.BoostPropertyMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;
import org.compass.core.util.reader.MultiIOReader;
import org.compass.core.util.reader.StringReader;
import org.compass.core.util.reader.StringWithSeparatorReader;

public abstract class LuceneUtils {
    public static Query buildResourceLoadQuery(LuceneSearchEngineFactory searchEngineFactory, ResourceKey resourceKey) {
        return LuceneUtils.buildResourceLoadQuery(searchEngineFactory, ResourceHelper.computeSubIndex(resourceKey), resourceKey);
    }

    public static Query buildResourceLoadQuery(LuceneSearchEngineFactory searchEngineFactory, String subIndex, ResourceKey resourceKey) {
        BooleanQuery query;
        Property[] ids = resourceKey.getIds();
        int numberOfAliases = searchEngineFactory.getLuceneIndexManager().getStore().getNumberOfAliasesBySubIndex(subIndex);
        if (numberOfAliases == 1 && ids.length == 1) {
            query = new TermQuery(new Term(ids[0].getName(), ids[0].getStringValue()));
        } else {
            Term t;
            BooleanQuery bQuery = new BooleanQuery();
            if (numberOfAliases > 1) {
                String aliasProperty = searchEngineFactory.getLuceneSettings().getAliasProperty();
                t = new Term(aliasProperty, resourceKey.getAlias());
                bQuery.add((Query)new TermQuery(t), BooleanClause.Occur.MUST);
            }
            for (int i = 0; i < ids.length; ++i) {
                t = new Term(ids[i].getName(), ids[i].getStringValue());
                bQuery.add((Query)new TermQuery(t), BooleanClause.Occur.MUST);
            }
            query = bQuery;
        }
        return query;
    }

    public static Resource[] hitsToResourceArray(Hits hits, LuceneSearchEngine searchEngine) throws SearchEngineException {
        int length = hits.length();
        Resource[] result = new Resource[length];
        for (int i = 0; i < length; ++i) {
            try {
                result[i] = new LuceneResource(hits.doc(i), hits.id(i), searchEngine);
                continue;
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to fetch document from hits.", e);
            }
        }
        return result;
    }

    public static void applyBoostIfNeeded(InternalResource resource, SearchEngine searchEngine) {
        BoostPropertyMapping boostPropertyMapping = resource.resourceKey().getResourceMapping().getBoostPropertyMapping();
        if (boostPropertyMapping == null) {
            return;
        }
        float boostValue = boostPropertyMapping.getDefaultBoost();
        String boostPropertyName = boostPropertyMapping.getBoostResourcePropertyName();
        String sBoostValue = resource.get(boostPropertyName);
        if (!searchEngine.isNullValue(sBoostValue)) {
            boostValue = Float.parseFloat(sBoostValue);
        }
        resource.setBoost(boostValue);
    }

    public static void createResource(IndexWriter indexWriter, Resource resource, Analyzer analyzer) throws SearchEngineException {
        Document document = ((LuceneResource)resource).getDocument();
        try {
            indexWriter.addDocument(document, analyzer);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to create resource " + resource, e);
        }
    }

    public static void addExtendedProeprty(Resource resource, ResourceMapping resourceMapping, LuceneSearchEngine searchEngine) {
        String extendedAliasProperty = searchEngine.getSearchEngineFactory().getExtendedAliasProperty();
        resource.removeProperties(extendedAliasProperty);
        for (int i = 0; i < resourceMapping.getExtendedAliases().length; ++i) {
            LuceneProperty extendedAliasProp = (LuceneProperty)searchEngine.createProperty(extendedAliasProperty, resourceMapping.getExtendedAliases()[i], Property.Store.NO, Property.Index.UN_TOKENIZED);
            extendedAliasProp.getField().setOmitNorms(true);
            resource.addProperty(extendedAliasProp);
        }
    }

    public static void addAllPropertyIfNeeded(Resource resource, ResourceMapping resourceMapping, LuceneSearchEngine searchEngine) throws SearchEngineException {
        if (resourceMapping.isAllSupported()) {
            LuceneSettings luceneSettings = searchEngine.getSearchEngineFactory().getLuceneSettings();
            PropertyNamingStrategy propertyNamingStrategy = searchEngine.getSearchEngineFactory().getPropertyNamingStrategy();
            MultiIOReader reader = new MultiIOReader();
            Property[] properties = resource.getProperties();
            boolean atleastOneAddedToAll = false;
            for (int i = 0; i < properties.length; ++i) {
                LuceneProperty property = (LuceneProperty)properties[i];
                ResourcePropertyMapping resourcePropertyMapping = property.getPropertyMapping();
                if (resourcePropertyMapping == null) {
                    resourcePropertyMapping = resourceMapping.getResourcePropertyMapping(property.getName());
                }
                if (resourcePropertyMapping == null) {
                    if (propertyNamingStrategy.isInternal(property.getName()) || !resourceMapping.isIncludePropertiesWithNoMappingsInAll()) continue;
                    atleastOneAddedToAll = LuceneUtils.tryAddPropertyToAll(property, reader, atleastOneAddedToAll);
                    continue;
                }
                if (resourcePropertyMapping.isExcludeFromAll() || resourcePropertyMapping.isInternal()) continue;
                atleastOneAddedToAll = LuceneUtils.tryAddPropertyToAll(property, reader, atleastOneAddedToAll);
            }
            if (atleastOneAddedToAll) {
                Property.TermVector allTermVector;
                String allP = resourceMapping.getAllProperty();
                if (allP == null) {
                    allP = luceneSettings.getAllProperty();
                }
                if ((allTermVector = resourceMapping.getAllTermVector()) == null) {
                    allTermVector = luceneSettings.getAllPropertyTermVector();
                }
                resource.addProperty(searchEngine.createProperty(allP, reader, allTermVector));
            }
        }
    }

    private static boolean tryAddPropertyToAll(Property property, MultiIOReader reader, boolean atleastOneAddedToAll) {
        String value = property.getStringValue();
        if (value != null) {
            reader.add(property.getName(), new StringWithSeparatorReader(value, ' '));
            return true;
        }
        RepeatableReader repeatableReader = ((LuceneProperty)property).getRepeatableReader();
        if (repeatableReader != null) {
            reader.add(property.getName(), (Reader)((Object)repeatableReader));
            reader.add(new StringReader(" "));
            return true;
        }
        return atleastOneAddedToAll;
    }

    public static List findPropertyValues(IndexReader indexReader, String propertyName) throws SearchEngineException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            TermEnum te = indexReader.terms(new Term(propertyName, ""));
            while (propertyName.equals(te.term().field())) {
                String value = te.term().text();
                list.add(value);
                if (te.next()) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to read property values for property [" + propertyName + "]");
        }
        return list;
    }

    public static Field.Index getFieldIndex(Property.Index index) throws SearchEngineException {
        if (index == Property.Index.TOKENIZED) {
            return Field.Index.TOKENIZED;
        }
        if (index == Property.Index.UN_TOKENIZED) {
            return Field.Index.UN_TOKENIZED;
        }
        if (index == Property.Index.NO) {
            return Field.Index.NO;
        }
        throw new SearchEngineException("No index type is defined for [" + index + "]");
    }

    public static Field.Store getFieldStore(Property.Store store) throws SearchEngineException {
        if (store == Property.Store.YES) {
            return Field.Store.YES;
        }
        if (store == Property.Store.NO) {
            return Field.Store.NO;
        }
        if (store == Property.Store.COMPRESS) {
            return Field.Store.COMPRESS;
        }
        throw new SearchEngineException("No store type is defined for [" + store + "]");
    }

    public static Field.TermVector getFieldTermVector(Property.TermVector termVector) throws SearchEngineException {
        if (termVector == Property.TermVector.NO) {
            return Field.TermVector.NO;
        }
        if (termVector == Property.TermVector.YES) {
            return Field.TermVector.YES;
        }
        if (termVector == Property.TermVector.WITH_OFFSETS) {
            return Field.TermVector.WITH_OFFSETS;
        }
        if (termVector == Property.TermVector.WITH_POSITIONS) {
            return Field.TermVector.WITH_POSITIONS;
        }
        if (termVector == Property.TermVector.WITH_POSITIONS_OFFSETS) {
            return Field.TermVector.WITH_POSITIONS_OFFSETS;
        }
        throw new SearchEngineException("No term vector type is defined for [" + termVector + "]");
    }

    public static boolean deleteDir(File dir) {
        boolean globalSuccess = true;
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = LuceneUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                globalSuccess = false;
            }
        }
        if (!dir.delete()) {
            globalSuccess = false;
        }
        return globalSuccess;
    }

    public static void clearLocks(Lock[] locks) {
        if (locks == null) {
            return;
        }
        for (int i = 0; i < locks.length; ++i) {
            if (locks[i] == null) continue;
            locks[i].release();
        }
    }
}

