/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyPath;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.NullResourceMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyLookup;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.rsem.RawResourceMapping;

public class CompassMapping {
    private final HashMap mappings = new HashMap();
    private final HashMap rootMappingsByAlias = new HashMap();
    private final HashMap nonRootMappingsByAlias = new HashMap();
    private final ResourceMappingsByNameHolder mappingsByClass = new ResourceMappingsByNameHolder();
    private final ResourceMappingsByNameHolder cachedMappingsByClass = new ResourceMappingsByNameHolder();
    private final ResourceMappingsByNameHolder rootMappingsByClass = new ResourceMappingsByNameHolder();
    private final ResourceMappingsByNameHolder cachedRootMappingsByClass = new ResourceMappingsByNameHolder();
    private final ResourceMappingsByNameHolder nonRootMappingsByClass = new ResourceMappingsByNameHolder();
    private final ResourceMappingsByNameHolder cachedNonRootMappingsByClass = new ResourceMappingsByNameHolder();
    private ResourceMapping[] rootMappingsArr = new ResourceMapping[0];
    private ConverterLookup converterLookup;
    private final NullResourceMapping nullResourceMappingEntryInCache = new NullResourceMapping();
    private final HashMap resourcePropertyMappingByPath = new HashMap();
    private PropertyPath path;

    public CompassMapping copy(ConverterLookup converterLookup) {
        CompassMapping copy = new CompassMapping();
        copy.converterLookup = converterLookup;
        copy.setPath(this.getPath());
        Iterator it = this.mappings.values().iterator();
        while (it.hasNext()) {
            AliasMapping copyMapping = (AliasMapping)((AliasMapping)it.next()).copy();
            copy.addMapping(copyMapping);
        }
        return copy;
    }

    public void postProcess() {
        ResourceMapping[] rootMappings = this.getRootMappings();
        for (int i = 0; i < rootMappings.length; ++i) {
            ResourcePropertyMapping[] resourcePropertyMappings = rootMappings[i].getResourcePropertyMappings();
            for (int j = 0; j < resourcePropertyMappings.length; ++j) {
                ResourcePropertyMapping rpm = resourcePropertyMappings[j];
                if (rpm.getPath() == null) continue;
                String path = rpm.getPath().getPath();
                ResourcePropertyMapping[] rpms = (ResourcePropertyMapping[])this.resourcePropertyMappingByPath.get(path);
                if (rpms == null) {
                    this.resourcePropertyMappingByPath.put(path, new ResourcePropertyMapping[]{rpm});
                    continue;
                }
                ResourcePropertyMapping[] tmpRpms = new ResourcePropertyMapping[rpms.length + 1];
                System.arraycopy(rpms, 0, tmpRpms, 0, rpms.length);
                tmpRpms[tmpRpms.length - 1] = rpm;
                this.resourcePropertyMappingByPath.put(path, tmpRpms);
            }
        }
    }

    public void clearMappings() {
        this.mappings.clear();
        this.rootMappingsByAlias.clear();
        this.rootMappingsByClass.clear();
        this.rootMappingsArr = new ResourceMapping[0];
        this.cachedRootMappingsByClass.clear();
        this.mappingsByClass.clear();
        this.resourcePropertyMappingByPath.clear();
    }

    public void addMapping(AliasMapping mapping) throws MappingException {
        if (this.mappings.get(mapping.getAlias()) != null) {
            throw new MappingException("Compass does not allow multiple aliases for alias [" + mapping.getAlias() + "]");
        }
        this.mappings.put(mapping.getAlias(), mapping);
        if (mapping instanceof ResourceMapping) {
            ResourceMapping resourceMapping = (ResourceMapping)mapping;
            if (resourceMapping.isRoot()) {
                this.rootMappingsByAlias.put(mapping.getAlias(), mapping);
                if (resourceMapping instanceof ClassMapping) {
                    this.rootMappingsByClass.addMapping(resourceMapping.getName(), resourceMapping);
                    this.mappingsByClass.addMapping(resourceMapping.getName(), resourceMapping);
                }
                ResourceMapping[] result = new ResourceMapping[this.rootMappingsArr.length + 1];
                for (int i = 0; i < this.rootMappingsArr.length; ++i) {
                    result[i] = this.rootMappingsArr[i];
                }
                result[i] = resourceMapping;
                this.rootMappingsArr = result;
            } else {
                this.nonRootMappingsByAlias.put(mapping.getAlias(), mapping);
                if (resourceMapping instanceof ClassMapping) {
                    this.mappingsByClass.addMapping(resourceMapping.getName(), resourceMapping);
                    this.nonRootMappingsByClass.addMapping(resourceMapping.getName(), resourceMapping);
                }
            }
        }
    }

    public ResourcePropertyLookup getResourcePropertyLookup(String name) throws IllegalArgumentException {
        return new ResourcePropertyLookup(this, name);
    }

    public ResourcePropertyMapping getResourcePropertyMappingByPath(String path) {
        int dotIndex = path.indexOf(46);
        if (dotIndex == -1) {
            return null;
        }
        String alias = path.substring(0, dotIndex);
        ResourceMapping resourceMapping = this.getRootMappingByAlias(alias);
        if (resourceMapping == null) {
            throw new IllegalArgumentException("Failed to find class/resource mapping for alias [" + alias + "] from path [" + path + "]");
        }
        ResourcePropertyMapping resourcePropertyMapping = resourceMapping.getResourcePropertyMappingByDotPath(path.substring(dotIndex + 1));
        if (resourcePropertyMapping == null) {
            throw new IllegalArgumentException("Failed to find mapping for alias [" + alias + "] and path [" + path + "]");
        }
        return resourcePropertyMapping;
    }

    public ResourcePropertyMapping[] getResourcePropertyMappingsByPath(String path) {
        int dotIndex = path.indexOf(46);
        if (dotIndex != -1) {
            return new ResourcePropertyMapping[]{this.getResourcePropertyMappingByPath(path)};
        }
        return (ResourcePropertyMapping[])this.resourcePropertyMappingByPath.get(path);
    }

    public Iterator mappingsIt() {
        return this.mappings.values().iterator();
    }

    public AliasMapping getAliasMapping(String alias) {
        return (AliasMapping)this.mappings.get(alias);
    }

    public ResourceMapping getMappingByAlias(String alias) {
        return (ResourceMapping)this.mappings.get(alias);
    }

    public ResourceMapping getRootMappingByAlias(String alias) {
        return (ResourceMapping)this.rootMappingsByAlias.get(alias);
    }

    public ResourceMapping getNonRootMappingByAlias(String alias) {
        return (ResourceMapping)this.nonRootMappingsByAlias.get(alias);
    }

    public boolean hasRootMappingByAlias(String alias) {
        return this.rootMappingsByAlias.get(alias) != null;
    }

    public boolean hasRootClassMapping(String alias) {
        return this.rootMappingsByAlias.get(alias) instanceof ClassMapping;
    }

    public boolean hasRootRawResourceMapping(String alias) {
        return this.rootMappingsByAlias.get(alias) instanceof RawResourceMapping;
    }

    public boolean hasMultipleRootClassMapping(String className) {
        return this.rootMappingsByClass.hasMultipleMappingsByName(className);
    }

    public ResourceMapping getDirectMappingByClass(Class clazz) {
        return this.mappingsByClass.getResourceMappingByName(clazz.getName());
    }

    public List getAllDirectMappingByClass(Class clazz) {
        return this.mappingsByClass.getUnmodifiableMappingsByName(clazz.getName());
    }

    public ResourceMapping getMappingByClass(Class clazz) {
        return this.doGetResourceMappingByClass(clazz, false, this.mappingsByClass, this.cachedMappingsByClass);
    }

    public ResourceMapping findRootMappingByClass(Class clazz) throws MappingException {
        return this.doGetResourceMappingByClass(clazz, true, this.rootMappingsByClass, this.cachedRootMappingsByClass);
    }

    public ResourceMapping getRootMappingByClass(Class clazz) throws MappingException {
        return this.doGetResourceMappingByClass(clazz, false, this.rootMappingsByClass, this.cachedRootMappingsByClass);
    }

    public ResourceMapping findNonRootMappingByClass(Class clazz) throws MappingException {
        return this.doGetResourceMappingByClass(clazz, true, this.nonRootMappingsByClass, this.cachedNonRootMappingsByClass);
    }

    public ResourceMapping getNonRootMappingByClass(Class clazz) throws MappingException {
        return this.doGetResourceMappingByClass(clazz, false, this.nonRootMappingsByClass, this.cachedNonRootMappingsByClass);
    }

    private ResourceMapping doGetResourceMappingByClass(Class clazz, boolean throwEx, ResourceMappingsByNameHolder mappingByClass, ResourceMappingsByNameHolder cachedMappingsByClass) throws MappingException {
        String className = clazz.getName();
        ResourceMapping rm = cachedMappingsByClass.getResourceMappingByName(className);
        if (rm != null) {
            if (rm == this.nullResourceMappingEntryInCache) {
                if (throwEx) {
                    throw new MappingException("Failed to find any mappings for class [" + className + "]");
                }
                return null;
            }
            return rm;
        }
        rm = this.doGetActualResourceMappingByClass(clazz, mappingByClass);
        if (rm == null) {
            cachedMappingsByClass.addMapping(className, this.nullResourceMappingEntryInCache);
            if (throwEx) {
                throw new MappingException("Failed to find any mappings for class [" + className + "]");
            }
            return null;
        }
        cachedMappingsByClass.addMapping(className, rm);
        return rm;
    }

    private ResourceMapping doGetActualResourceMappingByClass(Class clazz, ResourceMappingsByNameHolder mappingByClass) {
        ResourceMapping rm = mappingByClass.getResourceMappingByName(clazz.getName());
        if (rm != null) {
            return rm;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            rm = mappingByClass.getResourceMappingByName(interfaces[i].getName());
            if (rm == null) continue;
            return rm;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass == null) {
            return null;
        }
        return this.doGetActualResourceMappingByClass(superClass, mappingByClass);
    }

    public ResourceMapping[] getRootMappings() {
        return this.rootMappingsArr;
    }

    public ConverterLookup getConverterLookup() {
        return this.converterLookup;
    }

    public PropertyPath getPath() {
        return this.path;
    }

    public void setPath(PropertyPath path) {
        this.path = path;
    }

    private class ResourceMappingsByNameHolder {
        private final HashMap mappings = new HashMap();

        private ResourceMappingsByNameHolder() {
        }

        void addMapping(String name, ResourceMapping resourceMapping) {
            ArrayList<ResourceMapping> l = (ArrayList<ResourceMapping>)this.mappings.get(name);
            if (l == null) {
                l = new ArrayList<ResourceMapping>();
                this.mappings.put(name, l);
            }
            l.add(resourceMapping);
        }

        public void clear() {
            this.mappings.clear();
        }

        public List getMappingsByName(String name) {
            return (List)this.mappings.get(name);
        }

        public List getUnmodifiableMappingsByName(String name) {
            return Collections.unmodifiableList((List)this.mappings.get(name));
        }

        public ResourceMapping getResourceMappingByName(String name) {
            List l = this.getMappingsByName(name);
            if (l == null) {
                return null;
            }
            return (ResourceMapping)l.get(l.size() - 1);
        }

        public boolean hasMultipleMappingsByName(String name) {
            List l = this.getMappingsByName(name);
            return l != null && l.size() > 1;
        }
    }
}

