/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping;

import org.compass.core.converter.Converter;
import org.compass.core.converter.ResourcePropertyConverter;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourcePropertyMapping;

public final class ResourcePropertyLookup {
    private ResourcePropertyMapping resourcePropertyMapping;
    private ResourcePropertyMapping[] resourcePropertyMappings;
    private String lookupName;
    private String path;
    private String dotPathAlias;
    private boolean convertOnlyWithDotPath = true;
    private CompassMapping compassMapping;

    public ResourcePropertyLookup(CompassMapping compassMapping, String name) {
        this.compassMapping = compassMapping;
        this.lookupName = name;
        if (name.charAt(0) == '\'' && name.charAt(name.length() - 1) == '\'') {
            this.path = name.substring(1, name.length() - 1);
        } else {
            int dotIndex = name.indexOf(46);
            if (dotIndex != -1) {
                this.dotPathAlias = name.substring(0, dotIndex);
            }
            this.resourcePropertyMapping = compassMapping.getResourcePropertyMappingByPath(name);
            this.path = this.resourcePropertyMapping == null ? name : this.resourcePropertyMapping.getPath().getPath();
        }
        this.resourcePropertyMappings = compassMapping.getResourcePropertyMappingsByPath(this.path);
        if (this.resourcePropertyMappings != null && this.resourcePropertyMapping == null) {
            this.resourcePropertyMapping = this.resourcePropertyMappings[0];
        }
    }

    public void setConvertOnlyWithDotPath(boolean convertOnlyWithDotPath) {
        this.convertOnlyWithDotPath = convertOnlyWithDotPath;
    }

    public String getLookupName() {
        return this.lookupName;
    }

    public String getDotPathAlias() {
        return this.dotPathAlias;
    }

    public String getPath() {
        return this.path;
    }

    public ResourcePropertyMapping getResourcePropertyMapping() {
        return this.resourcePropertyMapping;
    }

    public ResourcePropertyMapping[] getResourcePropertyMappings() {
        if (this.resourcePropertyMappings == null && this.resourcePropertyMapping != null) {
            this.resourcePropertyMappings = new ResourcePropertyMapping[]{this.resourcePropertyMapping};
        }
        return this.resourcePropertyMappings;
    }

    public boolean hasSpecificConverter() {
        if (this.dotPathAlias == null && this.convertOnlyWithDotPath) {
            return false;
        }
        return this.resourcePropertyMapping != null && this.resourcePropertyMapping.getConverter() != null;
    }

    public String getValue(Object value) {
        if (value instanceof String) {
            return this.normalizeString((String)value);
        }
        ResourcePropertyConverter converter = this.hasSpecificConverter() ? (ResourcePropertyConverter)this.resourcePropertyMapping.getConverter() : (ResourcePropertyConverter)this.compassMapping.getConverterLookup().lookupConverter(value.getClass());
        return converter.toString(value, this.resourcePropertyMapping);
    }

    public Object fromString(String value) {
        ResourcePropertyConverter converter = this.hasSpecificConverter() ? (ResourcePropertyConverter)this.resourcePropertyMapping.getConverter() : (ResourcePropertyConverter)this.compassMapping.getConverterLookup().lookupConverter(value.getClass());
        return converter.fromString(value, this.resourcePropertyMapping);
    }

    public String normalizeString(String value) {
        if (!this.hasSpecificConverter()) {
            return value;
        }
        Converter converter = this.resourcePropertyMapping.getConverter();
        if (!(converter instanceof ResourcePropertyConverter)) {
            return value;
        }
        ResourcePropertyConverter rpConverter = (ResourcePropertyConverter)converter;
        if (!rpConverter.canNormalize()) {
            return value;
        }
        return rpConverter.toString(rpConverter.fromString(value, this.resourcePropertyMapping), this.resourcePropertyMapping);
    }
}

