/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.osem;

import org.compass.core.CompassException;
import org.compass.core.mapping.CascadeMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.osem.AbstractAccessorMapping;

public class ParentMapping
extends AbstractAccessorMapping
implements CascadeMapping {
    private CascadeMapping.Cascade[] cascades;
    private Boolean shouldCascadeDelete;
    private Boolean shouldCascadeCreate;
    private Boolean shouldCascadeSave;

    public Mapping copy() {
        ParentMapping copy = new ParentMapping();
        super.copy(copy);
        copy.setName(this.getName());
        copy.setSetter(this.getSetter());
        copy.setGetter(this.getGetter());
        copy.setCascades(this.cascades);
        return copy;
    }

    public boolean canBeCollectionWrapped() {
        return false;
    }

    public boolean controlsObjectNullability() {
        return false;
    }

    public CascadeMapping.Cascade[] getCascades() {
        return this.cascades;
    }

    public void setCascades(CascadeMapping.Cascade[] cascades) {
        this.cascades = cascades;
    }

    public Object getCascadeValue(Object root) throws CompassException {
        return this.getGetter().get(root);
    }

    public boolean shouldCascadeDelete() {
        if (this.cascades == null) {
            return false;
        }
        if (this.shouldCascadeDelete != null) {
            return this.shouldCascadeDelete;
        }
        for (int i = 0; i < this.cascades.length; ++i) {
            if (this.cascades[i] != CascadeMapping.Cascade.DELETE && this.cascades[i] != CascadeMapping.Cascade.ALL) continue;
            this.shouldCascadeDelete = Boolean.TRUE;
        }
        if (this.shouldCascadeDelete == null) {
            this.shouldCascadeDelete = Boolean.FALSE;
        }
        return this.shouldCascadeDelete;
    }

    public boolean shouldCascadeCreate() {
        if (this.cascades == null) {
            return false;
        }
        if (this.shouldCascadeCreate != null) {
            return this.shouldCascadeCreate;
        }
        for (int i = 0; i < this.cascades.length; ++i) {
            if (this.cascades[i] != CascadeMapping.Cascade.CREATE && this.cascades[i] != CascadeMapping.Cascade.ALL) continue;
            this.shouldCascadeCreate = Boolean.TRUE;
        }
        if (this.shouldCascadeCreate == null) {
            this.shouldCascadeCreate = Boolean.FALSE;
        }
        return this.shouldCascadeCreate;
    }

    public boolean shouldCascadeSave() {
        if (this.cascades == null) {
            return false;
        }
        if (this.shouldCascadeSave != null) {
            return this.shouldCascadeSave;
        }
        for (int i = 0; i < this.cascades.length; ++i) {
            if (this.cascades[i] != CascadeMapping.Cascade.SAVE && this.cascades[i] != CascadeMapping.Cascade.ALL) continue;
            this.shouldCascadeSave = Boolean.TRUE;
        }
        if (this.shouldCascadeSave == null) {
            this.shouldCascadeSave = Boolean.FALSE;
        }
        return this.shouldCascadeSave;
    }

    public boolean shouldCascade(CascadeMapping.Cascade cascade) {
        if (this.cascades == null || this.cascades.length == 0) {
            return false;
        }
        if (cascade == CascadeMapping.Cascade.ALL) {
            return true;
        }
        if (cascade == CascadeMapping.Cascade.CREATE) {
            return this.shouldCascadeCreate();
        }
        if (cascade == CascadeMapping.Cascade.SAVE) {
            return this.shouldCascadeSave();
        }
        if (cascade == CascadeMapping.Cascade.DELETE) {
            return this.shouldCascadeDelete();
        }
        throw new IllegalArgumentException("Should cascade can't handle [" + cascade + "]");
    }
}

