/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.marshall;

import java.util.HashMap;
import java.util.Map;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.engine.naming.PropertyPath;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.marshall.MarshallingContext;
import org.compass.core.marshall.MarshallingStrategy;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.spi.ResourceKey;

public class DefaultMarshallingContext
implements MarshallingContext {
    private static final Object nullValue = new Object();
    private CompassMapping mapping;
    private SearchEngine searchEngine;
    private ConverterLookup converterLookup;
    private InternalCompassSession session;
    private MarshallingStrategy marshallingStrategy;
    private PropertyNamingStrategy propertyNamingStrategy;
    private Map attributes = new HashMap();
    private Map nullValuesPath = new HashMap();
    private Map unmarshalled = new HashMap();
    private Map marshalled = new HashMap();

    public DefaultMarshallingContext(CompassMapping mapping, SearchEngine searchEngine, ConverterLookup converterLookup, InternalCompassSession session, MarshallingStrategy marshallingStrategy) {
        this.mapping = mapping;
        this.searchEngine = searchEngine;
        this.converterLookup = converterLookup;
        this.session = session;
        this.marshallingStrategy = marshallingStrategy;
        this.propertyNamingStrategy = session.getCompass().getPropertyNamingStrategy();
    }

    public void clearContext() {
        this.attributes.clear();
        this.nullValuesPath.clear();
        this.unmarshalled.clear();
        this.marshalled.clear();
    }

    public void setUnmarshalled(ResourceKey key, Object obj) {
        this.unmarshalled.put(key, obj);
    }

    public Object getUnmarshalled(ResourceKey key) {
        Object obj = this.session.getFirstLevelCache().get(key);
        if (obj != null) {
            return obj;
        }
        return this.unmarshalled.get(key);
    }

    public void setMarshalled(Object key, Object value) {
        this.marshalled.put(key, value);
    }

    public Object getMarshalled(Object key) {
        return this.marshalled.get(key);
    }

    public void setHandleNulls(PropertyPath path) {
        this.nullValuesPath.put(path, nullValue);
    }

    public void removeHandleNulls(PropertyPath path) {
        this.nullValuesPath.remove(path);
    }

    public boolean handleNulls() {
        return this.nullValuesPath.size() > 0;
    }

    public ConverterLookup getConverterLookup() {
        return this.converterLookup;
    }

    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    public CompassMapping getCompassMapping() {
        return this.mapping;
    }

    public InternalCompassSession getSession() {
        return this.session;
    }

    public MarshallingStrategy getMarshallingStrategy() {
        return this.marshallingStrategy;
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public void setAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    public Map removeAttributes() {
        Map retAttributes = this.attributes;
        this.attributes = new HashMap();
        return this.attributes;
    }

    public void restoreAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public PropertyNamingStrategy getPropertyNamingStrategy() {
        return this.propertyNamingStrategy;
    }
}

