/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.transaction;

import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.transaction.AbstractJTATransaction;
import org.compass.core.transaction.JTASyncTransactionFactory;

public class JTASyncTransaction
extends AbstractJTATransaction {
    private boolean commitBeforeCompletion;
    static /* synthetic */ Class class$org$compass$core$transaction$JTASyncTransaction$JTATransactionSynchronization;

    public JTASyncTransaction(UserTransaction ut, boolean commitBeforeCompletion) {
        super(ut);
        this.commitBeforeCompletion = commitBeforeCompletion;
    }

    protected void doBindToTransaction(Transaction tx, InternalCompassSession session, boolean newTransaction) throws Exception {
        tx.registerSynchronization((Synchronization)new JTATransactionSynchronization(session, tx, newTransaction, this.commitBeforeCompletion));
    }

    private static class JTATransactionSynchronization
    implements Synchronization {
        private static final Log log = LogFactory.getLog((Class)(class$org$compass$core$transaction$JTASyncTransaction$JTATransactionSynchronization == null ? (class$org$compass$core$transaction$JTASyncTransaction$JTATransactionSynchronization = JTASyncTransaction.class$("org.compass.core.transaction.JTASyncTransaction$JTATransactionSynchronization")) : class$org$compass$core$transaction$JTASyncTransaction$JTATransactionSynchronization));
        private InternalCompassSession session;
        private Transaction tx;
        private boolean compassControlledJtaTransaction;
        private boolean commitBeforeCompletion;

        public JTATransactionSynchronization(InternalCompassSession session, Transaction tx, boolean compassControlledJtaTransaction, boolean commitBeforeCompletion) {
            this.session = session;
            this.tx = tx;
            this.compassControlledJtaTransaction = compassControlledJtaTransaction;
            this.commitBeforeCompletion = commitBeforeCompletion;
        }

        public void beforeCompletion() {
            if (!this.commitBeforeCompletion) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Committing compass transaction using JTA synchronization beforeCompletion on thread [" + Thread.currentThread().getName() + "]"));
            }
            this.session.getSearchEngine().commit(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            try {
                if (!this.commitBeforeCompletion) {
                    if (status == 3) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Committing compass transaction using JTA synchronization afterCompletion on thread [" + Thread.currentThread().getName() + "]"));
                        }
                        this.session.getSearchEngine().commit(true);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Rolling back compass transaction using JTA synchronization afterCompletion on thread [" + Thread.currentThread().getName() + "] with status [" + status + "]"));
                        }
                        this.session.getSearchEngine().rollback();
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception occured when sync with transaction", (Throwable)e);
            }
            finally {
                this.session.evictAll();
                ((JTASyncTransactionFactory)this.session.getCompass().getTransactionFactory()).unbindSessionFromTransaction(this.tx);
                if (!this.compassControlledJtaTransaction) {
                    this.session.close();
                }
            }
        }
    }
}

