/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.transaction.TransactionException;
import org.compass.core.transaction.TransactionManagerLookup;
import org.compass.core.transaction.manager.Glassfish;
import org.compass.core.transaction.manager.JBoss;
import org.compass.core.transaction.manager.JOTM;
import org.compass.core.transaction.manager.JOnAS;
import org.compass.core.transaction.manager.JRun4;
import org.compass.core.transaction.manager.OC4J;
import org.compass.core.transaction.manager.Orion;
import org.compass.core.transaction.manager.Resin;
import org.compass.core.transaction.manager.WebSphere;
import org.compass.core.transaction.manager.Weblogic;
import org.compass.core.util.ClassUtils;

public final class TransactionManagerLookupFactory {
    private static final Log log = LogFactory.getLog((Class)TransactionManagerLookupFactory.class);
    private static Class[] autoDetectOrder = new Class[]{WebSphere.class, Weblogic.class, JOnAS.class, JOTM.class, JBoss.class, Glassfish.class, Orion.class, Resin.class, OC4J.class, JRun4.class};

    private TransactionManagerLookupFactory() {
    }

    public static TransactionManagerLookup getTransactionManagerLookup(CompassSettings settings) throws TransactionException {
        String tmLookupClass = settings.getSetting("compass.transaction.managerLookup");
        if (tmLookupClass == null) {
            log.info((Object)"JTA Transaction Manager Lookup setting not found, auto detecting....");
            for (int i = 0; i < autoDetectOrder.length; ++i) {
                TransactionManagerLookup tmLookup;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trying [" + autoDetectOrder[i].getName() + "]"));
                }
                if ((tmLookup = TransactionManagerLookupFactory.detect(autoDetectOrder[i], settings)) == null) continue;
                log.info((Object)("Detected JTA Transaction Manager [" + autoDetectOrder[i].getName() + "]"));
                return tmLookup;
            }
            return null;
        }
        log.info((Object)("Instantiating TransactionManagerLookup [" + tmLookupClass + "]"));
        try {
            return (TransactionManagerLookup)ClassUtils.forName(tmLookupClass).newInstance();
        }
        catch (Exception e) {
            throw new TransactionException("Could not instantiate TransactionManagerLookup", e);
        }
    }

    private static TransactionManagerLookup detect(Class tmClass, CompassSettings settings) {
        try {
            TransactionManagerLookup tmLookup = (TransactionManagerLookup)tmClass.newInstance();
            if (tmLookup.getTransactionManager(settings) != null) {
                return tmLookup;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

