/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.hibernate.indexer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassSession;
import org.compass.gps.device.hibernate.HibernateGpsDevice;
import org.compass.gps.device.hibernate.HibernateGpsDeviceException;
import org.compass.gps.device.hibernate.entities.EntityInformation;
import org.compass.gps.device.hibernate.indexer.HibernateIndexEntitiesIndexer;
import org.compass.gps.device.support.parallel.IndexEntity;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class ScrollableHibernateIndexEntitiesIndexer
implements HibernateIndexEntitiesIndexer {
    private static final Log log = LogFactory.getLog((Class)ScrollableHibernateIndexEntitiesIndexer.class);
    private HibernateGpsDevice device;

    public void setHibernateGpsDevice(HibernateGpsDevice device) {
        this.device = device;
    }

    public void performIndex(CompassSession session, IndexEntity[] entities) {
        for (int i = 0; i < entities.length; ++i) {
            EntityInformation entityInformation = (EntityInformation)entities[i];
            if (this.device.isFilteredForIndex(entityInformation.getName())) continue;
            if (!this.device.isRunning()) {
                return;
            }
            ScrollableResults cursor = null;
            Session hibernateSession = this.device.getSessionFactory().openSession();
            Transaction hibernateTransaction = null;
            try {
                hibernateTransaction = hibernateSession.beginTransaction();
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.device.buildMessage("Indexing entities [" + entityInformation.getName() + "] using query [" + entityInformation.getQueryProvider() + "]"));
                }
                Query query = entityInformation.getQueryProvider().createQuery((org.hibernate.Session)hibernateSession, entityInformation);
                cursor = query.scroll(ScrollMode.FORWARD_ONLY);
                while (cursor.next()) {
                    Object item = cursor.get(0);
                    session.create(item);
                    hibernateSession.evict(item);
                    session.evictAll();
                }
                cursor.close();
                session.evictAll();
                hibernateTransaction.commit();
                continue;
            }
            catch (Exception e) {
                log.error((Object)this.device.buildMessage("Failed to index the database"), (Throwable)e);
                if (cursor != null) {
                    try {
                        cursor.close();
                    }
                    catch (Exception e1) {
                        log.warn((Object)this.device.buildMessage("Failed to close cursor on error, ignoring"), (Throwable)e1);
                    }
                }
                if (hibernateTransaction != null) {
                    try {
                        hibernateTransaction.rollback();
                    }
                    catch (Exception e1) {
                        log.warn((Object)"Failed to rollback Hibernate", (Throwable)e1);
                    }
                }
                if (!(e instanceof HibernateGpsDeviceException)) {
                    throw new HibernateGpsDeviceException(this.device.buildMessage("Failed to index the database"), e);
                }
                throw (HibernateGpsDeviceException)e;
            }
            finally {
                session.close();
            }
        }
    }
}

