/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.embedded.openjpa;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.conf.OpenJPAVersion;
import org.apache.openjpa.event.BeginTransactionListener;
import org.apache.openjpa.event.BrokerFactoryEvent;
import org.apache.openjpa.event.BrokerFactoryListener;
import org.apache.openjpa.event.EndTransactionListener;
import org.apache.openjpa.event.RemoteCommitEvent;
import org.apache.openjpa.event.RemoteCommitListener;
import org.apache.openjpa.event.TransactionEvent;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.lib.conf.AbstractProductDerivation;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.persistence.EntityManagerFactoryImpl;
import org.apache.openjpa.persistence.Extent;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.util.OpenJPAId;
import org.compass.core.Compass;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.config.CompassConfiguration;
import org.compass.core.config.CompassConfigurationFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.transaction.LocalTransactionFactory;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.embedded.DefaultJpaCompassGps;
import org.compass.gps.device.jpa.embedded.openjpa.EmbeddedOpenJPAEventListener;
import org.compass.gps.device.jpa.lifecycle.OpenJPAJpaEntityLifecycleInjector;

public class CompassProductDerivation
extends AbstractProductDerivation {
    public static final String COMPASS_USER_OBJECT_KEY = CompassProductDerivation.class.getName() + ".compass";
    public static final String COMPASS_SESSION_USER_OBJECT_KEY = CompassProductDerivation.class.getName() + ".compassSession";
    public static final String COMPASS_TRANSACTION_USER_OBJECT_KEY = CompassProductDerivation.class.getName() + ".compassTransaction";
    public static final String COMPASS_GPS_USER_OBJECT_KEY = CompassProductDerivation.class.getName() + ".gps";
    public static final String COMPASS_INDEX_SETTINGS_USER_OBJECT_KEY = CompassProductDerivation.class.getName() + ".indexprops";
    private static final String COMPASS_PREFIX = "compass";
    private static final String COMPASS_GPS_INDEX_PREFIX = "gps.index.";
    public static final String REINDEX_ON_STARTUP = "compass.openjpa.reindexOnStartup";
    public static final String REGISTER_REMOTE_COMMIT_LISTENER = "compass.openjpa.registerRemoteCommitListener";
    public static final String INDEX_QUERY_PREFIX = "compass.openjpa.indexQuery.";
    public static final String COMPASS_CONFIG_LOCATION = "compass.openjpa.config";
    private static final Map<OpenJPAConfiguration, CompassProductDerivation> derivations = new IdentityHashMap<OpenJPAConfiguration, CompassProductDerivation>();
    private Compass compass;
    private DefaultJpaCompassGps jpaCompassGps;
    private boolean commitBeforeCompletion;
    private boolean openJpaControlledTransaction;
    private Properties compassProperties;

    public int getType() {
        return 1000;
    }

    public boolean beforeConfigurationLoad(Configuration config) {
        if (!(config instanceof OpenJPAConfiguration)) {
            return false;
        }
        OpenJPAConfigurationImpl openJpaConfig = (OpenJPAConfigurationImpl)config;
        openJpaConfig.remoteProviderPlugin.setTransmitPersistedObjectIds(true);
        if (!CompassProductDerivation.isReleasedVersion()) {
            openJpaConfig.getLog("openjpa.Runtime").warn((Object)"Compass cannot automatically install itself into pre-1.0 versions of OpenJPA. To complete Compass installation, you must invoke CompassProductDerivation.installCompass().");
            derivations.put((OpenJPAConfiguration)openJpaConfig, this);
            return false;
        }
        openJpaConfig.getBrokerFactoryEventManager().addListener((Object)new BrokerFactoryListener(){

            public void afterBrokerFactoryCreate(BrokerFactoryEvent event) {
                CompassProductDerivation.this.installIntoFactory(event.getBrokerFactory());
            }

            public void eventFired(BrokerFactoryEvent event) {
                if (event.getEventType() == 0) {
                    this.afterBrokerFactoryCreate(event);
                }
            }
        });
        return false;
    }

    public static void installCompass(BrokerFactory factory) {
        if (factory.getUserObject((Object)COMPASS_USER_OBJECT_KEY) != null) {
            return;
        }
        CompassProductDerivation derivation = derivations.get(factory.getConfiguration());
        if (derivation == null) {
            throw new IllegalStateException("no CompassProductDerivation instance registered for this configuration");
        }
        derivation.installIntoFactory(factory);
    }

    private void installIntoFactory(BrokerFactory factory) {
        OpenJPAConfiguration openJpaConfig = factory.getConfiguration();
        this.compassProperties = new Properties();
        Map openJpaProps = openJpaConfig.toProperties(false);
        for (Map.Entry entry : openJpaProps.entrySet()) {
            if (((String)entry.getKey()).startsWith(COMPASS_PREFIX)) {
                this.compassProperties.put(entry.getKey(), entry.getValue());
            }
            if (!((String)entry.getKey()).startsWith(COMPASS_GPS_INDEX_PREFIX)) continue;
            this.compassProperties.put(entry.getKey(), entry.getValue());
        }
        if (this.compassProperties.isEmpty()) {
            return;
        }
        CompassConfiguration compassConfiguration = CompassConfigurationFactory.newConfiguration();
        CompassSettings settings = compassConfiguration.getSettings();
        settings.addSettings(this.compassProperties);
        String configLocation = (String)this.compassProperties.get(COMPASS_CONFIG_LOCATION);
        if (configLocation != null) {
            compassConfiguration.configure(configLocation);
        }
        Collection classes = openJpaConfig.getMetaDataRepositoryInstance().loadPersistentTypes(true, null);
        for (Class jpaClass : classes) {
            compassConfiguration.tryAddClass(jpaClass);
        }
        String transactionFactory = (String)this.compassProperties.get("compass.transaction.factory");
        if (transactionFactory == null || LocalTransactionFactory.class.getName().equals(transactionFactory)) {
            this.openJpaControlledTransaction = true;
            if (settings.getSetting("compass.transaction.disableThreadBoundLocalTransaction") == null) {
                settings.setBooleanSetting("compass.transaction.disableThreadBoundLocalTransaction", true);
            }
        } else {
            this.openJpaControlledTransaction = false;
        }
        this.compass = compassConfiguration.buildCompass();
        this.commitBeforeCompletion = settings.getSettingAsBoolean("compass.transaction.commitBeforeCompletion", false);
        factory.putUserObject((Object)COMPASS_USER_OBJECT_KEY, (Object)this.compass);
        this.registerListeners(factory);
        Properties indexProps = new Properties();
        for (Map.Entry<Object, Object> entry : this.compassProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(COMPASS_GPS_INDEX_PREFIX)) continue;
            indexProps.put(key.substring(COMPASS_GPS_INDEX_PREFIX.length()), entry.getValue());
        }
        factory.putUserObject((Object)COMPASS_INDEX_SETTINGS_USER_OBJECT_KEY, (Object)indexProps);
        OpenJPAEntityManagerFactory emf = this.toEntityManagerFactory(factory);
        JpaGpsDevice jpaGpsDevice = new JpaGpsDevice("jpa", (EntityManagerFactory)emf);
        jpaGpsDevice.setMirrorDataChanges(true);
        jpaGpsDevice.setInjectEntityLifecycleListener(true);
        for (Map.Entry<Object, Object> entry : this.compassProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(INDEX_QUERY_PREFIX)) continue;
            String entityName = key.substring(INDEX_QUERY_PREFIX.length());
            String selectQuery = (String)entry.getValue();
            jpaGpsDevice.setIndexSelectQuery(entityName, selectQuery);
        }
        OpenJPAJpaEntityLifecycleInjector lifecycleInjector = new OpenJPAJpaEntityLifecycleInjector();
        lifecycleInjector.setEventListener(new EmbeddedOpenJPAEventListener(jpaGpsDevice));
        jpaGpsDevice.setLifecycleInjector(lifecycleInjector);
        this.jpaCompassGps = new DefaultJpaCompassGps();
        this.jpaCompassGps.setCompass(this.compass);
        this.jpaCompassGps.addGpsDevice(jpaGpsDevice);
        emf.createEntityManager().close();
        this.jpaCompassGps.start();
        String reindexOnStartup = (String)this.compassProperties.get(REINDEX_ON_STARTUP);
        if ("true".equalsIgnoreCase(reindexOnStartup)) {
            this.jpaCompassGps.index();
        }
        factory.putUserObject((Object)COMPASS_GPS_USER_OBJECT_KEY, (Object)this.jpaCompassGps);
    }

    private OpenJPAEntityManagerFactory toEntityManagerFactory(BrokerFactory factory) {
        try {
            Class<Object> cls;
            try {
                cls = Class.forName("org.apache.openjpa.persistence.JPAFacadeHelper");
            }
            catch (ClassNotFoundException e) {
                cls = OpenJPAPersistence.class;
            }
            return (OpenJPAEntityManagerFactory)cls.getMethod("toEntityManagerFactory", BrokerFactory.class).invoke(null, factory);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    protected void registerListeners(BrokerFactory brokerFactory) {
        brokerFactory.addTransactionListener((Object)new BeginTransactionListener(){

            public void afterBegin(TransactionEvent transactionEvent) {
                Broker broker = (Broker)transactionEvent.getSource();
                CompassSession session = CompassProductDerivation.this.compass.openSession();
                broker.putUserObject((Object)COMPASS_SESSION_USER_OBJECT_KEY, (Object)session);
                CompassTransaction tr = session.beginTransaction();
                broker.putUserObject((Object)COMPASS_TRANSACTION_USER_OBJECT_KEY, (Object)tr);
            }
        });
        brokerFactory.addTransactionListener((Object)new EndTransactionListener(){

            public void beforeCommit(TransactionEvent transactionEvent) {
                if (CompassProductDerivation.this.commitBeforeCompletion) {
                    this.commit(transactionEvent);
                }
            }

            public void afterCommit(TransactionEvent transactionEvent) {
            }

            public void afterRollback(TransactionEvent transactionEvent) {
            }

            public void afterStateTransitions(TransactionEvent transactionEvent) {
            }

            public void afterCommitComplete(TransactionEvent transactionEvent) {
                if (!CompassProductDerivation.this.commitBeforeCompletion) {
                    this.commit(transactionEvent);
                }
            }

            public void afterRollbackComplete(TransactionEvent transactionEvent) {
                this.rollback(transactionEvent);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void commit(TransactionEvent trEvent) {
                Broker broker = (Broker)trEvent.getSource();
                CompassTransaction tr = (CompassTransaction)broker.getUserObject((Object)COMPASS_TRANSACTION_USER_OBJECT_KEY);
                CompassSession session = (CompassSession)broker.getUserObject((Object)COMPASS_SESSION_USER_OBJECT_KEY);
                try {
                    if (CompassProductDerivation.this.openJpaControlledTransaction) {
                        tr.commit();
                    }
                }
                finally {
                    session.close();
                    broker.putUserObject((Object)COMPASS_TRANSACTION_USER_OBJECT_KEY, null);
                    broker.putUserObject((Object)COMPASS_SESSION_USER_OBJECT_KEY, null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void rollback(TransactionEvent trEvent) {
                Broker broker = (Broker)trEvent.getSource();
                CompassTransaction tr = (CompassTransaction)broker.getUserObject((Object)COMPASS_TRANSACTION_USER_OBJECT_KEY);
                CompassSession session = (CompassSession)broker.getUserObject((Object)COMPASS_SESSION_USER_OBJECT_KEY);
                try {
                    if (CompassProductDerivation.this.openJpaControlledTransaction) {
                        tr.rollback();
                    }
                }
                finally {
                    session.close();
                    broker.putUserObject((Object)COMPASS_TRANSACTION_USER_OBJECT_KEY, null);
                    broker.putUserObject((Object)COMPASS_SESSION_USER_OBJECT_KEY, null);
                }
            }
        });
        String registerRemoteCommitListener = (String)this.compassProperties.get(REGISTER_REMOTE_COMMIT_LISTENER);
        if ("true".equalsIgnoreCase(registerRemoteCommitListener)) {
            brokerFactory.getConfiguration().getRemoteCommitEventManager().addListener((RemoteCommitListener)new CompassRemoteCommitListener(this.toEntityManagerFactory(brokerFactory), this.compass));
        }
    }

    public void beforeConfigurationClose(Configuration configuration) {
        if (this.jpaCompassGps != null) {
            this.jpaCompassGps.stop();
        }
        if (this.compass != null) {
            this.compass.close();
        }
    }

    public static boolean isReleasedVersion() {
        if (OpenJPAVersion.MAJOR_RELEASE < 1) {
            return false;
        }
        if (OpenJPAVersion.MAJOR_RELEASE == 1 && OpenJPAVersion.MINOR_RELEASE == 0 && OpenJPAVersion.PATCH_RELEASE == 0) {
            try {
                Class.forName("org.apache.openjpa.event.BrokerFactoryEvent", false, OpenJPAVersion.class.getClassLoader());
                return true;
            }
            catch (ClassNotFoundException cnfe) {
                return false;
            }
        }
        return true;
    }

    private static class CompassRemoteCommitListener
    implements RemoteCommitListener {
        private static final Log log = LogFactory.getLog(CompassRemoteCommitListener.class);
        private final EntityManagerFactoryImpl emf;
        private final Compass compass;

        private CompassRemoteCommitListener(OpenJPAEntityManagerFactory emf, Compass compass) {
            this.emf = (EntityManagerFactoryImpl)emf;
            this.compass = compass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCommit(RemoteCommitEvent event) {
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            CompassSession session = this.compass.openSession();
            CompassTransaction tr = null;
            try {
                tr = session.beginTransaction();
                switch (event.getPayloadType()) {
                    case 0: {
                        this.reindexTypesByName(event.getPersistedTypeNames(), (OpenJPAEntityManager)em, session);
                        this.reindexObjectsById(event.getUpdatedObjectIds(), (OpenJPAEntityManager)em, session);
                        this.deleteObjectsById(event.getDeletedObjectIds(), session);
                        break;
                    }
                    case 1: {
                        this.reindexObjectsById(event.getPersistedObjectIds(), (OpenJPAEntityManager)em, session);
                        this.reindexObjectsById(event.getUpdatedObjectIds(), (OpenJPAEntityManager)em, session);
                        this.deleteObjectsById(event.getDeletedObjectIds(), session);
                        break;
                    }
                    case 2: {
                        HashSet c = new HashSet();
                        c.addAll(event.getPersistedTypeNames());
                        c.addAll(event.getUpdatedTypeNames());
                        c.addAll(event.getDeletedTypeNames());
                        this.reindexTypesByName(c, (OpenJPAEntityManager)em, session);
                        break;
                    }
                    case 3: {
                        this.reindexObjectsById(event.getUpdatedObjectIds(), (OpenJPAEntityManager)em, session);
                        break;
                    }
                    default: {
                        log.warn((Object)("Unknown remote commit event type [" + event.getPayloadType() + "], ignoring..."));
                    }
                }
                tr.commit();
            }
            catch (Exception e) {
                log.error((Object)"Failed to perform remote commit syncronization", (Throwable)e);
                if (tr != null) {
                    tr.rollback();
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
                if (em != null) {
                    em.close();
                }
            }
        }

        private void reindexObjectsById(Collection oids, OpenJPAEntityManager em, CompassSession session) {
            for (OpenJPAId oid : oids) {
                this.reindexOid(oid, em, session);
            }
        }

        private void deleteObjectsById(Collection oids, CompassSession session) {
            for (OpenJPAId oid : oids) {
                this.delete(oid, session);
            }
        }

        private void reindexTypesByName(Collection typeNames, OpenJPAEntityManager em, CompassSession session) {
            ClassLoader loader = this.emf.getConfiguration().getClassResolverInstance().getClassLoader(null, null);
            for (String typeName : typeNames) {
                try {
                    Class<?> cls = Class.forName(typeName, true, loader);
                    session.delete(session.queryBuilder().matchAll().setTypes(new Class[]{cls}));
                    Extent extent = em.createExtent(cls, true);
                    for (Object o : extent.list()) {
                        this.reindex(o, session);
                    }
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)"Failed to find class", (Throwable)e);
                }
            }
        }

        private void reindexOid(OpenJPAId oid, OpenJPAEntityManager em, CompassSession session) {
            try {
                Object o = em.find(oid.getType(), oid.getIdObject());
                this.reindex(o, session);
            }
            catch (EntityNotFoundException e) {
                this.delete(oid, session);
            }
        }

        private void reindex(Object o, CompassSession session) {
            session.save(o);
        }

        private void delete(OpenJPAId oid, CompassSession session) {
            Class cls = oid.getType();
            Object id = oid.getIdObject();
            session.delete(cls, id);
        }

        public void close() {
        }
    }
}

