/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.embedded.openjpa;

import javax.persistence.EntityManager;
import org.apache.openjpa.event.DeleteListener;
import org.apache.openjpa.event.LifecycleEvent;
import org.apache.openjpa.event.PersistListener;
import org.apache.openjpa.event.StoreListener;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.compass.core.mapping.CascadeMapping;
import org.compass.gps.device.jpa.AbstractDeviceJpaEntityListener;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.embedded.openjpa.OpenJPAHelper;

public class EmbeddedOpenJPAEventListener
extends AbstractDeviceJpaEntityListener
implements DeleteListener,
PersistListener,
StoreListener {
    private JpaGpsDevice device;

    public EmbeddedOpenJPAEventListener(JpaGpsDevice device) {
        this.device = device;
    }

    protected JpaGpsDevice getDevice() {
        return this.device;
    }

    public void beforeDelete(LifecycleEvent lifecycleEvent) {
    }

    public void afterDelete(LifecycleEvent lifecycleEvent) {
        block5: {
            if (this.disable()) {
                return;
            }
            Object entity = lifecycleEvent.getSource();
            if (!this.hasMappingForEntity(entity.getClass(), CascadeMapping.Cascade.DELETE)) {
                return;
            }
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Deleting [" + entity + "]"));
                }
                OpenJPAEntityManager em = OpenJPAPersistence.getEntityManager((Object)entity);
                OpenJPAHelper.getCurrentCompassSession((EntityManager)em).delete(entity);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed while deleting [" + entity + "]"), (Throwable)e);
                if (!this.throwExceptionOnError()) break block5;
                throw new JpaGpsDeviceException("Failed while unpdating [" + entity + "]", e);
            }
        }
    }

    public void beforePersist(LifecycleEvent lifecycleEvent) {
    }

    public void afterPersist(LifecycleEvent lifecycleEvent) {
        block5: {
            if (this.disable()) {
                return;
            }
            Object entity = lifecycleEvent.getSource();
            if (!this.hasMappingForEntity(entity.getClass(), CascadeMapping.Cascade.CREATE)) {
                return;
            }
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Creating [" + entity + "]"));
                }
                OpenJPAEntityManager em = OpenJPAPersistence.getEntityManager((Object)entity);
                OpenJPAHelper.getCurrentCompassSession((EntityManager)em).create(entity);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed while creating [" + entity + "]"), (Throwable)e);
                if (!this.throwExceptionOnError()) break block5;
                throw new JpaGpsDeviceException("Failed while unpdating [" + entity + "]", e);
            }
        }
    }

    public void beforeStore(LifecycleEvent lifecycleEvent) {
    }

    public void afterStore(LifecycleEvent lifecycleEvent) {
        block5: {
            if (this.disable()) {
                return;
            }
            Object entity = lifecycleEvent.getSource();
            if (!this.hasMappingForEntity(entity.getClass(), CascadeMapping.Cascade.SAVE)) {
                return;
            }
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Updating [" + entity + "]"));
                }
                OpenJPAEntityManager em = OpenJPAPersistence.getEntityManager((Object)entity);
                OpenJPAHelper.getCurrentCompassSession((EntityManager)em).save(entity);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed while updating [" + entity + "]"), (Throwable)e);
                if (!this.throwExceptionOnError()) break block5;
                throw new JpaGpsDeviceException("Failed while unpdating [" + entity + "]", e);
            }
        }
    }
}

