/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.indexer;

import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassSession;
import org.compass.gps.device.jpa.EntityManagerWrapper;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.entities.EntityInformation;
import org.compass.gps.device.jpa.indexer.JpaIndexEntitiesIndexer;
import org.compass.gps.device.support.parallel.IndexEntity;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.ejb.HibernateEntityManager;
import org.hibernate.ejb.HibernateQuery;

public class HibernateJpaIndexEntitiesIndexer
implements JpaIndexEntitiesIndexer {
    private static final Log log = LogFactory.getLog(HibernateJpaIndexEntitiesIndexer.class);
    private JpaGpsDevice jpaGpsDevice;

    public void setJpaGpsDevice(JpaGpsDevice jpaGpsDevice) {
        this.jpaGpsDevice = jpaGpsDevice;
    }

    public void performIndex(CompassSession session, IndexEntity[] entities) {
        for (IndexEntity indexEntity : entities) {
            EntityInformation entityInformation = (EntityInformation)indexEntity;
            if (this.jpaGpsDevice.isFilteredForIndex(entityInformation.getName())) continue;
            int fetchCount = this.jpaGpsDevice.getFetchCount();
            if (!this.jpaGpsDevice.isRunning()) {
                return;
            }
            EntityManagerWrapper wrapper = this.jpaGpsDevice.getEntityManagerWrapper().newInstance();
            ScrollableResults cursor = null;
            try {
                wrapper.open();
                HibernateEntityManager entityManager = (HibernateEntityManager)wrapper.getEntityManager();
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.jpaGpsDevice.buildMessage("Indexing entities [" + entityInformation.getName() + "] using query [" + entityInformation.getQueryProvider() + "]"));
                }
                HibernateQuery query = (HibernateQuery)entityInformation.getQueryProvider().createQuery((EntityManager)entityManager, entityInformation);
                cursor = query.getHibernateQuery().scroll(ScrollMode.FORWARD_ONLY);
                while (cursor.next()) {
                    Object item = cursor.get(0);
                    session.create(item);
                    entityManager.getSession().evict(item);
                    session.evictAll();
                }
                cursor.close();
                entityManager.clear();
                wrapper.close();
            }
            catch (Exception e) {
                log.error((Object)this.jpaGpsDevice.buildMessage("Failed to index the database"), (Throwable)e);
                if (cursor != null) {
                    try {
                        cursor.close();
                    }
                    catch (Exception e1) {
                        log.warn((Object)this.jpaGpsDevice.buildMessage("Failed to close cursor on error, ignoring"), (Throwable)e1);
                    }
                }
                wrapper.closeOnError();
                if (!(e instanceof JpaGpsDeviceException)) {
                    throw new JpaGpsDeviceException(this.jpaGpsDevice.buildMessage("Failed to index the database"), e);
                }
                throw (JpaGpsDeviceException)e;
            }
        }
    }
}

