/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.indexer;

import javax.persistence.EntityManagerFactory;
import org.compass.core.util.ClassUtils;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.indexer.DefaultJpaIndexEntitiesIndexer;
import org.compass.gps.device.jpa.indexer.JpaIndexEntitiesIndexer;
import org.compass.gps.device.jpa.support.NativeJpaHelper;

public abstract class JpaIndexEntitiesIndexerDetector {
    public static JpaIndexEntitiesIndexer detectEntitiesIndexer(EntityManagerFactory entityManagerFactory) {
        String locatorClassName = NativeJpaHelper.detectNativeJpa(entityManagerFactory, new NativeJpaHelper.NativeJpaCallback<String>(){

            @Override
            public String onHibernate() {
                return "org.compass.gps.device.jpa.indexer.HibernateJpaIndexEntitiesIndexer";
            }

            @Override
            public String onTopLinkEssentials() {
                return DefaultJpaIndexEntitiesIndexer.class.getName();
            }

            @Override
            public String onOpenJPA() {
                return "org.compass.gps.device.jpa.indexer.OpenJPAJpaIndexEntitiesIndexer";
            }

            @Override
            public String onUnknown() {
                return DefaultJpaIndexEntitiesIndexer.class.getName();
            }
        });
        try {
            Class locatorClass = ClassUtils.forName(locatorClassName);
            return (JpaIndexEntitiesIndexer)locatorClass.newInstance();
        }
        catch (Exception e) {
            throw new JpaGpsDeviceException("Failed to create entities indexer class [" + locatorClassName + "]", e);
        }
    }
}

