/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.ojb;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.PBLifeCycleEvent;
import org.apache.ojb.broker.PBLifeCycleListener;
import org.apache.ojb.broker.PBListener;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.compass.core.CompassCallbackWithoutResult;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.mapping.CascadeMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.spi.InternalCompass;
import org.compass.gps.CompassGpsException;
import org.compass.gps.PassiveMirrorGpsDevice;
import org.compass.gps.device.AbstractGpsDevice;
import org.compass.gps.device.ojb.OjbGpsDeviceException;
import org.compass.gps.spi.CompassGpsInterfaceDevice;

public class OjbGpsDevice
extends AbstractGpsDevice
implements PassiveMirrorGpsDevice {
    protected static Log log = LogFactory.getLog((Class)OjbGpsDevice.class);
    private boolean mirrorDataChanges = true;
    private PersistenceBroker indexPersistenceBroker;
    private CompassGpsPBLifecycleListener lifecycleListener;

    public OjbGpsDevice() {
    }

    public OjbGpsDevice(String name, PersistenceBroker indexPersistenceBroker) {
        this.setName(name);
        this.indexPersistenceBroker = indexPersistenceBroker;
    }

    protected void doIndex(CompassSession session) throws CompassGpsException {
        PersistenceBroker persistenceBroker = this.doGetIndexPersistentBroker();
        if (persistenceBroker == null) {
            throw new OjbGpsDeviceException(this.buildMessage("Must set the index persistent broker"));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)this.buildMessage("Indexing the database"));
        }
        ResourceMapping[] resourceMappings = ((InternalCompass)this.compassGps.getIndexCompass()).getMapping().getRootMappings();
        for (int i = 0; i < resourceMappings.length; ++i) {
            ClassMapping classMapping;
            Class clazz;
            if (!(resourceMappings[i] instanceof ClassMapping) || this.isFilteredForIndex((clazz = (classMapping = (ClassMapping)resourceMappings[i]).getClazz()).getName())) continue;
            try {
                QueryByCriteria query = new QueryByCriteria(clazz);
                Collection datas = null;
                try {
                    datas = persistenceBroker.getCollectionByQuery((Query)query);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (datas == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.buildMessage("Indexing alias [" + classMapping.getAlias() + "] with object count [" + datas.size() + "]"));
                }
                Iterator it = datas.iterator();
                while (it.hasNext()) {
                    session.create(it.next());
                }
                continue;
            }
            catch (Exception e) {
                log.error((Object)this.buildMessage("Failed to index the database"), (Throwable)e);
                throw new OjbGpsDeviceException(this.buildMessage("Failed to index the database"), e);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)this.buildMessage("Finished indexing the database"));
        }
    }

    protected PersistenceBroker doGetIndexPersistentBroker() throws CompassGpsException {
        return this.getIndexPersistenceBroker();
    }

    protected void doStart() throws CompassGpsException {
        this.lifecycleListener = new CompassGpsPBLifecycleListener(this.compassGps, this);
    }

    protected void doStop() throws CompassGpsException {
    }

    public void attachLifecycleListeners(PersistenceBroker pb) {
        pb.addListener((PBListener)this.lifecycleListener);
    }

    public void removeLifecycleListeners(PersistenceBroker pb) {
        pb.removeListener((PBListener)this.lifecycleListener);
    }

    public PersistenceBroker getIndexPersistenceBroker() {
        return this.indexPersistenceBroker;
    }

    public void setIndexPersistenceBroker(PersistenceBroker indexPersistenceBroker) {
        this.indexPersistenceBroker = indexPersistenceBroker;
    }

    public boolean isMirrorDataChanges() {
        return this.mirrorDataChanges;
    }

    public void setMirrorDataChanges(boolean mirrorDataChanges) {
        this.mirrorDataChanges = mirrorDataChanges;
    }

    private class CompassGpsPBLifecycleListener
    implements PBLifeCycleListener {
        private OjbGpsDevice ojbGpsDevice;
        private CompassGpsInterfaceDevice compassGps;

        public CompassGpsPBLifecycleListener(CompassGpsInterfaceDevice compassGps, OjbGpsDevice ojbGpsDevice2) {
            this.compassGps = compassGps;
            this.ojbGpsDevice = ojbGpsDevice2;
        }

        public void beforeInsert(PBLifeCycleEvent lifeCycleEvent) throws PersistenceBrokerException {
        }

        public void afterInsert(PBLifeCycleEvent lifeCycleEvent) throws PersistenceBrokerException {
            if (!this.ojbGpsDevice.shouldMirrorDataChanges() || OjbGpsDevice.this.isPerformingIndexOperation()) {
                return;
            }
            final Object entity = lifeCycleEvent.getTarget();
            if (!this.compassGps.hasMappingForEntityForMirror(entity.getClass(), CascadeMapping.Cascade.CREATE)) {
                return;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("{" + this.ojbGpsDevice.getName() + "}: Creating [" + entity + "]"));
                }
                this.compassGps.executeForMirror(new CompassCallbackWithoutResult(){

                    protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                        session.create(entity);
                    }
                });
            }
            catch (Exception e) {
                log.error((Object)("{" + this.ojbGpsDevice.getName() + "}: Failed while creating [" + entity + "]"), (Throwable)e);
            }
        }

        public void beforeUpdate(PBLifeCycleEvent lifeCycleEvent) throws PersistenceBrokerException {
        }

        public void afterUpdate(PBLifeCycleEvent lifeCycleEvent) throws PersistenceBrokerException {
            if (!this.ojbGpsDevice.shouldMirrorDataChanges() || OjbGpsDevice.this.isPerformingIndexOperation()) {
                return;
            }
            final Object entity = lifeCycleEvent.getTarget();
            if (!this.compassGps.hasMappingForEntityForMirror(entity.getClass(), CascadeMapping.Cascade.SAVE)) {
                return;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("{" + this.ojbGpsDevice.getName() + "}: Updating [" + entity + "]"));
                }
                this.compassGps.executeForMirror(new CompassCallbackWithoutResult(){

                    protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                        session.save(entity);
                    }
                });
            }
            catch (Exception e) {
                log.error((Object)("{" + this.ojbGpsDevice.getName() + "}: Failed while updating [" + entity + "]"), (Throwable)e);
            }
        }

        public void beforeDelete(PBLifeCycleEvent lifeCycleEvent) throws PersistenceBrokerException {
        }

        public void afterDelete(PBLifeCycleEvent lifeCycleEvent) throws PersistenceBrokerException {
            if (!this.ojbGpsDevice.shouldMirrorDataChanges() || OjbGpsDevice.this.isPerformingIndexOperation()) {
                return;
            }
            final Object entity = lifeCycleEvent.getTarget();
            if (!this.compassGps.hasMappingForEntityForMirror(entity.getClass(), CascadeMapping.Cascade.DELETE)) {
                return;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("{" + this.ojbGpsDevice.getName() + "}: Deleting [" + entity + "]"));
                }
                this.compassGps.executeForMirror(new CompassCallbackWithoutResult(){

                    protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                        session.delete(entity);
                    }
                });
            }
            catch (Exception e) {
                log.error((Object)("{" + this.ojbGpsDevice.getName() + "}: Failed while deleting [" + entity + "]"), (Throwable)e);
            }
        }

        public void afterLookup(PBLifeCycleEvent lifeCycleEvent) throws PersistenceBrokerException {
        }
    }
}

