/*
 * Decompiled with CFR 0.152.
 */
package org.compass.spring;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfiguration;
import org.compass.core.config.CompassConfigurationFactory;
import org.compass.core.config.InputStreamMappingResolver;
import org.compass.core.converter.Converter;
import org.compass.core.lucene.engine.store.jdbc.ExternalDataSourceProvider;
import org.compass.core.spi.InternalCompass;
import org.compass.core.util.ClassUtils;
import org.compass.spring.LocalCompassBeanPostProcessor;
import org.compass.spring.transaction.SpringSyncTransactionFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;

public class LocalCompassBean
implements FactoryBean,
InitializingBean,
DisposableBean,
BeanNameAware {
    protected static final Log log = LogFactory.getLog((Class)LocalCompassBean.class);
    private Resource connection;
    private Resource configLocation;
    private Resource[] configLocations;
    private Resource[] resourceLocations;
    private Resource[] resourceJarLocations;
    private Resource[] resourceDirectoryLocations;
    private String[] classMappings;
    private InputStreamMappingResolver[] mappingResolvers;
    private Properties compassSettings;
    private DataSource dataSource;
    private PlatformTransactionManager transactionManager;
    private Map convertersByName;
    private Compass compass;
    private String beanName;
    private CompassConfiguration config;
    private LocalCompassBeanPostProcessor postProcessor;

    public void setPostProcessor(LocalCompassBeanPostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setConnection(Resource connection) {
        this.connection = connection;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setConfigLocations(Resource[] configLocations) {
        this.configLocations = configLocations;
    }

    public void setCompassSettings(Properties compassSettings) {
        this.compassSettings = compassSettings;
    }

    public void setResourceLocations(Resource[] resourceLocations) {
        this.resourceLocations = resourceLocations;
    }

    public void setResourceJarLocations(Resource[] resourceJarLocations) {
        this.resourceJarLocations = resourceJarLocations;
    }

    public void setResourceDirectoryLocations(Resource[] resourceDirectoryLocations) {
        this.resourceDirectoryLocations = resourceDirectoryLocations;
    }

    public void setClassMappings(String[] classMappings) {
        this.classMappings = classMappings;
    }

    public void setMappingResolvers(InputStreamMappingResolver[] mappingResolvers) {
        this.mappingResolvers = mappingResolvers;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        if (!(dataSource instanceof TransactionAwareDataSourceProxy)) {
            this.dataSource = new TransactionAwareDataSourceProxy(dataSource);
        }
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setConvertersByName(Map convertersByName) {
        this.convertersByName = convertersByName;
    }

    public void setCompassConfiguration(CompassConfiguration config) {
        this.config = config;
    }

    public void afterPropertiesSet() throws Exception {
        String compassTransactionFactory;
        int i;
        CompassConfiguration config = this.config;
        if (config == null) {
            config = this.newConfiguration();
        }
        if (this.configLocation != null) {
            config.configure(this.configLocation.getURL());
        }
        if (this.configLocations != null) {
            for (i = 0; i < this.configLocations.length; ++i) {
                config.configure(this.configLocations[i].getURL());
            }
        }
        if (this.compassSettings != null) {
            config.getSettings().addSettings(this.compassSettings);
        }
        if (this.resourceLocations != null) {
            for (i = 0; i < this.resourceLocations.length; ++i) {
                config.addInputStream(this.resourceLocations[i].getInputStream(), this.resourceLocations[i].getDescription());
            }
        }
        if (this.resourceJarLocations != null) {
            for (i = 0; i < this.resourceJarLocations.length; ++i) {
                config.addJar(this.resourceJarLocations[i].getFile());
            }
        }
        if (this.classMappings != null) {
            for (i = 0; i < this.classMappings.length; ++i) {
                config.addClass(ClassUtils.forName(this.classMappings[i]));
            }
        }
        if (this.resourceDirectoryLocations != null) {
            for (i = 0; i < this.resourceDirectoryLocations.length; ++i) {
                File file = this.resourceDirectoryLocations[i].getFile();
                if (!file.isDirectory()) {
                    throw new IllegalArgumentException("Resource directory location [" + this.resourceDirectoryLocations[i] + "] does not denote a directory");
                }
                config.addDirectory(file);
            }
        }
        if (this.mappingResolvers != null) {
            for (i = 0; i < this.mappingResolvers.length; ++i) {
                config.addMappingResover(this.mappingResolvers[i]);
            }
        }
        if (this.dataSource != null) {
            ExternalDataSourceProvider.setDataSource(this.dataSource);
            if (config.getSettings().getSetting("compass.engine.store.jdbc.connection.provider.class") == null) {
                config.getSettings().setSetting("compass.engine.store.jdbc.connection.provider.class", ExternalDataSourceProvider.class.getName());
            }
        }
        if ((compassTransactionFactory = config.getSettings().getSetting("compass.transaction.factory")) == null && this.transactionManager != null) {
            config.getSettings().setSetting("compass.transaction.factory", SpringSyncTransactionFactory.class.getName());
        }
        if (compassTransactionFactory != null && compassTransactionFactory.equals(SpringSyncTransactionFactory.class.getName()) && this.transactionManager == null) {
            throw new IllegalArgumentException("When using SpringSyncTransactionFactory the transactionManager property must be set");
        }
        SpringSyncTransactionFactory.setTransactionManager(this.transactionManager);
        if (this.convertersByName != null) {
            Iterator it = this.convertersByName.keySet().iterator();
            while (it.hasNext()) {
                String converterName = (String)it.next();
                config.registerConverter(converterName, (Converter)this.convertersByName.get(converterName));
            }
        }
        if (config.getSettings().getSetting("compass.name") == null) {
            config.getSettings().setSetting("compass.name", this.beanName);
        }
        if (config.getSettings().getSetting("compass.engine.connection") == null && this.connection != null) {
            config.getSettings().setSetting("compass.engine.connection", this.connection.getFile().getAbsolutePath());
        }
        if (this.postProcessor != null) {
            this.postProcessor.process(config);
        }
        this.compass = this.newCompass(config);
        this.compass = (Compass)Proxy.newProxyInstance(SpringCompassInvocationHandler.class.getClassLoader(), new Class[]{InternalCompass.class}, (InvocationHandler)new SpringCompassInvocationHandler(this.compass));
    }

    protected CompassConfiguration newConfiguration() {
        return CompassConfigurationFactory.newConfiguration();
    }

    protected Compass newCompass(CompassConfiguration config) throws CompassException {
        return config.buildCompass();
    }

    public Object getObject() throws Exception {
        return this.compass;
    }

    public Class getObjectType() {
        return this.compass != null ? this.compass.getClass() : Compass.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        this.compass.close();
    }

    private class SpringCompassInvocationHandler
    implements InvocationHandler {
        private static final String GET_TARGET_COMPASS_METHOD_NAME = "getTargetCompass";
        private static final String CLONE_METHOD = "clone";
        private Compass targetCompass;

        public SpringCompassInvocationHandler(Compass targetCompass) {
            this.targetCompass = targetCompass;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals(GET_TARGET_COMPASS_METHOD_NAME)) {
                return LocalCompassBean.this.compass;
            }
            if (method.getName().equals(CLONE_METHOD) && args.length == 1) {
                if (LocalCompassBean.this.dataSource != null) {
                    ExternalDataSourceProvider.setDataSource(LocalCompassBean.this.dataSource);
                }
                SpringSyncTransactionFactory.setTransactionManager(LocalCompassBean.this.transactionManager);
            }
            try {
                return method.invoke((Object)this.targetCompass, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

