/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.api.JackrabbitNodeTypeManager;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.test.RepositoryStub;
import org.apache.jackrabbit.test.RepositoryStubException;

public class JackrabbitRepositoryStub
extends RepositoryStub {
    public static final String PROP_REPOSITORY_CONFIG = "org.apache.jackrabbit.repository.config";
    public static final String PROP_REPOSITORY_HOME = "org.apache.jackrabbit.repository.home";
    private static final String ENCODING = "UTF-8";
    private final Properties settings;
    private Repository repository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getStaticProperties() {
        Properties properties = new Properties();
        try {
            InputStream stream = JackrabbitRepositoryStub.getResource("JackrabbitRepositoryStub.properties");
            try {
                properties.load(stream);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    private static InputStream getResource(String name) {
        return JackrabbitRepositoryStub.class.getResourceAsStream(name);
    }

    public JackrabbitRepositoryStub(Properties settings) {
        super(JackrabbitRepositoryStub.getStaticProperties());
        this.superuser.setAttribute("jackrabbit", (Object)"jackrabbit");
        this.readwrite.setAttribute("jackrabbit", (Object)"jackrabbit");
        this.readonly.setAttribute("jackrabbit", (Object)"jackrabbit");
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Repository getRepository() throws RepositoryStubException {
        if (this.repository == null) {
            try {
                String dir = this.settings.getProperty(PROP_REPOSITORY_HOME);
                if (dir == null) {
                    dir = new File("target", "repository").getPath();
                }
                new File(dir).mkdirs();
                String xml = this.settings.getProperty(PROP_REPOSITORY_CONFIG);
                if (xml == null) {
                    xml = new File(dir, "repository.xml").getPath();
                }
                if (!new File(xml).exists()) {
                    InputStream input = JackrabbitRepositoryStub.getResource("repository.xml");
                    try {
                        FileOutputStream output = new FileOutputStream(xml);
                        try {
                            IOUtils.copy((InputStream)input, (OutputStream)output);
                        }
                        finally {
                            ((OutputStream)output).close();
                        }
                    }
                    finally {
                        input.close();
                    }
                }
                RepositoryConfig config = RepositoryConfig.create(xml, dir);
                this.repository = RepositoryImpl.create(config);
                Session session = this.repository.login((Credentials)this.superuser);
                try {
                    this.prepareTestContent(session);
                }
                finally {
                    session.logout();
                }
            }
            catch (Exception e) {
                RepositoryStubException exception = new RepositoryStubException("Failed to start repository");
                exception.initCause((Throwable)e);
                throw exception;
            }
        }
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareTestContent(Session session) throws RepositoryException, IOException {
        JackrabbitNodeTypeManager manager;
        JackrabbitWorkspace workspace = (JackrabbitWorkspace)session.getWorkspace();
        HashSet<String> workspaces = new HashSet<String>(Arrays.asList(workspace.getAccessibleWorkspaceNames()));
        if (!workspaces.contains("test")) {
            workspace.createWorkspace("test");
        }
        if (!(manager = (JackrabbitNodeTypeManager)workspace.getNodeTypeManager()).hasNodeType("test:versionable")) {
            InputStream xml = JackrabbitRepositoryStub.getResource("test-nodetypes.xml");
            try {
                manager.registerNodeTypes(xml, "text/xml");
            }
            finally {
                xml.close();
            }
        }
        Node data = this.getOrAddNode(session.getRootNode(), "testdata");
        this.addPropertyTestData(this.getOrAddNode(data, "property"));
        this.addQueryTestData(this.getOrAddNode(data, "query"));
        this.addNodeTestData(this.getOrAddNode(data, "node"));
        this.addExportTestData(this.getOrAddNode(data, "docViewTest"));
        session.save();
    }

    private Node getOrAddNode(Node node, String name) throws RepositoryException {
        try {
            return node.getNode(name);
        }
        catch (PathNotFoundException e) {
            return node.addNode(name);
        }
    }

    private void addPropertyTestData(Node node) throws RepositoryException {
        node.setProperty("boolean", true);
        node.setProperty("double", Math.PI);
        node.setProperty("long", 90834953485278298L);
        Calendar c = Calendar.getInstance();
        c.set(2005, 6, 18, 17, 30);
        node.setProperty("calendar", c);
        ValueFactory factory = node.getSession().getValueFactory();
        node.setProperty("path", factory.createValue("/", 8));
        node.setProperty("multi", new String[]{"one", "two", "three"});
    }

    private void addQueryTestData(Node node) throws RepositoryException {
        while (node.hasNode("node1")) {
            node.getNode("node1").remove();
        }
        this.getOrAddNode(node, "node1").setProperty("prop1", "You can have it good, cheap, or fast. Any two.");
        this.getOrAddNode(node, "node1").setProperty("prop1", "foo bar");
        this.getOrAddNode(node, "node1").setProperty("prop1", "Hello world!");
        this.getOrAddNode(node, "node2").setProperty("prop1", "Apache Jackrabbit");
    }

    private void addNodeTestData(Node node) throws RepositoryException, IOException {
        if (node.hasNode("multiReference")) {
            node.getNode("multiReference").remove();
        }
        if (node.hasNode("resReference")) {
            node.getNode("resReference").remove();
        }
        if (node.hasNode("myResource")) {
            node.getNode("myResource").remove();
        }
        Node resource = node.addNode("myResource", "nt:resource");
        resource.setProperty("jcr:encoding", ENCODING);
        resource.setProperty("jcr:mimeType", "text/plain");
        resource.setProperty("jcr:data", (InputStream)new ByteArrayInputStream("Hello w\u00f6rld.".getBytes(ENCODING)));
        resource.setProperty("jcr:lastModified", Calendar.getInstance());
        Node resReference = this.getOrAddNode(node, "reference");
        resReference.setProperty("ref", resource);
        resReference.addMixin("mix:referenceable");
        Node multiReference = node.addNode("multiReference");
        ValueFactory factory = node.getSession().getValueFactory();
        multiReference.setProperty("ref", new Value[]{factory.createValue(resource), factory.createValue(resReference)});
    }

    private void addExportTestData(Node node) throws RepositoryException, IOException {
        this.getOrAddNode(node, "invalidXmlName").setProperty("propName", "some text");
        this.getOrAddNode(node, "jcr:xmltext").setProperty("jcr:xmlcharacters", "A text without any special character.");
        this.getOrAddNode(node, "some-element");
        this.getOrAddNode(node, "jcr:xmltext").setProperty("jcr:xmlcharacters", " The entity reference characters: <, ', ,&, >,  \" should be escaped in xml export. ");
        this.getOrAddNode(node, "some-element");
        this.getOrAddNode(node, "jcr:xmltext").setProperty("jcr:xmlcharacters", "A text without any special character.");
        Node big = this.getOrAddNode(node, "bigNode");
        big.setProperty("propName0", "SGVsbG8gd8O2cmxkLg==;SGVsbG8gd8O2cmxkLg==".split(";"), 2);
        big.setProperty("propName1", "text 1");
        big.setProperty("propName2", "multival text 1;multival text 2;multival text 3".split(";"));
        big.setProperty("propName3", "text 1");
        this.addExportValues(node, "propName");
        this.addExportValues(node, "Prop<>prop");
    }

    private void addExportValues(Node node, String name) throws RepositoryException, IOException {
        String prefix = "valid";
        if (name.indexOf(60) != -1) {
            prefix = "invalid";
        }
        node = this.getOrAddNode(node, prefix + "Names");
        String[] texts = new String[]{"multival text 1", "multival text 2", "multival text 3"};
        this.getOrAddNode(node, prefix + "MultiNoBin").setProperty(name, texts);
        Node resource = this.getOrAddNode(node, prefix + "MultiBin");
        resource.setProperty("jcr:encoding", ENCODING);
        resource.setProperty("jcr:mimeType", "text/plain");
        String[] values = new String[]{"SGVsbG8gd8O2cmxkLg==", "SGVsbG8gd8O2cmxkLg=="};
        resource.setProperty(name, values, 2);
        resource.setProperty("jcr:lastModified", Calendar.getInstance());
        this.getOrAddNode(node, prefix + "NoBin").setProperty(name, "text 1");
        resource = this.getOrAddNode(node, "invalidBin");
        resource.setProperty("jcr:encoding", ENCODING);
        resource.setProperty("jcr:mimeType", "text/plain");
        byte[] bytes = "Hello w\u00f6rld.".getBytes(ENCODING);
        resource.setProperty(name, (InputStream)new ByteArrayInputStream(bytes));
        resource.setProperty("jcr:lastModified", Calendar.getInstance());
    }
}

