/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.persistence.PersistenceCopier;
import org.apache.jackrabbit.spi.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryCopier {
    private static final Logger logger = LoggerFactory.getLogger((Class)RepositoryCopier.class);
    private final RepositoryImpl source;
    private final RepositoryImpl target;

    public static void copy(File source, File target) throws RepositoryException, IOException {
        RepositoryCopier.copy(RepositoryConfig.create(source), RepositoryConfig.install(target));
    }

    public static void copy(RepositoryConfig source, File target) throws RepositoryException, IOException {
        RepositoryCopier.copy(source, RepositoryConfig.install(target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(RepositoryConfig source, RepositoryConfig target) throws RepositoryException {
        RepositoryImpl repository = RepositoryImpl.create(source);
        try {
            RepositoryCopier.copy(repository, target);
        }
        finally {
            repository.shutdown();
        }
    }

    public static void copy(RepositoryImpl source, File target) throws RepositoryException, IOException {
        RepositoryCopier.copy(source, RepositoryConfig.install(target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(RepositoryImpl source, RepositoryConfig target) throws RepositoryException {
        RepositoryImpl repository = RepositoryImpl.create(target);
        try {
            new RepositoryCopier(source, repository).copy();
        }
        finally {
            repository.shutdown();
        }
        File targetDir = new File(target.getHomeDir());
        File repoDir = new File(targetDir, "repository");
        FileUtils.deleteQuietly((File)new File(repoDir, "index"));
        File[] workspaces = new File(targetDir, "workspaces").listFiles();
        if (workspaces != null) {
            for (int i = 0; i < workspaces.length; ++i) {
                FileUtils.deleteQuietly((File)new File(workspaces[i], "index"));
            }
        }
    }

    public RepositoryCopier(RepositoryImpl source, RepositoryImpl target) {
        this.source = source;
        this.target = target;
    }

    public void copy() throws RepositoryException {
        logger.info("Copying repository content from {} to {}", (Object)this.source.repConfig.getHomeDir(), (Object)this.target.repConfig.getHomeDir());
        try {
            this.copyNamespaces();
            this.copyNodeTypes();
            this.copyVersionStore();
            this.copyWorkspaces();
        }
        catch (Exception e) {
            throw new RepositoryException("Failed to copy content", (Throwable)e);
        }
    }

    private void copyNamespaces() throws RepositoryException {
        NamespaceRegistryImpl sourceRegistry = this.source.getNamespaceRegistry();
        NamespaceRegistryImpl targetRegistry = this.target.getNamespaceRegistry();
        logger.info("Copying registered namespaces");
        List<String> existing = Arrays.asList(targetRegistry.getURIs());
        String[] uris = sourceRegistry.getURIs();
        for (int i = 0; i < uris.length; ++i) {
            if (existing.contains(uris[i])) continue;
            targetRegistry.registerNamespace(sourceRegistry.getPrefix(uris[i]), uris[i]);
        }
    }

    private void copyNodeTypes() throws RepositoryException {
        NodeTypeRegistry sourceRegistry = this.source.getNodeTypeRegistry();
        NodeTypeRegistry targetRegistry = this.target.getNodeTypeRegistry();
        logger.info("Copying registered node types");
        List<Name> existing = Arrays.asList(targetRegistry.getRegisteredNodeTypes());
        ArrayList<NodeTypeDef> register = new ArrayList<NodeTypeDef>();
        Name[] names = sourceRegistry.getRegisteredNodeTypes();
        for (int i = 0; i < names.length; ++i) {
            if (existing.contains(names[i])) continue;
            register.add(sourceRegistry.getNodeTypeDef(names[i]));
        }
        try {
            targetRegistry.registerNodeTypes(register);
        }
        catch (InvalidNodeTypeDefException e) {
            throw new RepositoryException("Unable to copy node types", (Throwable)e);
        }
    }

    private void copyVersionStore() throws RepositoryException {
        logger.info("Copying version histories");
        PersistenceCopier copier = new PersistenceCopier(this.source.getVersionManagerImpl().getPersistenceManager(), this.target.getVersionManagerImpl().getPersistenceManager(), this.target.getDataStore());
        copier.copy(RepositoryImpl.VERSION_STORAGE_NODE_ID);
    }

    private void copyWorkspaces() throws RepositoryException {
        List<String> existing = Arrays.asList(this.target.getWorkspaceNames());
        String[] names = this.source.getWorkspaceNames();
        for (int i = 0; i < names.length; ++i) {
            logger.info("Copying workspace {}", (Object)names[i]);
            if (!existing.contains(names[i])) {
                this.target.createWorkspace(names[i]);
            }
            PersistenceCopier copier = new PersistenceCopier(this.source.getWorkspaceInfo(names[i]).getPersistenceManager(), this.target.getWorkspaceInfo(names[i]).getPersistenceManager(), this.target.getDataStore());
            copier.excludeNode(RepositoryImpl.SYSTEM_ROOT_NODE_ID);
            copier.copy(RepositoryImpl.ROOT_NODE_ID);
        }
    }
}

