/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.join.AbstractCondition;
import org.apache.jackrabbit.core.query.lucene.join.ScoreNodeMap;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.index.IndexReader;

public class AncestorNodeJoin
extends AbstractCondition {
    private final ScoreNodeMap contextIndex = new ScoreNodeMap();
    private final IndexReader reader;
    private final HierarchyResolver resolver;
    private int[] docNums = new int[1];
    private final List ancestors = new ArrayList();

    public AncestorNodeJoin(MultiColumnQueryHits context, Name contextSelectorName, IndexReader reader, HierarchyResolver resolver) throws IOException {
        super(context);
        ScoreNode[] nodes;
        this.reader = reader;
        this.resolver = resolver;
        int idx = AncestorNodeJoin.getIndex(context, contextSelectorName);
        while ((nodes = context.nextScoreNodes()) != null) {
            Integer docNum = new Integer(nodes[idx].getDoc(reader));
            this.ancestors.clear();
            this.collectAncestors(docNum);
            for (int i = 0; i < this.ancestors.size(); ++i) {
                Integer doc = (Integer)this.ancestors.get(i);
                this.contextIndex.addScoreNodes(doc, nodes);
            }
        }
    }

    public ScoreNode[][] getMatchingScoreNodes(ScoreNode ancestor) throws IOException {
        Integer doc = new Integer(ancestor.getDoc(this.reader));
        return this.contextIndex.getScoreNodes(doc);
    }

    private void collectAncestors(int doc) throws IOException {
        this.docNums = this.resolver.getParents(doc, this.docNums);
        if (this.docNums.length == 1) {
            this.ancestors.add(new Integer(this.docNums[0]));
            this.collectAncestors(this.docNums[0]);
        } else if (this.docNums.length > 1) {
            int[] tmp = (int[])this.docNums.clone();
            for (int i = 0; i < tmp.length; ++i) {
                this.ancestors.add(new Integer(tmp[i]));
                this.collectAncestors(tmp[i]);
            }
        }
    }
}

