/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.util.EmptyLinkedMap;
import org.apache.jackrabbit.spi.Name;

class ChildNodeEntries
implements List,
Cloneable {
    private LinkedMap entries;
    private Map nameMap;
    private boolean shared;

    ChildNodeEntries() {
        this.init();
    }

    ChildNodeEntry get(NodeId id) {
        return (ChildNodeEntry)this.entries.get((Object)id);
    }

    List get(Name nodeName) {
        Object obj = this.nameMap.get(nodeName);
        if (obj == null) {
            return Collections.EMPTY_LIST;
        }
        if (obj instanceof ArrayList) {
            return Collections.unmodifiableList((ArrayList)obj);
        }
        return Collections.singletonList(obj);
    }

    ChildNodeEntry get(Name nodeName, int index) {
        if (index < 1) {
            throw new IllegalArgumentException("index is 1-based");
        }
        Object obj = this.nameMap.get(nodeName);
        if (obj == null) {
            return null;
        }
        if (obj instanceof ArrayList) {
            ArrayList siblings = (ArrayList)obj;
            if (index <= siblings.size()) {
                return (ChildNodeEntry)siblings.get(index - 1);
            }
        } else if (index == 1) {
            return (ChildNodeEntry)obj;
        }
        return null;
    }

    ChildNodeEntry add(Name nodeName, NodeId id) {
        this.ensureModifiable();
        ArrayList<Object> siblings = null;
        int index = 0;
        Object obj = this.nameMap.get(nodeName);
        if (obj != null) {
            if (obj instanceof ArrayList) {
                siblings = (ArrayList<Object>)obj;
                if (siblings.size() > 0) {
                    nodeName = ((ChildNodeEntry)siblings.get(0)).getName();
                }
            } else {
                siblings = new ArrayList<Object>();
                siblings.add(obj);
                this.nameMap.put(nodeName, siblings);
            }
            index = siblings.size();
        }
        ChildNodeEntry entry = new ChildNodeEntry(nodeName, id, ++index);
        if (siblings != null) {
            siblings.add(entry);
        } else {
            this.nameMap.put(nodeName, entry);
        }
        this.entries.put((Object)id, (Object)entry);
        return entry;
    }

    void addAll(List entriesList) {
        Iterator iter = entriesList.iterator();
        while (iter.hasNext()) {
            ChildNodeEntry entry = (ChildNodeEntry)iter.next();
            this.add(entry.getName(), entry.getId());
        }
    }

    public ChildNodeEntry remove(Name nodeName, int index) {
        if (index < 1) {
            throw new IllegalArgumentException("index is 1-based");
        }
        this.ensureModifiable();
        Object obj = this.nameMap.get(nodeName);
        if (obj == null) {
            return null;
        }
        if (obj instanceof ChildNodeEntry) {
            if (index != 1) {
                return null;
            }
            ChildNodeEntry removedEntry = (ChildNodeEntry)obj;
            this.nameMap.remove(nodeName);
            this.entries.remove((Object)removedEntry.getId());
            return removedEntry;
        }
        ArrayList siblings = (ArrayList)obj;
        if (index > siblings.size()) {
            return null;
        }
        ChildNodeEntry removedEntry = (ChildNodeEntry)siblings.remove(index - 1);
        this.entries.remove((Object)removedEntry.getId());
        for (int i = index - 1; i < siblings.size(); ++i) {
            ChildNodeEntry oldEntry = (ChildNodeEntry)siblings.get(i);
            ChildNodeEntry newEntry = new ChildNodeEntry(nodeName, oldEntry.getId(), oldEntry.getIndex() - 1);
            siblings.set(i, newEntry);
            this.entries.put((Object)newEntry.getId(), (Object)newEntry);
        }
        if (siblings.size() == 0) {
            this.nameMap.remove(nodeName);
        } else if (siblings.size() == 1) {
            this.nameMap.put(nodeName, siblings.get(0));
        }
        return removedEntry;
    }

    ChildNodeEntry remove(NodeId id) {
        ChildNodeEntry entry = (ChildNodeEntry)this.entries.get((Object)id);
        if (entry != null) {
            return this.remove(entry.getName(), entry.getIndex());
        }
        return entry;
    }

    public ChildNodeEntry remove(ChildNodeEntry entry) {
        return this.remove(entry.getName(), entry.getIndex());
    }

    public void removeAll() {
        this.init();
    }

    List removeAll(ChildNodeEntries other) {
        if (this.entries.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (other.isEmpty()) {
            return this;
        }
        ArrayList<ChildNodeEntry> result = new ArrayList<ChildNodeEntry>();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ChildNodeEntry otherEntry;
            ChildNodeEntry entry = (ChildNodeEntry)iter.next();
            if (entry == (otherEntry = other.get(entry.getId())) || otherEntry != null && entry.getName().equals(otherEntry.getName())) continue;
            result.add(entry);
        }
        return result;
    }

    List retainAll(ChildNodeEntries other) {
        if (this.entries.isEmpty() || other.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ChildNodeEntry> result = new ArrayList<ChildNodeEntry>();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ChildNodeEntry otherEntry;
            ChildNodeEntry entry = (ChildNodeEntry)iter.next();
            if (entry == (otherEntry = other.get(entry.getId()))) {
                result.add(entry);
                continue;
            }
            if (otherEntry == null || !entry.getName().equals(otherEntry.getName())) continue;
            result.add(entry);
        }
        return result;
    }

    public boolean contains(Object o) {
        if (o instanceof ChildNodeEntry) {
            return this.entries.containsKey((Object)((ChildNodeEntry)o).getId());
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public Object get(int index) {
        return this.entries.getValue(index);
    }

    public int indexOf(Object o) {
        if (o instanceof ChildNodeEntry) {
            return this.entries.indexOf((Object)((ChildNodeEntry)o).getId());
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    public Iterator iterator() {
        return new EntriesIterator();
    }

    public ListIterator listIterator() {
        return new EntriesIterator();
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index >= this.entries.size()) {
            throw new IndexOutOfBoundsException();
        }
        EntriesIterator iter = new EntriesIterator();
        while (index-- > 0) {
            iter.next();
        }
        return iter;
    }

    public int size() {
        return this.entries.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return Collections.unmodifiableList(new ArrayList(this).subList(fromIndex, toIndex));
    }

    public Object[] toArray() {
        Object[] array = new ChildNodeEntry[this.size()];
        return this.toArray(array);
    }

    public Object[] toArray(Object[] a) {
        if (!a.getClass().getComponentType().isAssignableFrom(ChildNodeEntry.class)) {
            throw new ArrayStoreException();
        }
        if (a.length < this.size()) {
            a = new ChildNodeEntry[this.size()];
        }
        MapIterator iter = this.entries.mapIterator();
        int i = 0;
        while (iter.hasNext()) {
            iter.next();
            a[i] = this.entries.getValue(i);
            ++i;
        }
        while (i < a.length) {
            a[i++] = null;
        }
        return a;
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChildNodeEntries) {
            ChildNodeEntries other = (ChildNodeEntries)obj;
            return ((Object)this.nameMap).equals(other.nameMap) && this.entries.equals((Object)other.entries) && this.shared == other.shared;
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    protected Object clone() {
        try {
            ChildNodeEntries clone = (ChildNodeEntries)super.clone();
            if (this.nameMap != Collections.EMPTY_MAP) {
                clone.shared = true;
                this.shared = true;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private void init() {
        this.nameMap = Collections.EMPTY_MAP;
        this.entries = EmptyLinkedMap.INSTANCE;
        this.shared = false;
    }

    private void ensureModifiable() {
        if (this.nameMap == Collections.EMPTY_MAP) {
            this.nameMap = new HashMap();
            this.entries = new LinkedMap();
        } else if (this.shared) {
            this.entries = (LinkedMap)this.entries.clone();
            this.nameMap = (Map)((HashMap)this.nameMap).clone();
            Iterator it = this.nameMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object value = entry.getValue();
                if (!(value instanceof ArrayList)) continue;
                entry.setValue(((ArrayList)value).clone());
            }
            this.shared = false;
        }
    }

    class EntriesIterator
    implements ListIterator {
        private final OrderedMapIterator mapIter;

        EntriesIterator() {
            this.mapIter = ChildNodeEntries.this.entries.orderedMapIterator();
        }

        public boolean hasNext() {
            return this.mapIter.hasNext();
        }

        public Object next() {
            this.mapIter.next();
            return this.mapIter.getValue();
        }

        public boolean hasPrevious() {
            return this.mapIter.hasPrevious();
        }

        public int nextIndex() {
            return ChildNodeEntries.this.entries.indexOf(this.mapIter.getKey()) + 1;
        }

        public Object previous() {
            this.mapIter.previous();
            return this.mapIter.getValue();
        }

        public int previousIndex() {
            return ChildNodeEntries.this.entries.indexOf(this.mapIter.getKey()) - 1;
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

