/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.cluster.UpdateEventListener;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.observation.DelegatingObservationDispatcher;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.AbstractVersionManager;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionHistoryImpl;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionHistoryImpl;
import org.apache.jackrabbit.core.version.VersionHistoryInfo;
import org.apache.jackrabbit.core.version.VersionImpl;
import org.apache.jackrabbit.core.version.VersionItemStateManager;
import org.apache.jackrabbit.core.version.VersionItemStateProvider;
import org.apache.jackrabbit.core.version.VersionManager;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionManagerImpl
extends AbstractVersionManager
implements ItemStateListener,
UpdateEventListener {
    private static Logger log = LoggerFactory.getLogger((Class)VersionManager.class);
    private static final Path VERSION_STORAGE_PATH;
    private final PersistenceManager pMgr;
    private final FileSystem fs;
    private VersionItemStateManager sharedStateMgr;
    private final VersionItemStateProvider versProvider;
    private final DynamicESCFactory escFactory;
    private final ReferenceMap versionItems = new ReferenceMap(0, 2);

    public VersionManagerImpl(PersistenceManager pMgr, FileSystem fs, NodeTypeRegistry ntReg, DelegatingObservationDispatcher obsMgr, NodeId rootId, NodeId rootParentId, ItemStateCacheFactory cacheFactory, ISMLocking ismLocking) throws RepositoryException {
        super(ntReg);
        try {
            this.pMgr = pMgr;
            this.fs = fs;
            this.escFactory = new DynamicESCFactory(obsMgr);
            if (!pMgr.exists(rootId)) {
                NodeState root = pMgr.createNew(rootId);
                root.setParentId(rootParentId);
                root.setDefinitionId(ntReg.getEffectiveNodeType(NameConstants.REP_SYSTEM).getApplicableChildNodeDef(NameConstants.JCR_VERSIONSTORAGE, NameConstants.REP_VERSIONSTORAGE, ntReg).getId());
                root.setNodeTypeName(NameConstants.REP_VERSIONSTORAGE);
                PropertyState pt = pMgr.createNew(new PropertyId(rootId, NameConstants.JCR_PRIMARYTYPE));
                pt.setDefinitionId(ntReg.getEffectiveNodeType(NameConstants.REP_SYSTEM).getApplicablePropertyDef(NameConstants.JCR_PRIMARYTYPE, 7, false).getId());
                pt.setMultiValued(false);
                pt.setType(7);
                pt.setValues(new InternalValue[]{InternalValue.create(NameConstants.REP_VERSIONSTORAGE)});
                root.addPropertyName(pt.getName());
                ChangeLog cl = new ChangeLog();
                cl.added(root);
                cl.added(pt);
                pMgr.store(cl);
            }
            this.sharedStateMgr = this.createItemStateManager(pMgr, rootId, ntReg, cacheFactory, ismLocking);
            this.stateMgr = LocalItemStateManager.createInstance(this.sharedStateMgr, this.escFactory, cacheFactory);
            this.stateMgr.addListener(this);
            NodeState nodeState = (NodeState)this.stateMgr.getItemState(rootId);
            this.historyRoot = new NodeStateEx(this.stateMgr, ntReg, nodeState, NameConstants.JCR_VERSIONSTORAGE);
            this.versProvider = new VersionItemStateProvider(this.getHistoryRootId(), this.sharedStateMgr);
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public VirtualItemStateProvider getVirtualItemStateProvider() {
        return this.versProvider;
    }

    public PersistenceManager getPersistenceManager() {
        return this.pMgr;
    }

    public void close() throws Exception {
        this.pMgr.close();
        this.fs.close();
    }

    public DynamicESCFactory getEscFactory() {
        return this.escFactory;
    }

    protected VersionHistoryInfo createVersionHistory(Session session, final NodeState node) throws RepositoryException {
        NodeStateEx state = (NodeStateEx)this.escFactory.doSourced((SessionImpl)session, new SourcedTarget(){

            public Object run() throws RepositoryException {
                return VersionManagerImpl.this.createVersionHistory(node);
            }
        });
        if (state == null) {
            throw new VersionException("History already exists for node " + node.getNodeId());
        }
        Name root = NameConstants.JCR_ROOTVERSION;
        return new VersionHistoryInfo(state.getNodeId(), state.getState().getChildNodeEntry(root, 1).getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasItem(NodeId id) {
        ISMLocking.ReadLock lock = this.acquireReadLock();
        try {
            boolean bl = this.stateMgr.hasItemState(id);
            return bl;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InternalVersionItem getItem(NodeId id) throws RepositoryException {
        InternalVersionItem internalVersionItem;
        if (id.equals(this.getHistoryRootId())) {
            return null;
        }
        ISMLocking.ReadLock lock = this.acquireReadLock();
        try {
            ReferenceMap referenceMap = this.versionItems;
            synchronized (referenceMap) {
                InternalVersionItem item = (InternalVersionItem)this.versionItems.get((Object)id);
                if (item == null) {
                    item = this.createInternalVersionItem(id);
                    if (item == null) {
                        InternalVersionItem internalVersionItem2 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 6, 7] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                        lock.release();
                        return internalVersionItem2;
                    }
                    this.versionItems.put((Object)id, (Object)item);
                }
                internalVersionItem = item;
            }
        }
        catch (Throwable throwable) {
            lock.release();
            throw throwable;
        }
        lock.release();
        return internalVersionItem;
    }

    public Version checkin(final NodeImpl node, final Calendar cal) throws RepositoryException {
        InternalVersion version = (InternalVersion)this.escFactory.doSourced((SessionImpl)node.getSession(), new SourcedTarget(){

            public Object run() throws RepositoryException {
                if (node.isNodeType(NameConstants.MIX_VERSIONABLE)) {
                    String histUUID = node.getProperty(NameConstants.JCR_VERSIONHISTORY).getString();
                    InternalVersionHistory vh = VersionManagerImpl.this.getVersionHistory(NodeId.valueOf(histUUID));
                    return VersionManagerImpl.this.checkin((InternalVersionHistoryImpl)vh, node, false, cal);
                }
                InternalVersionHistory vh = VersionManagerImpl.this.getVersionHistoryOfNode(node.getNodeId());
                return VersionManagerImpl.this.checkin((InternalVersionHistoryImpl)vh, node, true, cal);
            }
        });
        return (VersionImpl)((SessionImpl)node.getSession()).getNodeById(version.getId());
    }

    public void removeVersion(VersionHistory history, final Name name) throws VersionException, RepositoryException {
        final VersionHistoryImpl historyImpl = (VersionHistoryImpl)history;
        if (!historyImpl.hasNode(name)) {
            throw new VersionException("Version with name " + name.toString() + " does not exist in this VersionHistory");
        }
        this.escFactory.doSourced((SessionImpl)history.getSession(), new SourcedTarget(){

            public Object run() throws RepositoryException {
                InternalVersionHistoryImpl vh = (InternalVersionHistoryImpl)historyImpl.getInternalVersionHistory();
                VersionManagerImpl.this.removeVersion(vh, name);
                return null;
            }
        });
    }

    public Version setVersionLabel(final VersionHistory history, final Name version, final Name label, final boolean move) throws RepositoryException {
        InternalVersion v = (InternalVersion)this.escFactory.doSourced((SessionImpl)history.getSession(), new SourcedTarget(){

            public Object run() throws RepositoryException {
                InternalVersionHistoryImpl vh = (InternalVersionHistoryImpl)((VersionHistoryImpl)history).getInternalVersionHistory();
                return VersionManagerImpl.this.setVersionLabel(vh, version, label, move);
            }
        });
        if (v == null) {
            return null;
        }
        return (Version)((SessionImpl)history.getSession()).getNodeByUUID(v.getId().getUUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemsUpdated(Collection items) {
        ISMLocking.ReadLock lock = this.acquireReadLock();
        try {
            ReferenceMap referenceMap = this.versionItems;
            synchronized (referenceMap) {
                Iterator iter = items.iterator();
                while (iter.hasNext()) {
                    InternalVersionItem item = (InternalVersionItem)iter.next();
                    InternalVersionItem cached = (InternalVersionItem)this.versionItems.remove((Object)item.getId());
                    if (cached == null || !(cached instanceof InternalVersionHistoryImpl)) continue;
                    InternalVersionHistoryImpl vh = (InternalVersionHistoryImpl)cached;
                    try {
                        vh.reload();
                        this.versionItems.put((Object)vh.getId(), (Object)vh);
                    }
                    catch (RepositoryException e) {
                        log.warn("Unable to update version history: " + e.toString());
                    }
                }
            }
        }
        finally {
            lock.release();
        }
    }

    public void setEventChannel(UpdateEventChannel eventChannel) {
        this.sharedStateMgr.setEventChannel(eventChannel);
        eventChannel.setListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemDiscarded(InternalVersionItem item) {
        ISMLocking.ReadLock lock = this.acquireReadLock();
        try {
            this.versionItems.remove((Object)item.getId());
        }
        finally {
            lock.release();
        }
    }

    protected boolean hasItemReferences(NodeId id) throws RepositoryException {
        return this.stateMgr.hasNodeReferences(new NodeReferencesId(id));
    }

    protected NodeStateEx getNodeStateEx(NodeId parentNodeId) throws RepositoryException {
        try {
            NodeState state = (NodeState)this.stateMgr.getItemState(parentNodeId);
            return new NodeStateEx(this.stateMgr, this.ntReg, state, null);
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    NodeId getHistoryRootId() {
        return this.historyRoot.getState().getNodeId();
    }

    protected SharedItemStateManager getSharedStateMgr() {
        return this.sharedStateMgr;
    }

    protected VersionItemStateManager createItemStateManager(PersistenceManager pMgr, NodeId rootId, NodeTypeRegistry ntReg, ItemStateCacheFactory cacheFactory, ISMLocking ismLocking) throws ItemStateException {
        return new VersionItemStateManager(pMgr, rootId, ntReg, cacheFactory, ismLocking);
    }

    public void stateCreated(ItemState created) {
    }

    public void stateModified(ItemState modified) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateDestroyed(ItemState destroyed) {
        ISMLocking.ReadLock lock = this.acquireReadLock();
        try {
            this.versionItems.remove((Object)destroyed.getId());
        }
        finally {
            lock.release();
        }
    }

    public void stateDiscarded(ItemState discarded) {
    }

    public void externalUpdate(ChangeLog changes, List events, long timestamp, String userData) throws RepositoryException {
        EventStateCollection esc = this.getEscFactory().createEventStateCollection(null);
        esc.addAll(events);
        esc.setTimestamp(timestamp);
        esc.setUserData(userData);
        this.sharedStateMgr.externalUpdate(changes, esc);
    }

    static {
        try {
            PathBuilder builder = new PathBuilder();
            builder.addRoot();
            builder.addLast(NameConstants.JCR_SYSTEM);
            builder.addLast(NameConstants.JCR_VERSIONSTORAGE);
            VERSION_STORAGE_PATH = builder.getPath();
        }
        catch (MalformedPathException e) {
            throw new InternalError("Cannot initialize path");
        }
    }

    private abstract class SourcedTarget {
        private SourcedTarget() {
        }

        public abstract Object run() throws RepositoryException;
    }

    public static final class DynamicESCFactory
    implements EventStateCollectionFactory {
        private DelegatingObservationDispatcher obsMgr;
        private SessionImpl source;

        public DynamicESCFactory(DelegatingObservationDispatcher obsMgr) {
            this.obsMgr = obsMgr;
        }

        public synchronized EventStateCollection createEventStateCollection() throws RepositoryException {
            if (this.source == null) {
                throw new RepositoryException("Unknown event source.");
            }
            return this.createEventStateCollection(this.source);
        }

        public EventStateCollection createEventStateCollection(SessionImpl source) {
            return this.obsMgr.createEventStateCollection(source, VERSION_STORAGE_PATH);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Object doSourced(SessionImpl eventSource, SourcedTarget runnable) throws RepositoryException {
            this.source = eventSource;
            try {
                Object object = runnable.run();
                return object;
            }
            finally {
                this.source = null;
            }
        }
    }
}

